/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.RecoverSliceController;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.TasksFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTask;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import java.time.format.DateTimeFormatter;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverSliceDialog
extends Dialog<ButtonType> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverSliceDialog.class);
    private static final DateTimeFormatter EXPIRATION_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private static final String ALL_PROJECTS = "All projects";
    @Nonnull
    private final TasksFactory tasksFactory;
    private final EventHandler<MouseEvent> mouseEventEventHandler = mouseEvent -> {
        if (mouseEvent.getClickCount() == 2) {
            this.recoverExperiment();
        }
    };
    @Nonnull
    private final TaskService taskService;
    @Nonnull
    private final RecoverSliceController controller;

    @Inject
    RecoverSliceDialog(@Nonnull GuiceFXMLUtil guiceFXMLUtil, @Nonnull TasksFactory tasksFactory, @Nonnull TaskService taskService, @Nonnull @Named(value="parentStage") Provider<Stage> parentStageProvider) {
        this.tasksFactory = tasksFactory;
        this.taskService = taskService;
        GuiceFXMLUtil.Result result = guiceFXMLUtil.createFromFXML(RecoverSliceController.class);
        this.controller = (RecoverSliceController)result.getController();
        this.controller.setOnDoubleClickEvent(mouseEvent -> this.recoverExperiment());
        this.initOwner((Window)parentStageProvider.get());
        this.setTitle("Recover an existing experiment");
        this.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.AMBULANCE, (Color)Color.GREEN));
        this.setHeaderText("Select the experiment(s) to recover.");
        this.setResizable(true);
        this.getDialogPane().setPrefSize(600.0, 500.0);
        this.getDialogPane().setContent((Node)result.getRoot());
        ButtonType refreshButtonType = new ButtonType("Refresh & Fetch exp. dates", ButtonBar.ButtonData.OTHER);
        ButtonType recoverButtonType = new ButtonType("Recover Experiment", ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{refreshButtonType, recoverButtonType, ButtonType.CANCEL});
        Button refreshButton = (Button)this.getDialogPane().lookupButton(refreshButtonType);
        refreshButton.setGraphic((Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.REFRESH, (Color)Color.GREEN).useGradientEffect());
        refreshButton.addEventFilter(ActionEvent.ACTION, event -> {
            this.controller.refreshSlicesList();
            event.consume();
        });
        Node recoverButton = this.getDialogPane().lookupButton(recoverButtonType);
        recoverButton.disableProperty().bind((ObservableValue)Bindings.isEmpty(this.controller.getSelectedSlices()));
        recoverButton.addEventFilter(ActionEvent.ACTION, event -> {
            this.recoverExperiment();
            event.consume();
        });
    }

    public void recoverExperiment() {
        assert (!this.controller.getSelectedSlices().isEmpty());
        for (Slice recoverSlice : this.controller.getSelectedSlices()) {
            if (recoverSlice != null) {
                RecoverSliceTask recoverSliceTask = this.tasksFactory.createRecoverSliceTask(recoverSlice);
                this.taskService.submitTask((Task<?>)recoverSliceTask);
                this.hide();
                continue;
            }
            LOG.error("Bug: No slice to recover selected");
        }
    }
}

