/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experimenter_gui.renew_report.RenewReportDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.util.TimeUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.collect.HashMultimap;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewSliceDialog
extends VBox {
    private static final Logger LOG = LoggerFactory.getLogger(RenewSliceDialog.class);
    @Nullable
    private final Window parentWindow;
    @Nonnull
    private final Dialog<ButtonType> dialog;
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final ExperimentController experimentController;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final RenewReportDialogFactory renewReportDialogFactory;
    @FXML
    private TableView<RenewableExperimentPart> authoritiesTableView;
    @FXML
    private TableColumn<RenewableExperimentPart, Boolean> selectionTableColumn;
    @FXML
    private TableColumn<RenewableExperimentPart, String> nameTableColumn;
    @FXML
    private TableColumn<RenewableExperimentPart, Instant> expirationTableColumn;
    @FXML
    private TableColumn<RenewableExperimentPart, Instant> durationTableColumn;
    @FXML
    protected ComboBox<Integer> hoursComboBox;
    @FXML
    protected ComboBox<Integer> minutesComboBox;
    @FXML
    protected ComboBox<Integer> daysComboBox;
    @FXML
    private Label sliceInfoLabel;
    @FXML
    private Label longDurationWarningLabel;
    @FXML
    private Label noRenewWarningLabel;
    @FXML
    private Label projectExpireSoonLabel;
    @Nonnull
    private final ObservableList<RenewableExperimentPart> renewableAuthorities;
    @Nonnull
    private final ObservableList<Server> unrenewableServers;
    private static final java.time.Duration DEFAULT_DURATION = java.time.Duration.ofHours(2L);

    RenewSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController, @Nonnull AuthorityFinder authorityFinder, @Nonnull RenewReportDialogFactory renewReportDialogFactory, @Nonnull SfaModel sfaModel) {
        if (experimentController.getExperiment().getSliceOrNull() == null) {
            throw new IllegalArgumentException("Can't create RenewSliceDialog if there experiment has slice == null");
        }
        this.parentWindow = parentWindow;
        this.renewReportDialogFactory = renewReportDialogFactory;
        this.experimentController = experimentController;
        this.sfaModel = sfaModel;
        this.slice = experimentController.getExperiment().getSliceOrNull();
        FXMLUtil.injectFXML((Object)((Object)this));
        DoubleBinding dividableWidth = this.authoritiesTableView.widthProperty().subtract((ObservableNumberValue)this.selectionTableColumn.widthProperty()).subtract(2);
        this.nameTableColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.375));
        this.expirationTableColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.25));
        this.durationTableColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.375));
        HashMultimap sliverPerAuthorityMap = HashMultimap.create();
        for (Sliver sliver : this.slice.getSliversCopy()) {
            Server sliverAuth = sliver.getServer();
            Object auth = authorityFinder.findByAnyUrn(sliverAuth.getDefaultComponentManagerAsGeniUrn(), AuthorityFinder.Purpose.STATUS);
            sliverPerAuthorityMap.put(auth, (Object)sliver);
        }
        this.unrenewableServers = FXCollections.observableArrayList();
        experimentController.getExperiment().getPartsStream().filter(experimentPart -> experimentPart instanceof SfaExperimentPart).map(experimentPart -> (SfaExperimentPart)experimentPart).map(SfaExperimentPart::getComponentManagerSfaAuthority).filter(server -> server.hasFlag(Server.Flag.workaroundNoRenew)).forEach(arg_0 -> this.unrenewableServers.add(arg_0));
        this.checkNoRenewWarning();
        this.renewableAuthorities = FXCollections.observableArrayList();
        experimentController.getExperiment().getPartsStream().filter(experimentPart -> {
            if (experimentPart instanceof SfaExperimentPart) {
                return !((SfaExperimentPart)experimentPart).getComponentManagerSfaAuthority().hasFlag(Server.Flag.workaroundNoRenew);
            }
            return true;
        }).map(RenewableExperimentPart::new).forEach(arg_0 -> this.renewableAuthorities.add(arg_0));
        this.authoritiesTableView.setItems(this.renewableAuthorities);
        this.authoritiesTableView.setPrefHeight((double)(26 + this.renewableAuthorities.size() * 25));
        this.selectionTableColumn.setCellValueFactory(param -> ((RenewableExperimentPart)param.getValue()).renewRequestedProperty());
        this.selectionTableColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.selectionTableColumn));
        this.nameTableColumn.setCellValueFactory(t -> new SimpleStringProperty(((RenewableExperimentPart)t.getValue()).getExperimentPart().getName()));
        this.expirationTableColumn.setCellValueFactory(param -> ((RenewableExperimentPart)param.getValue()).getExperimentPart().expirationTimeProperty());
        this.expirationTableColumn.setCellFactory(t -> new TableCell<RenewableExperimentPart, Instant>(){

            protected void updateItem(Instant date, boolean empty) {
                if (date == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(DateTimeUtils.DATE_HOUR_MINUTES_SECONDS_FORMATTER.format(LocalDateTime.ofInstant(date, ZoneId.systemDefault())));
                }
            }
        });
        this.durationTableColumn.setCellValueFactory(param -> ((RenewableExperimentPart)param.getValue()).getExperimentPart().expirationTimeProperty());
        this.durationTableColumn.setCellFactory((Callback)new Callback<TableColumn<RenewableExperimentPart, Instant>, TableCell<RenewableExperimentPart, Instant>>(){

            public TableCell<RenewableExperimentPart, Instant> call(TableColumn<RenewableExperimentPart, Instant> renewableAuthorityDateTableColumn) {
                return new TableCell<RenewableExperimentPart, Instant>(){
                    private Instant dateTime = null;
                    private final Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, actionEvent -> this.updateString(), new KeyValue[0]), new KeyFrame(new Duration(1000.0), new KeyValue[0])});
                    {
                        this.timeline.setCycleCount(-1);
                    }

                    protected void updateItem(Instant date, boolean empty) {
                        if (date == null || empty) {
                            this.timeline.stop();
                            this.dateTime = null;
                            this.setText("");
                        } else {
                            this.dateTime = date;
                            this.updateString();
                            this.timeline.play();
                        }
                    }

                    private void updateString() {
                        this.setText(DateTimeUtils.prettyPrintDuration(java.time.Duration.between(Instant.now(), this.dateTime).withNanos(0)));
                    }
                };
            }
        });
        Instant firstSliverExpire = null;
        Instant lastSliverExpire = null;
        for (Object auth : this.renewableAuthorities) {
            Instant expire = (Instant)((RenewableExperimentPart)auth).getExperimentPart().expirationTimeProperty().getValue();
            if (firstSliverExpire == null || firstSliverExpire.isAfter(expire)) {
                firstSliverExpire = expire;
            }
            if (lastSliverExpire != null && !lastSliverExpire.isBefore(expire)) continue;
            lastSliverExpire = expire;
        }
        java.time.Duration periodLeft = DEFAULT_DURATION;
        if (this.slice.getExpirationDate() != null) {
            periodLeft = java.time.Duration.between(Instant.now(), this.slice.getExpirationDate());
            long millisFromFirst = firstSliverExpire == null ? 0L : java.time.Duration.between(this.slice.getExpirationDate(), firstSliverExpire).abs().toMillis();
            long millisFromLast = lastSliverExpire == null ? 0L : java.time.Duration.between(this.slice.getExpirationDate(), lastSliverExpire).abs().toMillis();
            long millisFirstFromLast = firstSliverExpire == null || lastSliverExpire == null ? 0L : java.time.Duration.between(firstSliverExpire, lastSliverExpire).abs().toMillis();
            boolean expireNotSynced = millisFromFirst > 60000L || millisFromLast > 60000L || millisFirstFromLast > 1000L;
            String expireStr = DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(LocalDateTime.ofInstant(this.slice.getExpirationDate(), ZoneId.systemDefault()));
            if (expireNotSynced) {
                if (millisFirstFromLast > 1000L) {
                    this.sliceInfoLabel.setVisible(true);
                    this.sliceInfoLabel.setManaged(true);
                    this.sliceInfoLabel.setText(String.format("The expire dates of the different parts of your experiment are out of sync! Your experiment container (\"slice\") currently expires at %s. ", expireStr));
                } else {
                    this.sliceInfoLabel.setVisible(true);
                    this.sliceInfoLabel.setManaged(true);
                    this.sliceInfoLabel.setText(String.format("Your experiment container expires later than some parts of your experiment! Your experiment container (\"slice\") currently expires at %s.", expireStr));
                }
            } else {
                this.sliceInfoLabel.setVisible(false);
                this.sliceInfoLabel.setManaged(false);
                this.sliceInfoLabel.setText(String.format("Your experiment currently expires at %s", expireStr));
            }
        }
        this.daysComboBox.getItems().addAll((Collection)IntStream.range(0, 90).boxed().collect(Collectors.toList()));
        this.hoursComboBox.getItems().addAll((Collection)IntStream.range(0, 24).boxed().collect(Collectors.toList()));
        this.minutesComboBox.getItems().addAll((Collection)IntStream.range(0, 60).boxed().collect(Collectors.toList()));
        this.minutesComboBox.setConverter((StringConverter)new StringConverter<Integer>(){

            public String toString(Integer integer) {
                return String.format("%02d", integer);
            }

            public Integer fromString(String s) {
                return Integer.parseInt(s);
            }
        });
        long time = periodLeft.toMinutes();
        this.minutesComboBox.setValue((Object)((int)time % 60));
        this.hoursComboBox.setValue((Object)((int)(time /= 60L) % 24));
        this.daysComboBox.setValue((Object)((int)(time /= 24L)));
        ChangeListener durationChangeListener = (ov, o, n) -> this.checkLongDurationWarning();
        this.daysComboBox.getSelectionModel().selectedIndexProperty().addListener(durationChangeListener);
        this.hoursComboBox.getSelectionModel().selectedIndexProperty().addListener(durationChangeListener);
        this.minutesComboBox.getSelectionModel().selectedIndexProperty().addListener(durationChangeListener);
        this.checkProjectExpirationWarning();
        this.dialog = new Dialog();
        this.dialog.initOwner(parentWindow);
        this.dialog.setTitle("Renew Experiment");
        this.dialog.setHeaderText("Extend the experiment duration");
        this.dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CLOCK_ALT, (Color)Color.LAWNGREEN));
        this.dialog.getDialogPane().setContent((Node)this);
        this.dialog.setResizable(true);
        ButtonType renewButtonType = new ButtonType("Renew", ButtonBar.ButtonData.OK_DONE);
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{renewButtonType, ButtonType.CANCEL});
        this.dialog.show();
        this.dialog.resultProperty().addListener(observable -> {
            if (this.dialog.getResult() == renewButtonType) {
                this.doRenew();
            }
        });
    }

    public void checkLongDurationWarning() {
        java.time.Duration maxExpirationDuration;
        java.time.Duration curExpirationDuration = java.time.Duration.ofDays(((Integer)this.daysComboBox.getSelectionModel().getSelectedItem()).intValue()).plusHours(((Integer)this.hoursComboBox.getSelectionModel().getSelectedItem()).intValue()).plusMinutes(((Integer)this.minutesComboBox.getSelectionModel().getSelectedItem()).intValue()).plusSeconds(59L);
        boolean tooLong = curExpirationDuration.compareTo(maxExpirationDuration = java.time.Duration.ofDays(90L)) >= 0;
        this.longDurationWarningLabel.setVisible(tooLong);
    }

    public void checkNoRenewWarning() {
        boolean noRenew;
        boolean bl = noRenew = !this.unrenewableServers.isEmpty();
        if (this.unrenewableServers.size() > 1) {
            this.noRenewWarningLabel.setText("The following AMs do not support Renew, trying to renew will always fail: \n" + this.unrenewableServers.stream().map(Server::getName).collect(Collectors.joining(", ")));
        } else if (this.unrenewableServers.size() == 1) {
            this.noRenewWarningLabel.setText("The \"" + ((Server)this.unrenewableServers.get(0)).getName() + "\" AM does not support Renew. Trying to renew will always fail.");
        } else {
            this.noRenewWarningLabel.setText("All servers support Renew.");
        }
        this.noRenewWarningLabel.setVisible(noRenew);
    }

    public void checkProjectExpirationWarning() {
        boolean expireSoon;
        Instant projectExpiration;
        String projectName = this.experimentController.getExperiment().getSlice().getProjectName();
        GeniUrn projectUrn = this.experimentController.getExperiment().getSlice().getProjectUrn();
        Instant instant = projectExpiration = projectUrn == null ? null : this.sfaModel.getProjectExpiration(projectUrn);
        if (projectExpiration == null) {
            this.projectExpireSoonLabel.setVisible(false);
            return;
        }
        java.time.Duration duration = java.time.Duration.between(Instant.now(), projectExpiration);
        String humanExpire = TimeUtils.formatMillis((long)duration.toMillis(), (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MINUTES, (int)2);
        boolean bl = expireSoon = duration.toMillis() < java.time.Duration.of(90L, ChronoUnit.DAYS).toMillis();
        if (!expireSoon) {
            this.projectExpireSoonLabel.setVisible(false);
            return;
        }
        this.projectExpireSoonLabel.setText("Your project \"" + projectName + "\" expires in " + humanExpire + ". You will not be able to renew the experiment past your project expiration date.");
        this.projectExpireSoonLabel.setVisible(true);
    }

    public void showDialog() {
        this.dialog.show();
    }

    public void doRenew() {
        final Instant newExpirationTime = ZonedDateTime.now().plusDays(((Integer)this.daysComboBox.getSelectionModel().getSelectedItem()).intValue()).plusHours(((Integer)this.hoursComboBox.getSelectionModel().getSelectedItem()).intValue()).plusMinutes(((Integer)this.minutesComboBox.getSelectionModel().getSelectedItem()).intValue()).plusSeconds(15L).toInstant();
        List selectedParts = this.renewableAuthorities.stream().filter(RenewableExperimentPart::getRenewRequested).map(RenewableExperimentPart::getExperimentPart).collect(Collectors.toList());
        boolean renewAll = this.renewableAuthorities.stream().allMatch(RenewableExperimentPart::getRenewRequested);
        Instant firstExpirationTime = selectedParts.stream().map(ExperimentPart::getExpirationTime).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(this.slice.getExpirationDate());
        if (firstExpirationTime != null && newExpirationTime.isBefore(firstExpirationTime)) {
            int[] timeLeft = DateTimeUtils.getSecondsMinutesHoursDays(java.time.Duration.between(Instant.now(), firstExpirationTime));
            Optional result = JFDialogs.create().owner(this.parentWindow).masthead("Abnormal experiment renewal").message(String.format("The new expiration duration is shorter thant the current one (%d days, %d hours and %d minutes).\n\nIs this what you want?", timeLeft[3], timeLeft[2], timeLeft[1])).buttonTypes(new ButtonType[]{ButtonType.YES, ButtonType.NO}).showWarning();
            if (result.orElse(ButtonType.NO) != ButtonType.YES) {
                this.dialog.show();
                return;
            }
        }
        if (renewAll) {
            LOG.debug("RenewSliceDialog will request experimentController to renew, and show renew report afterwards");
            CompletableFuture future = this.experimentController.renew(newExpirationTime);
            future.whenCompleteAsync(new BiConsumer<ExperimentTaskStatus, Throwable>(){

                @Override
                public void accept(ExperimentTaskStatus experimentTaskStatus, Throwable throwable) {
                    LOG.debug("RenewSliceDialog will show renew report. experimentTaskStatus={} has throwable={}", (Object)experimentTaskStatus, (Object)(throwable != null ? 1 : 0));
                    if (throwable != null) {
                        RenewSliceDialog.this.renewReportDialogFactory.showDialog(newExpirationTime, RenewSliceDialog.this.experimentController, throwable, RenewSliceDialog.this.sfaModel);
                    } else {
                        RenewSliceDialog.this.renewReportDialogFactory.showDialog(newExpirationTime, RenewSliceDialog.this.experimentController, experimentTaskStatus, RenewSliceDialog.this.sfaModel);
                    }
                }
            }, Platform::runLater);
        } else {
            this.experimentController.renewParts(newExpirationTime, selectedParts);
        }
    }

    private static class RenewableExperimentPart {
        @Nonnull
        private final ExperimentPart experimentPart;
        private final BooleanProperty renewRequested = new SimpleBooleanProperty(true);

        public RenewableExperimentPart(@Nonnull ExperimentPart experimentPart) {
            this.experimentPart = experimentPart;
        }

        @Nonnull
        public ExperimentPart getExperimentPart() {
            return this.experimentPart;
        }

        public boolean getRenewRequested() {
            return this.renewRequested.get();
        }

        public BooleanProperty renewRequestedProperty() {
            return this.renewRequested;
        }

        public void setRenewRequested(boolean renewRequested) {
            this.renewRequested.set(renewRequested);
        }
    }
}

