/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.bundle.InMemorySimpleESpecBundle;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.JFedEnvironment;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.DataConversionUtils;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.StackPane;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunSshCommandController
extends StackPane {
    private static final Logger LOG = LoggerFactory.getLogger(RunSshCommandController.class);
    @Nonnull
    private final HighLevelTaskFactory hltf;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final JFedEnvironment environment;
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final JFedHLPreferences preferences;
    @Nonnull
    private final JFedGuiConfig guiConfig;
    private EventHandler<ActionEvent> actionEventHandler;
    @Nonnull
    private final BrowserUtil browserUtil;
    private BooleanProperty valid;
    @FXML
    private TextField nicknameField;
    @FXML
    private TextArea commandArea;
    @FXML
    private Label nicknameLabel;
    @FXML
    private TableView<Node> nodeCheckboxes;
    @FXML
    private TableColumn<Node, String> nodeNameTableColumn;
    @FXML
    private TableColumn<Node, Boolean> nodeSelectedTableColumn;
    private final ObservableList<Node> nodes;
    private static String lastCommandCache;

    @Inject
    RunSshCommandController(@Nonnull HighLevelTaskFactory hltf, @Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaModel sfaModel, @Nonnull JFedEnvironment environment, @Nonnull JFedGuiConfig config, @Nonnull JFedHLPreferences preferences, @Nonnull JFedGuiConfig guiConfig, @Nonnull BrowserUtil browserUtil) {
        this.hltf = hltf;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.environment = environment;
        this.config = config;
        this.preferences = preferences;
        this.guiConfig = guiConfig;
        this.browserUtil = browserUtil;
        this.nodes = FXCollections.observableArrayList();
    }

    @FXML
    public void initialize() {
        this.valid = new SimpleBooleanProperty(true);
        this.nicknameField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldVal, String newVal) {
                RunSshCommandController.this.nicknameLabel.setText("Script will be stored in " + newVal + ".sh and logged to " + newVal + ".log");
            }
        });
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(System.currentTimeMillis() / 1000L);
        String rnd = DataConversionUtils.encodeBase64((byte[])buffer.array());
        rnd = rnd.replaceFirst("^A*", "").replace("+", "-").replace("/", "_").replace("=", "");
        this.nicknameField.setText("cmd-" + rnd);
        String defaultText = "#!/bin/bash -e\necho hello world\necho hello world 2";
        this.commandArea.setText(lastCommandCache != null ? lastCommandCache : defaultText);
        this.nodeCheckboxes.setItems(this.nodes);
        this.nodeNameTableColumn.setCellValueFactory(t -> ((Node)t.getValue()).clientIdProperty());
        this.nodeSelectedTableColumn.setCellValueFactory(t -> ((Node)t.getValue()).selectedProperty());
        this.nodeSelectedTableColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.nodeSelectedTableColumn));
    }

    public void setOnAction(EventHandler<ActionEvent> actionEventHandler) {
        this.actionEventHandler = actionEventHandler;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public BooleanProperty validProperty() {
        return this.valid;
    }

    @Nonnull
    public ESpecBundle getESpecBundle() {
        String command;
        String nick = this.nicknameField.getText();
        lastCommandCache = command = this.commandArea.getText();
        Object indentedCommand = TextUtil.indent((int)4, (String)command);
        if (!((String)indentedCommand).endsWith("\n")) {
            indentedCommand = (String)indentedCommand + "\n";
        }
        List clientIds = this.nodes.stream().filter(Node::isSelected).map(Node::getClientId).collect(Collectors.toList());
        String clientIdsJsonList = "[ " + clientIds.stream().map(ci -> "\"" + ci + "\"").collect(Collectors.joining(", ")) + " ]";
        String espec = "version: 1.0-basic\nrspec: ignored.rspec\nexecute: \n- direct: |\n" + (String)indentedCommand + "  path: " + nick + ".sh\n  nodes: " + clientIdsJsonList + "\n";
        LOG.debug("getESpecBundle() espec=>\n****\n" + espec + "\n****");
        return new InMemorySimpleESpecBundle(espec);
    }

    public void setExperimentController(@Nonnull ExperimentController experimentController) {
        this.nodes.clear();
        if (experimentController.getExperiment().getExistingRequestRspecSource() != null) {
            experimentController.getExperiment().getExistingRequestRspecSource().getImmutableModelRspec().getNodes().stream().map(x$0 -> new Node((RspecNode)x$0)).forEach(arg_0 -> this.nodes.add(arg_0));
        } else if (experimentController.getExperiment().getNewRequestRspecSource() != null) {
            experimentController.getExperiment().getNewRequestRspecSource().getImmutableModelRspec().getNodes().stream().map(x$0 -> new Node((RspecNode)x$0)).forEach(arg_0 -> this.nodes.add(arg_0));
        }
        this.nodes.sort(Comparator.comparing(Node::getClientId));
    }

    private class Node {
        @Nonnull
        private final RspecNode rspecNode;
        private final StringProperty clientId = new SimpleStringProperty("unknown");
        private final BooleanProperty selected = new SimpleBooleanProperty(true);

        private Node(RspecNode rspecNode) {
            this.rspecNode = rspecNode;
            this.clientId.setValue(rspecNode.getClientId());
        }

        public boolean getSelected() {
            return this.selected.get();
        }

        public BooleanProperty selectedProperty() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected.set(selected);
        }

        public boolean isSelected() {
            return this.selected.get();
        }

        @Nonnull
        public String getClientId() {
            return this.rspecNode.getClientId();
        }

        @Nonnull
        public RspecNode getRspecNode() {
            return this.rspecNode;
        }

        public ObservableValue<String> clientIdProperty() {
            return this.clientId;
        }
    }
}

