/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.RunSshCommandController;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenESpecEvent;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.UIUtils;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import com.google.common.eventbus.EventBus;
import java.net.MalformedURLException;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunSshCommandDialog
extends Dialog<ButtonType> {
    private static final Logger LOG = LoggerFactory.getLogger(RunSshCommandDialog.class);
    @Nonnull
    private final RunSshCommandController controller;
    @Nonnull
    private final JFedPreferences jFedPreferences;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final EventBus eventBus;
    private ExperimentController experimentController;

    @Inject
    public RunSshCommandDialog(@Nonnull GuiceFXMLUtil guiceFXMLUtil, @Nonnull JFedPreferences jFedPreferences, @Nonnull AuthorityFinder authorityFinder, @Nonnull GeniUserProvider geniUserProvider, @Nonnull EventBus eventBus) {
        this.jFedPreferences = jFedPreferences;
        this.authorityFinder = authorityFinder;
        this.geniUserProvider = geniUserProvider;
        this.eventBus = eventBus;
        GuiceFXMLUtil.Result result = guiceFXMLUtil.createFromFXML(RunSshCommandController.class);
        this.controller = (RunSshCommandController)((Object)result.getController());
        this.setTitle("Multi Command");
        this.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL, (Color)Color.DARKGREEN));
        this.setHeaderText("Execute a command on multiple nodes using SSH");
        this.getDialogPane().setContent((Node)UIUtils.wrapWithDecorationPane((Node)result.getRoot()));
        this.setResizable(true);
        ButtonType runCommandAction = new ButtonType("Run SSH Command", ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{runCommandAction, ButtonType.CANCEL});
        Button runCommandButton = (Button)this.getDialogPane().lookupButton(runCommandAction);
        runCommandButton.disableProperty().bind((ObservableValue)this.controller.validProperty().not());
        EventHandler openESpecEventHandler = event -> {
            if (this.controller.isValid()) {
                this.runSshCommand();
            }
            event.consume();
        };
        runCommandButton.addEventFilter(ActionEvent.ACTION, openESpecEventHandler);
        this.controller.setOnAction((EventHandler<ActionEvent>)openESpecEventHandler);
    }

    private void runSshCommand() {
        this.hide();
        try {
            OpenESpecEvent openESpecEvent = new OpenESpecEvent(this.experimentController, this.controller.getESpecBundle());
            LOG.info("User pressed \"Run Ssh command\" button: {}", (Object)openESpecEvent);
            this.eventBus.post((Object)openESpecEvent);
        }
        catch (MalformedURLException e) {
            LOG.error("User pressed \"Run Ssh command\" button, but caused MalformedURLException.", (Throwable)e);
        }
    }

    public void setExperimentController(@Nonnull ExperimentController experimentController) {
        this.experimentController = experimentController;
        this.controller.setExperimentController(experimentController);
    }
}

