/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.StyledCheckBoxListCell;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class SelectAuthoritiesController {
    private final ObservableList<SelectableAuthority> selectableAuthorities = FXCollections.observableArrayList();
    private final IntegerProperty selectedAuthoritiesCount = new SimpleIntegerProperty();
    private final TestbedInfoSource testbedInfoSource;
    private final JFedGuiConfig jFedGuiConfig;
    private final SfaModel sfaModel;
    @FXML
    private VBox root;
    @FXML
    private Label headerLabel;
    @FXML
    private ListView<SelectableAuthority> authoritiesListView;
    private StringProperty headerLabelText = new SimpleStringProperty("Could not automatically detect which authorities are involved. Please select the authorities which contain (parts of) your experiment:");

    @Inject
    SelectAuthoritiesController(TestbedInfoSource testbedInfoSource, JFedGuiConfig jFedGuiConfig, SfaModel sfaModel) {
        this.testbedInfoSource = testbedInfoSource;
        this.jFedGuiConfig = jFedGuiConfig;
        this.sfaModel = sfaModel;
    }

    @FXML
    private void initialize() {
        this.headerLabel.textProperty().bindBidirectional((Property)this.headerLabelText);
        Set serverIdInResources = this.jFedGuiConfig.getAllServersInVisibleResources().stream().map(PrimaryIdObject::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Set hiddenServerIds = this.jFedGuiConfig.getHiddenServers().stream().map(PrimaryIdObject::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Set recentlyUsedServerIds = this.sfaModel.getSlices().stream().flatMap(Slice::getSliversStream).map(Sliver::getServer).map(PrimaryIdObject::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        this.selectableAuthorities.addAll((Collection)this.testbedInfoSource.getServers().stream().filter(s -> !s.isEdgeVlan()).map(x$0 -> new SelectableAuthority((Server)x$0)).map(sa -> sa.setHidden(hiddenServerIds.contains(sa.getServerId()))).map(sa -> sa.setVisible(serverIdInResources.contains(sa.getServerId()))).map(sa -> sa.setRecentlyUsed(recentlyUsedServerIds.contains(sa.getServerId()))).sorted(Comparator.comparingInt(SelectableAuthority::getSortInt).thenComparing(SelectableAuthority::getServerName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList()));
        this.authoritiesListView.setItems(this.selectableAuthorities);
        this.authoritiesListView.setCellFactory(StyledCheckBoxListCell.forListView(SelectableAuthority::selectedProperty, new StringConverter<SelectableAuthority>(){

            public String toString(SelectableAuthority selectableAuthority) {
                return selectableAuthority.getExactSfaAuthority().getName();
            }

            public SelectableAuthority fromString(String s) {
                return null;
            }
        }, new StyledCheckBoxListCell.StyleProvider<SelectableAuthority>(){

            @Override
            @Nonnull
            public List<String> getStyleClasses(SelectableAuthority item) {
                ArrayList<String> res = new ArrayList<String>();
                if (item.isRecentlyUsed()) {
                    res.add("styled-checkbox-listcell-strong");
                }
                if (item.isHidden()) {
                    res.add("styled-checkbox-listcell-strike");
                }
                if (!item.isVisible()) {
                    res.add("styled-checkbox-listcell-fade");
                }
                if (res.isEmpty()) {
                    return Arrays.asList("styled-checkbox-listcell-normal");
                }
                return res;
            }
        }));
    }

    public VBox getRoot() {
        return this.root;
    }

    public int getSelectedAuthoritiesCount() {
        return this.selectedAuthoritiesCount.get();
    }

    public IntegerProperty selectedAuthoritiesCountProperty() {
        return this.selectedAuthoritiesCount;
    }

    public String getHeaderLabelText() {
        return (String)this.headerLabelText.get();
    }

    public StringProperty headerLabelTextProperty() {
        return this.headerLabelText;
    }

    public void setHeaderLabelText(String headerLabelText) {
        this.headerLabelText.set((Object)headerLabelText);
    }

    public Set<Server> getSelectedServers() {
        return this.selectableAuthorities.stream().filter(SelectableAuthority::getSelected).map(SelectableAuthority::getExactSfaAuthority).collect(Collectors.toSet());
    }

    private class SelectableAuthority {
        private final BooleanProperty selected = new SimpleBooleanProperty(false);
        private final Server sfaAuthority;
        private boolean visible;
        private boolean recentlyUsed;
        private boolean hidden;

        private SelectableAuthority(Server sfaAuthority) {
            this.sfaAuthority = sfaAuthority;
            this.selected.addListener((observable, oldValue, newValue) -> {
                if (newValue != oldValue) {
                    if (newValue.booleanValue()) {
                        SelectAuthoritiesController.this.selectedAuthoritiesCount.set(SelectAuthoritiesController.this.selectedAuthoritiesCount.get() + 1);
                    } else {
                        SelectAuthoritiesController.this.selectedAuthoritiesCount.set(SelectAuthoritiesController.this.selectedAuthoritiesCount.get() - 1);
                    }
                }
            });
            this.visible = true;
            this.recentlyUsed = false;
            this.hidden = false;
        }

        public boolean getSelected() {
            return this.selected.get();
        }

        public void setSelected(boolean selected) {
            this.selected.set(selected);
        }

        public BooleanProperty selectedProperty() {
            return this.selected;
        }

        public Server getExactSfaAuthority() {
            return this.sfaAuthority;
        }

        public Integer getServerId() {
            return this.sfaAuthority == null ? null : (Integer)this.sfaAuthority.getId();
        }

        public String getServerName() {
            return this.sfaAuthority == null ? null : this.sfaAuthority.getName();
        }

        public boolean isVisible() {
            return this.visible;
        }

        public SelectableAuthority setVisible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public SelectableAuthority setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public boolean isRecentlyUsed() {
            return this.recentlyUsed;
        }

        public SelectableAuthority setRecentlyUsed(boolean recentlyUsed) {
            this.recentlyUsed = recentlyUsed;
            return this;
        }

        public int getSortInt() {
            if (this.recentlyUsed) {
                return 0;
            }
            if (this.hidden || !this.visible) {
                return 2;
            }
            return 1;
        }
    }
}

