/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.SelectAuthoritiesController;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.paint.Color;
import javax.inject.Inject;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAuthoritiesDialog
extends Dialog<Set<Server>> {
    private static final Logger LOG = LoggerFactory.getLogger(SelectAuthoritiesDialog.class);
    private final GuiceFXMLUtil guiceFXMLUtil;
    private final SelectAuthoritiesController controller;

    @Inject
    SelectAuthoritiesDialog(GuiceFXMLUtil guiceFXMLUtil) {
        this.guiceFXMLUtil = guiceFXMLUtil;
        GuiceFXMLUtil.Result result = guiceFXMLUtil.createFromFXML(SelectAuthoritiesController.class);
        this.controller = (SelectAuthoritiesController)result.getController();
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)result.getRoot());
        dialogPane.setHeaderText("Select the involved authorities");
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.AMBULANCE, (Color)Color.GREEN));
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Node okButton = dialogPane.lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)this.controller.selectedAuthoritiesCountProperty().isEqualTo(0));
        this.setDialogPane(dialogPane);
        this.setResizable(true);
        this.setResultConverter(buttonType -> {
            if (buttonType == ButtonType.CANCEL) {
                return null;
            }
            return this.controller.getSelectedServers();
        });
    }
}

