/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experimenter_gui.util.WaitForTaskExecutionsTask;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSliceMembersTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSubAuthorityMembersTask;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareSliceDialog
extends VBox {
    private static final Logger LOG = LoggerFactory.getLogger(ShareSliceDialog.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final ExperimentController experimentController;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final HighLevelTaskFactory hltf;
    @FXML
    private ListView<SelectableUser> usersList;
    @FXML
    private HBox initializingBox;
    @FXML
    private CheckBox addSshKeysCheckBox;
    @FXML
    private Label helpLabel;
    private final Dialog<ButtonType> dialog;
    private final ButtonType shareType = new ButtonType("Share", ButtonBar.ButtonData.OK_DONE);
    private final IntegerProperty selectedNewUsersCount = new SimpleIntegerProperty(0);

    ShareSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController, @Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaModel sfaModel, @Nonnull HighLevelTaskFactory hltf) {
        if (experimentController.getExperiment().getSliceOrNull() == null) {
            throw new IllegalArgumentException("Can't create RenewSliceDialog if there experiment has slice == null");
        }
        this.experimentController = experimentController;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.slice = experimentController.getExperiment().getSliceOrNull();
        FXMLUtil.injectFXML((Object)((Object)this));
        this.usersList.setCellFactory((Callback)new Callback<ListView<SelectableUser>, ListCell<SelectableUser>>(){

            public ListCell<SelectableUser> call(ListView<SelectableUser> param) {
                return new CheckBoxListCell<SelectableUser>(SelectableUser::selectedProperty){

                    public void updateItem(SelectableUser item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setDisable(item.isFixed());
                        }
                    }
                };
            }
        });
        WaitForTaskExecutionsTask waitTask = new WaitForTaskExecutionsTask(){

            @Override
            public void onTaskExecutionsFinished() {
                Platform.runLater(() -> {
                    ShareSliceDialog.this.updateUsersList();
                    ShareSliceDialog.this.initializingBox.setVisible(false);
                });
            }
        };
        this.initializingBox.setVisible(true);
        ListSliceMembersTask listSliceMembersTask = this.hltf.listSliceMembers(experimentController.getExperiment().getSliceOrNull());
        waitTask.addTaskExecution(this.hltf.submitTask((Task)listSliceMembersTask));
        if (sfaModel.getUsersBySubAuthority(experimentController.getExperiment().getSubAuthName()).isEmpty()) {
            ListSubAuthorityMembersTask listSubAuthorityMembersTask = this.hltf.listSubAuthorityMembers(experimentController.getExperiment().getSubAuthName());
            waitTask.addTaskExecution(this.hltf.submitTask((Task)listSubAuthorityMembersTask));
        }
        ArrayList<String> noShareAuthorityNames = new ArrayList<String>();
        for (ExperimentPart experimentPart : experimentController.getExperiment().getPartsListCopy()) {
            SfaExperimentPart sfaExperimentPart;
            if (!(experimentPart instanceof SfaExperimentPart) || !(sfaExperimentPart = (SfaExperimentPart)experimentPart).getConnectSfaAuthority().hasFlag(Server.Flag.workaroundNoSliceSharingAllowedOnAM) || sfaExperimentPart.getConnectSfaAuthority().isEdgeVlan()) continue;
            noShareAuthorityNames.add(experimentPart.getName());
        }
        new Thread(null, (Runnable)((Object)waitTask), "ShareSlice-WaitForBTaskExecutionsTasks").start();
        String sliceProject = this.slice.getSubAuthorityName();
        Server userAuthServer = geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        String authName = userAuthServer == null ? null : userAuthServer.getName();
        String helpText = "Sharing an experiment has some limitations:\n- You can only share with users of the same authority (" + authName + ")\n";
        if (sliceProject != null) {
            helpText = helpText + "- You can only share with users that are member of the \"" + sliceProject + "\" project in which this experiment was created.\n";
        }
        if (!noShareAuthorityNames.isEmpty()) {
            helpText = helpText + "- " + Joiner.on((String)", ").join(noShareAuthorityNames) + (noShareAuthorityNames.size() == 1 ? " does" : " do") + " not support shared experiments\n";
        }
        this.helpLabel.setText(helpText);
        this.dialog = new Dialog();
        this.dialog.initOwner(parentWindow);
        this.dialog.setTitle("Share Experiment");
        this.dialog.setHeaderText("Share your experiment");
        this.dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.AMBULANCE, (Color)Color.GREEN));
        this.dialog.getDialogPane().setContent((Node)this);
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{this.shareType, ButtonType.CANCEL});
        Node shareButton = this.dialog.getDialogPane().lookupButton(this.shareType);
        shareButton.disableProperty().bind((ObservableValue)this.selectedNewUsersCount.isEqualTo(0));
        this.dialog.resultProperty().addListener(observable -> {
            if (this.dialog.getResult() == this.shareType) {
                List selectedUsers = this.usersList.getItems().stream().filter(SelectableUser::getSelected).map(SelectableUser::getUrn).collect(Collectors.toList());
                selectedUsers.removeAll(experimentController.getExperiment().getSliceOrNull().getUsers());
                if (!selectedUsers.isEmpty()) {
                    experimentController.shareWithUsers(selectedUsers, this.addSshKeysCheckBox.isSelected());
                } else {
                    LOG.warn("Unexpectedly got an empty list of new project members");
                }
            }
        });
    }

    @FXML
    private void addCustomUser() {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setHeaderText("Share experiment to custom user");
        dialog.setContentText("Username:");
        dialog.getEditor().textProperty().addListener((observable, oldValue, newValue) -> {
            String strippedValue = newValue.replaceAll("[^A-Za-z0-9_-]", "");
            if (!Objects.equals(strippedValue, newValue)) {
                dialog.getEditor().setText(strippedValue);
            }
        });
        dialog.showAndWait().ifPresent(username -> {
            GeniUrn curUserUrn = this.geniUserProvider.getLoggedInGeniUser().getUserUrn();
            GeniUrn newUserUrn = GeniUrn.createGeniUrnFromEncodedParts((String)curUserUrn.getEncodedTopLevelAuthority(), (String)"user", (String)username);
            Optional<SelectableUser> existingUser = this.usersList.getItems().stream().filter(su -> Objects.equals(su.getUrn(), newUserUrn)).findFirst();
            if (!existingUser.isPresent()) {
                SelectableUser newSelectableUser = new SelectableUser(newUserUrn, true, false);
                this.usersList.getItems().add((Object)newSelectableUser);
                this.usersList.scrollTo((Object)newSelectableUser);
            } else {
                new Alert(Alert.AlertType.ERROR, "The user already exists in the list!", new ButtonType[0]).showAndWait();
                this.usersList.scrollTo((Object)existingUser.get());
            }
        });
    }

    private void updateUsersList() {
        assert (!this.experimentController.getExperiment().getSliceOrNull().getUsers().isEmpty());
        assert (!this.sfaModel.getUsersBySubAuthority(this.experimentController.getExperiment().getSubAuthName()).isEmpty());
        this.usersList.getItems().clear();
        Slice slice = this.experimentController.getExperiment().getSliceOrNull();
        Collection<Object> currentMembers = slice == null ? Collections.emptyList() : slice.getUsers();
        for (GeniUrn geniUrn : currentMembers) {
            this.usersList.getItems().addAll((Object[])new SelectableUser[]{new SelectableUser(geniUrn, true, true)});
        }
        ArrayList candidateMembers = new ArrayList(this.sfaModel.getUsersBySubAuthority(this.experimentController.getExperiment().getSubAuthName()));
        candidateMembers.removeAll(currentMembers);
        for (GeniUrn candidateMember : candidateMembers) {
            this.usersList.getItems().addAll((Object[])new SelectableUser[]{new SelectableUser(candidateMember, false, false)});
        }
        this.usersList.getItems().sort(Comparator.comparing(SelectableUser::isFixed).reversed().thenComparing(SelectableUser::getSelected).thenComparing(su -> su.getUrn().getResourceName().toLowerCase()));
    }

    public void showDialog() {
        this.dialog.show();
    }

    private final class SelectableUser {
        private final GeniUrn urn;
        private final BooleanProperty selected = new SimpleBooleanProperty(false);
        private final boolean fixed;

        public SelectableUser(GeniUrn urn, boolean selected, boolean fixed) {
            this.fixed = fixed;
            if (!fixed) {
                this.selected.addListener((observable, oldValue, newValue) -> {
                    if (oldValue != newValue) {
                        if (newValue.booleanValue()) {
                            ShareSliceDialog.this.selectedNewUsersCount.set(ShareSliceDialog.this.selectedNewUsersCount.get() + 1);
                        } else {
                            ShareSliceDialog.this.selectedNewUsersCount.set(ShareSliceDialog.this.selectedNewUsersCount.get() - 1);
                        }
                    }
                });
            }
            this.selected.set(selected);
            this.urn = urn;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public boolean getSelected() {
            return this.selected.get();
        }

        public BooleanProperty selectedProperty() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected.set(selected);
        }

        public GeniUrn getUrn() {
            return this.urn;
        }

        public String toString() {
            return this.urn.getResourceName();
        }
    }
}

