/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.GDPRDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.JFedBrowser;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.JFedEnvironment;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.GetSubAuthorityDetailsTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSubAuthoritiesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSubAuthorityMembersTask;
import be.iminds.ilabt.jfed.highlevel.util.FXPlatformUtil;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.TestbedGdprConsentPreferences;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.util.TimeUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Pair;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.reactfx.AwaitingEventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartExperimentController
extends GridPane {
    private static final Logger LOG = LoggerFactory.getLogger(StartExperimentController.class);
    private static final Duration MINIMUM_SLICE_DURATION = Duration.ofMinutes(1L);
    private static final int MAX_DURATION_DAYS = 89;
    private final HighLevelTaskFactory hltf;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;
    private final JFedEnvironment environment;
    private final JFedGuiConfig config;
    private final JFedHLPreferences preferences;
    @Nonnull
    private final TestbedGdprConsentPreferences testbedGdprConsentPreferences;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final GDPRDialogFactory gdprDialogFactory;
    private final ObservableMap<String, Slice> slices = FXCollections.observableHashMap();
    private final ListChangeListener<Slice> sliceListChangeListener = c -> {
        while (c.next()) {
            c.getAddedSubList().forEach(slice -> this.slices.put((Object)slice.getName(), slice));
            c.getRemoved().forEach(slice -> this.slices.remove((Object)slice.getName()));
        }
    };
    private int maximumSliceNameLength = 8;
    @Nullable
    private Collection<Testbed> gdprTestbeds = null;
    @Nullable
    private Collection<Testbed> involvedTestbeds = null;
    private boolean allServersSupportProvisionSshKeys = true;
    private boolean someServersSupportProvisionSshKeys = true;
    private int[] durationOfNonExistingSlice = null;
    private boolean forceShowGdprTestbeds = false;
    private boolean hasLinks = false;
    @FXML
    protected TextField nameTextField;
    @FXML
    protected Button showExistingSlicesButton;
    @FXML
    protected ComboBox<Integer> hoursComboBox;
    @FXML
    protected ComboBox<Integer> minutesComboBox;
    @FXML
    protected ComboBox<Integer> daysComboBox;
    @FXML
    protected Label subAuthLabel;
    @FXML
    protected CheckBox subAuthCheckBox;
    @FXML
    protected ProgressBar subAuthFetchProgressBar;
    @FXML
    protected ComboBox<String> subAuthComboBox;
    @FXML
    protected Button refreshSubAuthButton;
    @FXML
    protected Label projectExpirationLabel;
    @FXML
    protected RowConstraints projectExpirationRowConstraint;
    @FXML
    protected CheckBox autoshareCheckBox;
    @FXML
    protected Label autoshareSupportWarning;
    @FXML
    protected CheckBox requestSlaCheckBox;
    @FXML
    protected CheckBox linkTestRequestedCheckBox;
    private int userSetDays = 0;
    private int userSetHours = 2;
    private int userSetMinutes = 0;
    @FXML
    VBox gdprList;
    @FXML
    Label noterms;
    @FXML
    Parent checkterms;
    private final InvalidationListener expirationDateTimeInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            StartExperimentController.this.userSetDays = (Integer)StartExperimentController.this.daysComboBox.getValue();
            StartExperimentController.this.userSetHours = (Integer)StartExperimentController.this.hoursComboBox.getValue();
            StartExperimentController.this.userSetMinutes = (Integer)StartExperimentController.this.minutesComboBox.getValue();
        }
    };
    private final ValidationSupport validationSupport;
    private final boolean canRequestProjectMemberSshKeys;
    private boolean prevRequestProjectMemberSshKeysValue;
    private boolean autoSetShareCheckbox = true;
    private Subscription sliceNameTextSubsciption;
    private boolean sliceExpirationEditingEnabled = false;
    private boolean sliceDetailsEditingEnabled = false;
    private final Validator<String> sliceNameValidator = (control, sliceName) -> {
        ValidationResult result = new ValidationResult();
        if (sliceName == null) {
            result.add(ValidationMessage.error((Control)control, (String)"Experiment name cannot be empty!"));
            return result;
        }
        if (this.slices.containsKey(sliceName)) {
            return result;
        }
        if (sliceName.length() == 0) {
            result.add(ValidationMessage.error((Control)control, (String)"Experiment name cannot be empty!"));
        } else if (sliceName.length() > this.maximumSliceNameLength) {
            if (this.maximumSliceNameLength > 5) {
                result.add(ValidationMessage.error((Control)control, (String)String.format("Experiment name cannot be longer than %d characters", this.maximumSliceNameLength)));
            } else if (this.maximumSliceNameLength <= 0) {
                result.add(ValidationMessage.error((Control)control, (String)String.format("Your nodes names are too long!Try to remove at least %d chars from the longest node name(s)", 3 - this.maximumSliceNameLength)));
            } else {
                result.add(ValidationMessage.error((Control)control, (String)String.format("Experiment name cannot be longer than %d characters. You can try to shorten node names to increase this limit.", this.maximumSliceNameLength)));
            }
        }
        for (char c : sliceName.toCharArray()) {
            boolean validChar;
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
            if (validChar) continue;
            result.add(ValidationMessage.error((Control)control, (String)String.format("Experiment name may not contain the character '%c'. Only characters [a-zA-Z0-9] are allowed", Character.valueOf(c))));
        }
        return result;
    };
    private final boolean ALWAYS_SHOW_TESTBEDS = true;

    @Inject
    StartExperimentController(HighLevelTaskFactory hltf, GeniUserProvider geniUserProvider, SfaModel sfaModel, JFedEnvironment environment, JFedGuiConfig config, JFedHLPreferences preferences, @Nonnull AuthorityFinder authorityFinder, @Nonnull GDPRDialogFactory gdprDialogFactory, @Nonnull TestbedGdprConsentPreferences testbedGdprConsentPreferences) {
        this.hltf = hltf;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.environment = environment;
        this.config = config;
        this.preferences = preferences;
        this.authorityFinder = authorityFinder;
        this.gdprDialogFactory = gdprDialogFactory;
        this.testbedGdprConsentPreferences = testbedGdprConsentPreferences;
        this.validationSupport = new ValidationSupport();
        this.validationSupport.setValidationDecorator((ValidationDecoration)new GraphicValidationDecoration());
        Server userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        assert (userServer != null);
        this.canRequestProjectMemberSshKeys = userServer != null && userServer.hasFlag(Server.Flag.featureFedMaRequestMemberSshKey);
    }

    @FXML
    public void initialize() {
        if (this.environment.getDefaultSliceDuration() != null) {
            int defaultSliceDuration = this.environment.getDefaultSliceDuration();
            this.userSetMinutes = defaultSliceDuration % 60;
            this.userSetHours = (defaultSliceDuration /= 60) % 24;
            this.userSetDays = Math.min(defaultSliceDuration / 24, 89);
        }
        this.daysComboBox.getItems().addAll((Collection)IntStream.range(0, 89).boxed().collect(Collectors.toList()));
        this.daysComboBox.getSelectionModel().select(this.userSetDays);
        this.hoursComboBox.getItems().addAll((Collection)IntStream.range(0, 24).boxed().collect(Collectors.toList()));
        this.hoursComboBox.getSelectionModel().select(this.userSetHours);
        this.minutesComboBox.getItems().addAll((Collection)IntStream.range(0, 60).boxed().collect(Collectors.toList()));
        this.minutesComboBox.setConverter((StringConverter)new StringConverter<Integer>(){

            public String toString(Integer integer) {
                return String.format("%02d", integer);
            }

            public Integer fromString(String s) {
                return Integer.parseInt(s);
            }
        });
        this.minutesComboBox.getSelectionModel().select(this.userSetMinutes);
        this.sfaModel.getSlices().forEach(slice -> this.slices.put((Object)slice.getName(), slice));
        this.sfaModel.getSlices().addListener((ListChangeListener)new WeakListChangeListener(this.sliceListChangeListener));
        TextFields.bindAutoCompletion((TextField)this.nameTextField, (Collection)this.slices.keySet());
        this.subAuthCheckBox.selectedProperty().addListener(observable -> {
            if (this.subAuthCheckBox.isSelected()) {
                this.enableSubAuthoritiesList();
            } else {
                this.disableSubAuthoritiesList();
            }
        });
        this.subAuthCheckBox.selectedProperty().addListener(observable -> {
            if (!this.subAuthCheckBox.isSelected()) {
                this.prevRequestProjectMemberSshKeysValue = this.autoshareCheckBox.isSelected();
                this.autoshareCheckBox.setSelected(false);
                this.autoshareCheckBox.setDisable(true);
            } else {
                this.autoshareCheckBox.setSelected(this.prevRequestProjectMemberSshKeysValue);
                this.autoshareCheckBox.setDisable(false);
            }
        });
        this.subAuthComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldProjectName, newProjectName) -> {
            if (newProjectName != null && !newProjectName.trim().isEmpty()) {
                if (this.autoSetShareCheckbox) {
                    this.setAutoShareForProject((String)newProjectName);
                }
                final ReadOnlyListProperty userUrns = this.sfaModel.getUsersBySubAuthority(newProjectName);
                StringBinding userCountTextBinding = new StringBinding(){
                    {
                        super.bind(new Observable[]{userUrns.sizeProperty()});
                    }

                    protected String computeValue() {
                        if (userUrns.isEmpty()) {
                            return "Share Experiment with all Project Members";
                        }
                        return "Share Experiment with all " + userUrns.sizeProperty().get() + " Project Members";
                    }
                };
                this.autoshareCheckBox.textProperty().bind((ObservableValue)userCountTextBinding);
            } else {
                this.autoshareCheckBox.setSelected(false);
                this.autoshareCheckBox.textProperty().unbind();
                this.autoshareCheckBox.setText("Share Experiment with all Project Members");
            }
            FXPlatformUtil.runLaterOrNowOnFXThread(this::setProjectExpirationLine);
        });
        this.enableSliceDetailsEditing();
        AwaitingEventStream sliceNameEventStream = EventStreams.invalidationsOf((Observable)this.nameTextField.textProperty()).reduceSuccessions((a, b) -> b, Duration.ofMillis(350L));
        this.sliceNameTextSubsciption = sliceNameEventStream.subscribe(o -> {
            String sliceName = this.nameTextField.getText();
            if (this.slices.containsKey((Object)sliceName)) {
                if (this.durationOfNonExistingSlice == null) {
                    this.durationOfNonExistingSlice = new int[]{this.userSetDays, this.userSetHours, this.userSetMinutes};
                }
                this.showFixedSliceDetails((Slice)this.slices.get((Object)sliceName));
            } else {
                this.enableSliceDetailsEditing();
                if (this.durationOfNonExistingSlice != null) {
                    this.daysComboBox.setValue((Object)this.durationOfNonExistingSlice[0]);
                    this.hoursComboBox.setValue((Object)this.durationOfNonExistingSlice[1]);
                    this.minutesComboBox.setValue((Object)this.durationOfNonExistingSlice[2]);
                    this.durationOfNonExistingSlice = null;
                }
            }
        });
        Platform.runLater(() -> ((TextField)this.nameTextField).requestFocus());
        this.autoshareCheckBox.managedProperty().bind((ObservableValue)this.autoshareCheckBox.visibleProperty());
        this.autoshareSupportWarning.managedProperty().bind((ObservableValue)this.autoshareSupportWarning.visibleProperty());
        this.autoshareCheckBox.setVisible(this.canRequestProjectMemberSshKeys);
        this.autoshareSupportWarning.setVisible(false);
        this.initInvolvedTestbeds();
        this.autoshareCheckBox.setSelected(false);
        this.autoshareCheckBox.setOnAction(e -> {
            this.autoSetShareCheckbox = false;
        });
        this.requestSlaCheckBox.setVisible(this.config.isSlaAvailable());
        this.linkTestRequestedCheckBox.setVisible(this.hasLinks);
        this.validationSupport.registerValidator((Control)this.nameTextField, false, this.sliceNameValidator);
        this.validationSupport.registerValidator(this.subAuthComboBox, false, Validator.createPredicateValidator(s -> !this.subAuthCheckBox.isSelected() || this.getSubAuthName() != null, (String)"Please choose a project in which this experiment should be run!"));
        this.validationSupport.registerValidator(this.subAuthComboBox, false, Validator.createPredicateValidator(s -> {
            if (this.subAuthCheckBox.isSelected() && this.getSubAuthName() != null) {
                String projectName = (String)this.subAuthComboBox.getSelectionModel().getSelectedItem();
                Instant expiration = this.sfaModel.getProjectExpiration(this.getProjectUrn(projectName));
                return expiration == null || expiration.isAfter(Instant.now());
            }
            return true;
        }, (String)"Please choose a project that has not expired yet!"));
        this.addGdprLinesWhenNeeded(this.gdprTestbeds);
        this.setProjectExpirationLine();
    }

    private void initInvolvedTestbeds() {
        if (this.involvedTestbeds == null) {
            return;
        }
        if (this.autoshareCheckBox == null || this.autoshareSupportWarning == null) {
            return;
        }
        this.allServersSupportProvisionSshKeys = this.involvedTestbeds.stream().map(Testbed::getDefaultServer).filter(Objects::nonNull).noneMatch(s -> s.hasFlag(Server.Flag.workaroundProvisionIgnoreSSHKey) || s.hasFlag(Server.Flag.workaroundNoSliceSharingAllowedOnAM) || s.hasFlag(Server.Flag.workaroundProvisionSingleSSHAccount) || s.hasFlag(Server.Flag.workaroundProvisionSingleSSHKey));
        this.someServersSupportProvisionSshKeys = this.involvedTestbeds.stream().map(Testbed::getDefaultServer).filter(Objects::nonNull).anyMatch(s -> !s.hasFlag(Server.Flag.workaroundProvisionIgnoreSSHKey) && !s.hasFlag(Server.Flag.workaroundNoSliceSharingAllowedOnAM) && !s.hasFlag(Server.Flag.workaroundProvisionSingleSSHAccount) && !s.hasFlag(Server.Flag.workaroundProvisionSingleSSHKey));
        FXPlatformUtil.runLaterOrNowOnFXThread(() -> {
            this.autoshareCheckBox.setVisible(this.canRequestProjectMemberSshKeys && this.someServersSupportProvisionSshKeys);
            if (!this.allServersSupportProvisionSshKeys) {
                if (this.someServersSupportProvisionSshKeys) {
                    assert (this.involvedTestbeds.size() > 1);
                    this.autoshareSupportWarning.setText("Not all testbeds support sharing with project members.");
                } else {
                    this.autoshareSupportWarning.setText(this.involvedTestbeds.size() > 1 ? "None of the testbeds support sharing with project members." : "The testbed does not support sharing with project members.");
                }
            }
            this.autoshareSupportWarning.setVisible(!this.allServersSupportProvisionSshKeys);
        });
    }

    @Nonnull
    private GeniUrn getProjectUrn(@Nonnull String projectName) {
        return GeniUrn.createGeniUrnFromEncodedParts((String)this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedTopLevelAuthority_withoutSubAuth(), (String)"project", (String)projectName);
    }

    private void setAutoShareForProject(@Nonnull String projectName) {
        Boolean autoshare = this.preferences.getExperimentAutoshare(this.getProjectUrn(projectName));
        if (autoshare == null) {
            int userCount = this.sfaModel.getUsersBySubAuthority(projectName).size();
            if (userCount > 0 && userCount <= 5) {
                this.autoshareCheckBox.setSelected(true);
            } else {
                this.autoshareCheckBox.setSelected(false);
            }
        } else {
            this.autoshareCheckBox.setSelected(this.canRequestProjectMemberSshKeys && autoshare != false);
        }
    }

    public void saveAutoShare() {
        String projectName = (String)this.subAuthComboBox.getSelectionModel().getSelectedItem();
        if (projectName != null && this.someServersSupportProvisionSshKeys) {
            boolean autoshare = this.autoshareCheckBox.isSelected();
            this.preferences.setExperimentAutoshare(this.getProjectUrn(projectName), Boolean.valueOf(autoshare));
        }
    }

    public void saveLastProject() {
        String projectName = (String)this.subAuthComboBox.getSelectionModel().getSelectedItem();
        this.preferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_EXPERIMENT_LAST_PROJECT, projectName);
    }

    private void enableSliceDetailsEditing() {
        if (this.sliceDetailsEditingEnabled) {
            return;
        }
        this.initializeSubAuthorities();
        this.sliceDetailsEditingEnabled = true;
    }

    private void disableSliceDetailsEditing() {
        if (!this.sliceDetailsEditingEnabled) {
            return;
        }
        this.subAuthCheckBox.setDisable(true);
        this.subAuthComboBox.setDisable(true);
        this.sliceDetailsEditingEnabled = false;
    }

    private void enableSliceExpirationEditing() {
        if (this.sliceExpirationEditingEnabled) {
            return;
        }
        this.daysComboBox.setDisable(false);
        this.hoursComboBox.setDisable(false);
        this.minutesComboBox.setDisable(false);
        this.daysComboBox.setValue((Object)this.userSetDays);
        this.hoursComboBox.setValue((Object)this.userSetHours);
        this.minutesComboBox.setValue((Object)this.userSetMinutes);
        this.daysComboBox.valueProperty().addListener(this.expirationDateTimeInvalidationListener);
        this.hoursComboBox.valueProperty().addListener(this.expirationDateTimeInvalidationListener);
        this.minutesComboBox.valueProperty().addListener(this.expirationDateTimeInvalidationListener);
        this.sliceExpirationEditingEnabled = true;
    }

    private void disableSliceExpirationEditing() {
        if (!this.sliceExpirationEditingEnabled) {
            return;
        }
        this.daysComboBox.valueProperty().removeListener(this.expirationDateTimeInvalidationListener);
        this.hoursComboBox.valueProperty().removeListener(this.expirationDateTimeInvalidationListener);
        this.minutesComboBox.valueProperty().removeListener(this.expirationDateTimeInvalidationListener);
        this.daysComboBox.setDisable(true);
        this.hoursComboBox.setDisable(true);
        this.minutesComboBox.setDisable(true);
        this.sliceExpirationEditingEnabled = false;
    }

    private void showFixedSliceDetails(Slice slice) {
        if (this.sliceDetailsEditingEnabled) {
            this.disableSliceDetailsEditing();
        }
        this.enableSliceExpirationEditing();
        if (slice.getSubAuthorityName() != null) {
            this.subAuthCheckBox.setSelected(true);
            this.subAuthComboBox.setValue((Object)slice.getSubAuthorityName());
        } else {
            this.subAuthCheckBox.setSelected(false);
            this.subAuthComboBox.setValue(null);
        }
        if (slice.getExpirationDate() != null) {
            Duration duration = Duration.between(Instant.now(), slice.getExpirationDate());
            if (Duration.ofHours(2L).compareTo(duration) < 0) {
                long time = duration.toMinutes();
                this.minutesComboBox.setValue((Object)((int)(time % 60L)));
                this.hoursComboBox.setValue((Object)((int)((time /= 60L) % 24L)));
                this.daysComboBox.setValue((Object)((int)(time /= 24L)));
            }
        }
    }

    private void initializeSubAuthorities() {
        if (this.sfaModel.getSubAuthoritySupport() == UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_FORBIDDEN) {
            this.subAuthCheckBox.setSelected(false);
            this.subAuthCheckBox.setDisable(true);
            this.subAuthFetchProgressBar.setVisible(false);
            this.subAuthComboBox.setDisable(true);
            this.subAuthComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"Not supported"}));
            this.refreshSubAuthButton.setDisable(true);
        } else {
            this.subAuthCheckBox.setSelected(true);
            if (this.sfaModel.getSubAuthoritySupport() == UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY) {
                this.subAuthCheckBox.setDisable(true);
            } else {
                this.subAuthCheckBox.setDisable(false);
            }
            this.enableSubAuthoritiesList();
        }
    }

    private void refreshProjectUsers(Collection<String> projectNames) {
        for (String projectName : projectNames) {
            ListSubAuthorityMembersTask listSubAuthorityMembersTask = this.hltf.listSubAuthorityMembers(projectName);
            this.hltf.submitTask((Task)listSubAuthorityMembersTask);
        }
    }

    private void refreshProjectDetails(Collection<String> projectNames) {
        FXPlatformUtil.runLaterOrNowOnFXThread(this::setProjectExpirationLine);
        for (String projectName : projectNames) {
            if (!this.hltf.getUserAndSliceApiWrapper().hasSubAuthDetailsSupport()) continue;
            GetSubAuthorityDetailsTask getSubAuthorityDetailsTask = this.hltf.getSubAuthorityDetails(projectName);
            getSubAuthorityDetailsTask.addCallback((task, taskExecution, state) -> FXPlatformUtil.runLaterOrNowOnFXThread(this::setProjectExpirationLine));
            this.hltf.submitTask((Task)getSubAuthorityDetailsTask);
        }
    }

    private void showSubAuthoritiesList() {
        if (!this.subAuthCheckBox.isSelected()) {
            LOG.warn("unexpected: showSubAuthoritiesList() called while subAuthCheckBox.isSelected()=" + !this.subAuthCheckBox.isSelected());
            return;
        }
        ArrayList subAuthNames = new ArrayList(this.sfaModel.getLoggedInUserSubAuthorityNames());
        Collections.sort(subAuthNames, String.CASE_INSENSITIVE_ORDER);
        this.subAuthComboBox.setItems(FXCollections.observableList(subAuthNames));
        this.subAuthComboBox.setDisable(false);
        if (!this.subAuthComboBox.getItems().isEmpty()) {
            boolean containsSelectedProject;
            String lastProject;
            String selectedProject = null;
            String defaultProject = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_EXPERIMENT_DEFAULT_PROJECT);
            selectedProject = defaultProject != null ? defaultProject : (lastProject = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_EXPERIMENT_LAST_PROJECT));
            if (selectedProject == null) {
                containsSelectedProject = false;
            } else {
                containsSelectedProject = false;
                for (String projectName : this.subAuthComboBox.getItems()) {
                    if (!projectName.trim().equalsIgnoreCase(selectedProject.trim())) continue;
                    containsSelectedProject = true;
                    selectedProject = projectName.trim();
                    break;
                }
            }
            if (!containsSelectedProject) {
                this.subAuthComboBox.getSelectionModel().selectFirst();
            } else {
                this.subAuthComboBox.getSelectionModel().select((Object)selectedProject);
            }
        }
        if (this.subAuthComboBox.getItems().isEmpty() && this.sfaModel.getSubAuthoritySupport() == UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY) {
            JFDialogs.create().owner(this.subAuthComboBox).message("Selecting a project is mandatory for your experiment, but jFed did not receive any candidates. Please contact your support team.").masthead("No projects available").showError();
        }
        this.subAuthFetchProgressBar.setVisible(false);
        this.refreshSubAuthButton.setDisable(false);
        this.addGdprLinesWhenNeeded(this.gdprTestbeds);
        this.setProjectExpirationLine();
    }

    private void disableSubAuthoritiesList() {
        this.subAuthLabel.setDisable(true);
        this.subAuthComboBox.getSelectionModel().clearSelection();
        this.subAuthComboBox.getItems().clear();
        this.subAuthComboBox.setDisable(true);
        this.subAuthFetchProgressBar.setVisible(false);
        this.refreshSubAuthButton.setDisable(true);
    }

    private void enableSubAuthoritiesList() {
        this.subAuthLabel.setDisable(false);
        if (this.shouldRefreshSubAuthorities()) {
            this.refreshSubAuthoritiesList();
        } else {
            this.showSubAuthoritiesList();
        }
    }

    private boolean shouldRefreshSubAuthorities() {
        ListSubAuthoritiesTask listSubAuthoritiesTask = this.hltf.listSubAuthorities();
        return listSubAuthoritiesTask.newExecutionNeeded();
    }

    @FXML
    private void refreshSubAuthoritiesList() {
        this.sfaModel.clearUsersBySubAuthority();
        this.subAuthComboBox.setItems(FXCollections.emptyObservableList());
        this.subAuthComboBox.setDisable(true);
        this.subAuthFetchProgressBar.setVisible(true);
        this.refreshSubAuthButton.setDisable(true);
        ListSubAuthoritiesTask listSubAuthoritiesTask = this.hltf.listSubAuthorities();
        listSubAuthoritiesTask.addCallback((task, taskExecution, state) -> {
            Platform.runLater(this::showSubAuthoritiesList);
            this.refreshProjectUsers((Collection<String>)this.sfaModel.getLoggedInUserSubAuthorityNames());
            this.refreshProjectDetails((Collection<String>)this.sfaModel.getLoggedInUserSubAuthorityNames());
        });
        this.hltf.submitTask((Task)listSubAuthoritiesTask);
    }

    @FXML
    private void showExistingSlicesButton() {
        Set activeSliceNames = this.slices.keySet();
        if (!activeSliceNames.isEmpty()) {
            ChoiceDialog existingSlicesDialog = new ChoiceDialog();
            existingSlicesDialog.setTitle("Select an existing slice");
            existingSlicesDialog.setHeaderText("Select an existing slice");
            existingSlicesDialog.getItems().addAll((Collection)activeSliceNames);
            existingSlicesDialog.showAndWait().ifPresent(arg_0 -> ((TextField)this.nameTextField).setText(arg_0));
        } else {
            JFDialogs.create().masthead("No slices found").title("No slices found").message("You currently don't have any active slices to select from. Please create a new slice to continue.").showInformation();
        }
    }

    private void setProjectExpirationLine() {
        String projectName = this.getSubAuthName();
        if (projectName == null) {
            this.projectExpirationLabel.setManaged(false);
            this.projectExpirationLabel.setVisible(false);
            this.projectExpirationRowConstraint.setPrefHeight(0.0);
            return;
        }
        this.projectExpirationLabel.setManaged(true);
        this.projectExpirationLabel.setVisible(true);
        this.projectExpirationRowConstraint.setPrefHeight(20.0);
        GeniUrn projectUrn = this.getProjectUrn(projectName);
        Instant projectExpiration = this.sfaModel.getProjectExpiration(projectUrn);
        if (projectExpiration != null) {
            if (projectExpiration.isBefore(Instant.now())) {
                this.projectExpirationLabel.setText("\"" + projectName + "\" has expired!");
            } else {
                Duration duration = Duration.between(Instant.now(), projectExpiration);
                String humanExpire = TimeUtils.formatMillis((long)duration.toMillis(), (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MINUTES, (int)2);
                this.projectExpirationLabel.setText("\"" + projectName + "\" expires in " + humanExpire);
                if (duration.toMillis() > Duration.of(90L, ChronoUnit.DAYS).toMillis()) {
                    this.projectExpirationLabel.setManaged(false);
                    this.projectExpirationLabel.setVisible(false);
                    this.projectExpirationRowConstraint.setPrefHeight(0.0);
                }
            }
        } else {
            this.projectExpirationLabel.setText("\"" + projectName + "\" expiration unknown");
            this.projectExpirationLabel.setManaged(false);
            this.projectExpirationLabel.setVisible(false);
            this.projectExpirationRowConstraint.setPrefHeight(0.0);
        }
    }

    private boolean needGdprAction(@Nonnull Testbed testbed) {
        String projectName = (String)this.subAuthComboBox.getSelectionModel().getSelectedItem();
        boolean res = !this.testbedGdprConsentPreferences.isConsentManaged(testbed, projectName, this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
        LOG.debug("needGdprAction(" + testbed.getLongName() + ") = " + res);
        return res;
    }

    private void addGdprLinesWhenNeeded(@Nullable Collection<Testbed> testbeds) {
        if (!JFedBrowser.JFED_BROWSER_WORKS) {
            this.gdprList.visibleProperty().setValue(Boolean.valueOf(false));
            this.gdprList.getChildren().clear();
            this.noterms.setVisible(false);
            this.checkterms.setVisible(false);
            this.gdprList.requestLayout();
            return;
        }
        if (testbeds == null) {
            return;
        }
        if (this.gdprList == null) {
            return;
        }
        if (this.subAuthComboBox.getSelectionModel().getSelectedItem() == null) {
            if (testbeds.isEmpty()) {
                this.noterms.setVisible(true);
                this.checkterms.setVisible(false);
            }
            return;
        }
        this.checkterms.setVisible(false);
        boolean needAction = testbeds.stream().anyMatch(this::needGdprAction);
        if (needAction) {
            this.forceShowGdprTestbeds = true;
        }
        BooleanProperty booleanProperty = this.gdprList.visibleProperty();
        if (needAction || !this.forceShowGdprTestbeds) {
            // empty if block
        }
        booleanProperty.setValue(Boolean.valueOf(true));
        this.gdprList.getChildren().clear();
        if (needAction || !this.forceShowGdprTestbeds) {
            // empty if block
        }
        for (Testbed testbed : testbeds) {
            assert (this.gdprList.isVisible());
            this.addTestbedGdprLine(testbed);
        }
        this.noterms.setVisible(testbeds.isEmpty());
        this.gdprList.requestLayout();
    }

    private void addTestbedGdprLine(final @Nonnull Testbed testbed) {
        boolean gdprActionbRequired = this.needGdprAction(testbed);
        HBox child = new HBox();
        child.setAlignment(Pos.CENTER_LEFT);
        child.setSpacing(10.0);
        this.gdprList.getChildren().add((Object)child);
        if (!gdprActionbRequired) {
            child.getChildren().add((Object)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CHECK_SQUARE, (Color)Color.LAWNGREEN));
        } else {
            child.getChildren().add((Object)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.EXCLAMATION_TRIANGLE, (Color)Color.ORANGERED));
        }
        child.getChildren().add((Object)new Label(testbed.getLongName()));
        child.getChildren().add((Object)new Label("-"));
        Label consentLabel = new Label("Manage");
        consentLabel.getStyleClass().add((Object)"label-link");
        consentLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Pair<Boolean, Instant> approved = StartExperimentController.this.gdprDialogFactory.showDialog(testbed);
                String projectName = (String)StartExperimentController.this.subAuthComboBox.getSelectionModel().getSelectedItem();
                if (Objects.equals(approved.getKey(), Boolean.TRUE) || approved.getKey() == null) {
                    StartExperimentController.this.testbedGdprConsentPreferences.markConsentManaged(testbed, projectName, StartExperimentController.this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), (Instant)approved.getValue());
                } else {
                    StartExperimentController.this.testbedGdprConsentPreferences.markConsentNotManaged(testbed, projectName, StartExperimentController.this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
                }
                StartExperimentController.this.addGdprLinesWhenNeeded(StartExperimentController.this.gdprTestbeds);
            }
        });
        child.getChildren().add((Object)consentLabel);
        if (gdprActionbRequired) {
            child.getChildren().add((Object)new Label("-"));
            Label actionLabel = new Label("Action Required");
            actionLabel.getStyleClass().add((Object)"action-required");
            child.getChildren().add((Object)actionLabel);
        }
    }

    public ValidationSupport getValidationSupport() {
        return this.validationSupport;
    }

    public void setMaximumSliceNameLength(int maximumSliceNameLength) {
        this.maximumSliceNameLength = maximumSliceNameLength;
    }

    public void setGdprTestbeds(@Nonnull Collection<Testbed> gdprTestbeds) {
        this.gdprTestbeds = gdprTestbeds;
        this.addGdprLinesWhenNeeded(gdprTestbeds);
    }

    public void setInvolvedTestbeds(@Nonnull Collection<Testbed> involvedTestbeds) {
        this.involvedTestbeds = involvedTestbeds;
        this.initInvolvedTestbeds();
    }

    public void setHasLinks(boolean hasLinks) {
        this.hasLinks = hasLinks;
        this.linkTestRequestedCheckBox.setVisible(hasLinks);
    }

    public String getSliceName() {
        return this.nameTextField.getText();
    }

    public boolean isExistingSlice() {
        return this.slices.keySet().stream().map(String::toLowerCase).anyMatch(this.getSliceName().toLowerCase()::equals);
    }

    public String getSubAuthName() {
        return this.subAuthCheckBox.isSelected() ? (String)this.subAuthComboBox.getValue() : null;
    }

    public Instant getExpirationTime() {
        if (this.daysComboBox.getSelectionModel().isEmpty() || this.hoursComboBox.getSelectionModel().isEmpty() || this.minutesComboBox.getSelectionModel().isEmpty()) {
            return null;
        }
        return ZonedDateTime.now().plusDays(((Integer)this.daysComboBox.getSelectionModel().getSelectedItem()).intValue()).plusHours(((Integer)this.hoursComboBox.getSelectionModel().getSelectedItem()).intValue()).plusMinutes(((Integer)this.minutesComboBox.getSelectionModel().getSelectedItem()).intValue()).plusSeconds(15L).toInstant();
    }

    public boolean isAutoShareExperiment() {
        return this.someServersSupportProvisionSshKeys && this.autoshareCheckBox.isSelected();
    }

    public boolean isRequestSla() {
        return this.requestSlaCheckBox.isSelected();
    }

    public boolean isLinkTestRequested() {
        return this.linkTestRequestedCheckBox.isSelected();
    }

    public TextField getNameTextField() {
        return this.nameTextField;
    }
}

