/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.StartExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.events.StartExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.UIUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartExperimentDialog
extends Dialog<ButtonType> {
    private static final Logger LOG = LoggerFactory.getLogger(StartExperimentDialog.class);
    @Nonnull
    private final RequestRspecSource requestRspecSource;
    @Nullable
    private final ESpecBundle eSpecBundle;
    @Nonnull
    private final StartExperimentController controller;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final EventBus eventBus;

    public StartExperimentDialog(@Nonnull GuiceFXMLUtil guiceFXMLUtil, @Nullable Window parentWindow, @Nonnull RequestRspecSource requestRspecSource, @Nullable ESpecBundle eSpecBundle, @Nonnull AuthorityFinder authorityFinder, @Nonnull GeniUserProvider geniUserProvider, @Nonnull EventBus eventBus) {
        this.authorityFinder = authorityFinder;
        this.geniUserProvider = geniUserProvider;
        this.requestRspecSource = requestRspecSource;
        this.eSpecBundle = eSpecBundle;
        this.eventBus = eventBus;
        GuiceFXMLUtil.Result result = guiceFXMLUtil.createFromFXML(StartExperimentController.class);
        this.controller = (StartExperimentController)((Object)result.getController());
        this.controller.setMaximumSliceNameLength(this.getMaximumSliceNameLength());
        this.controller.setGdprTestbeds(this.getGdprTestbeds());
        this.controller.setInvolvedTestbeds(this.getInvolvedTestbeds());
        this.controller.setHasLinks(this.hasLinks());
        this.initOwner(parentWindow);
        this.setTitle("Start an experiment run");
        this.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PLAY, (Color)Color.GREEN));
        this.setHeaderText("Enter experiment run details");
        this.getDialogPane().setContent((Node)UIUtils.wrapWithDecorationPane((Node)result.getRoot()));
        this.setResizable(true);
        ButtonType startExperimentAction = new ButtonType("Start Experiment", ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{startExperimentAction, ButtonType.CANCEL});
        Button startExperimentButton = (Button)this.getDialogPane().lookupButton(startExperimentAction);
        startExperimentButton.disableProperty().bind((ObservableValue)this.controller.getValidationSupport().invalidProperty());
        startExperimentButton.addEventFilter(ActionEvent.ACTION, event -> {
            this.checkAndStartExperiment();
            event.consume();
        });
        this.controller.getNameTextField().setOnAction(event -> this.checkAndStartExperiment());
    }

    private int getMaximumSliceNameLength() {
        if (this.requestRspecSource.isXmlBased()) {
            return 8;
        }
        FXModelRspec modelRspec = (FXModelRspec)this.requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        List emulabBasedNodes = modelRspec.getNodes().stream().filter(rspecNode -> {
            GeniUrn compManId = rspecNode.getComponentManagerId();
            if (compManId == null) {
                return false;
            }
            Server nodeAuth = this.authorityFinder.findByUrn(compManId, AuthorityFinder.Purpose.CREATE_SLIVER);
            if (nodeAuth == null) {
                return false;
            }
            return nodeAuth.isServerType("emulab") || nodeAuth.isServerType("instageni");
        }).collect(Collectors.toList());
        LOG.debug("getMaximumSliceNameLength() emulabBasedNodes.size()=" + emulabBasedNodes.size());
        int res = 10;
        if (!emulabBasedNodes.isEmpty()) {
            int nodeNameAndTestBedAuthorityLength = emulabBasedNodes.stream().mapToInt(rspecNode -> {
                int totalLength = 0;
                if (rspecNode.getClientId() != null) {
                    totalLength += rspecNode.getClientId().length();
                }
                if (rspecNode.getComponentManagerId() != null) {
                    totalLength += rspecNode.getComponentManagerId().getEncodedTopLevelAuthority().length();
                }
                return totalLength;
            }).max().orElse(15);
            Server userAuthorityServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
            assert (userAuthorityServer != null);
            String userTld = userAuthorityServer.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority();
            int maxLength = 60;
            maxLength -= nodeNameAndTestBedAuthorityLength;
            if ((maxLength -= userTld.length()) < res) {
                res = maxLength;
            }
        }
        LOG.debug("getMaximumSliceNameLength() res=" + res);
        return res;
    }

    public boolean hasLinks() {
        FXModelRspec modelRspec = (FXModelRspec)this.requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        if (modelRspec == null) {
            return false;
        }
        return !modelRspec.getLinks().isEmpty();
    }

    @Nonnull
    public Collection<Testbed> getGdprTestbeds() {
        FXModelRspec modelRspec = (FXModelRspec)this.requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        if (modelRspec == null) {
            return Collections.emptyList();
        }
        Set<Testbed> testbeds = modelRspec.getNodes().stream().filter(node -> node.getComponentManagerId() != null).map(node -> this.authorityFinder.findByAnyUrn(node.getComponentManagerId(), AuthorityFinder.Purpose.REQUEST_RSPEC)).filter(Objects::nonNull).map(Server::getTestbed).filter(Objects::nonNull).filter(testbed -> testbed.getGdprInfo() != null).collect(Collectors.toSet());
        LOG.debug("getGdprTestbeds() testbeds=" + testbeds.stream().map(PrimaryIdObject::getId).collect(Collectors.joining(", ")));
        return testbeds;
    }

    @Nonnull
    public Collection<Testbed> getInvolvedTestbeds() {
        FXModelRspec modelRspec = (FXModelRspec)this.requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        if (modelRspec == null) {
            return Collections.emptyList();
        }
        Set<Testbed> testbeds = modelRspec.getNodes().stream().filter(node -> node.getComponentManagerId() != null).map(node -> this.authorityFinder.findByAnyUrn(node.getComponentManagerId(), AuthorityFinder.Purpose.REQUEST_RSPEC)).filter(Objects::nonNull).map(Server::getTestbed).filter(Objects::nonNull).collect(Collectors.toSet());
        LOG.debug("getInvolvedTestbeds() testbeds=" + testbeds.stream().map(PrimaryIdObject::getId).collect(Collectors.joining(", ")));
        return testbeds;
    }

    private void startExperiment() {
        this.hide();
        this.controller.saveAutoShare();
        this.controller.saveLastProject();
        StartExperimentEvent startExperimentEvent = new StartExperimentEvent(this.controller.getSliceName(), this.controller.getSubAuthName(), this.controller.getExpirationTime(), this.requestRspecSource, this.eSpecBundle, this.controller.isAutoShareExperiment(), this.controller.isRequestSla(), this.controller.isLinkTestRequested());
        LOG.info("User pressed \"Start Experiment\" button: {}", (Object)startExperimentEvent);
        this.eventBus.post((Object)startExperimentEvent);
    }

    public void checkAndStartExperiment() {
        if (this.controller.getValidationSupport().isInvalid().booleanValue()) {
            LOG.warn("Cannot start because validationSupport is currently invalid");
            return;
        }
        if (this.controller.isExistingSlice()) {
            boolean reuseConfirmed = JFDialogs.create().masthead("Re-use existing slice?").title("Re-use existing slice?").message("The name you have chosen already exists.\n\nIf the experiment was cleanly deleted, you should be able to re-use it. If not, you can run into trouble!\n\nIf you experience any issues when creating a new experiment with an existing name, it is STRONGLY advised to try again with a new name.\n\nContinue creating experiment with this name?").showConfirm().filter(r -> r == ButtonType.OK).isPresent();
            LOG.info("When asked to re-use an existing slice, the user chose: {}", (Object)reuseConfirmed);
            if (!reuseConfirmed) {
                return;
            }
        }
        String sliceName = this.controller.getSliceName();
        LOG.info("Trying to make a slice with sliceName '{}'", (Object)sliceName);
        this.startExperiment();
    }
}

