/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.SliceRunDuration;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.util.InformationLabel;
import be.iminds.ilabt.jfed.util.common.TimeUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.jetbrains.annotations.Contract;

public class TerminateSliceDialog
extends VBox {
    private final Window parentWindow;
    private final Dialog<Collection<ExperimentPart>> dialog;
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final ExperimentController experimentController;
    private final IntegerProperty selectedAuthoritesCount = new SimpleIntegerProperty();
    @FXML
    private TableView<TerminableExperimentPart> authoritiesTableView;
    @FXML
    private TableColumn<TerminableExperimentPart, Boolean> selectionTableColumn;
    @FXML
    private TableColumn<TerminableExperimentPart, String> nameTableColumn;
    @FXML
    private TableColumn<TerminableExperimentPart, Instant> expirationTableColumn;
    @FXML
    private InformationLabel sliceTerminationLabel;
    @FXML
    private Pane longRunningBox;
    @FXML
    private Label longRunningExperimentDurationLabel;
    @FXML
    private Label longRunningExperimentNameLabel;
    @FXML
    private TextField confirmTerminateField;
    private final BooleanProperty confirmedSliceName = new SimpleBooleanProperty(false);
    private final ObservableList<TerminableExperimentPart> terminateableResources;

    TerminateSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController) {
        this.parentWindow = parentWindow;
        this.experimentController = experimentController;
        this.experiment = experimentController.getExperiment();
        if (this.experiment.getSliceOrNull() == null) {
            throw new IllegalArgumentException("Can't create RenewSliceDialog if there experiment has slice == null");
        }
        this.slice = this.experiment.getSliceOrNull();
        this.terminateableResources = FXCollections.observableArrayList();
        experimentController.getExperiment().getPartsStream().filter(part -> part.getState() != InternalState.UNALLOCATED && part.getState() != InternalState.DELETED && part.getState() != InternalState.DELETING).map(x$0 -> new TerminableExperimentPart((ExperimentPart)x$0)).forEach(arg_0 -> this.terminateableResources.add(arg_0));
        this.terminateableResources.sort(Comparator.comparing(terminableExperimentPart -> terminableExperimentPart.getExperimentPart().getName()));
        FXMLUtil.injectFXML((Object)((Object)this));
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText("Terminate Experiment");
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.STOP, (Color)Color.RED));
        dialogPane.setContent((Node)this);
        ButtonType releaseResourcesButtonType = new ButtonType("Release resources", ButtonBar.ButtonData.OK_DONE);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{releaseResourcesButtonType, ButtonType.CANCEL});
        this.dialog = new Dialog();
        this.dialog.initOwner(parentWindow);
        this.dialog.setDialogPane(dialogPane);
        this.dialog.setTitle("Terminate Experiment");
        this.dialog.setResultConverter(buttonType -> {
            if (buttonType == ButtonType.CANCEL) {
                return null;
            }
            return this.terminateableResources.stream().filter(TerminableExperimentPart::getTerminateRequested).map(TerminableExperimentPart::getExperimentPart).collect(Collectors.toSet());
        });
        Node terminateButton = this.dialog.getDialogPane().lookupButton(releaseResourcesButtonType);
        terminateButton.disableProperty().bind((ObservableValue)this.selectedAuthoritesCount.isEqualTo(0).or((ObservableBooleanValue)this.confirmedSliceName.not()));
    }

    @FXML
    private void initialize() {
        DoubleBinding dividableWidth = this.authoritiesTableView.widthProperty().subtract((ObservableNumberValue)this.selectionTableColumn.widthProperty()).subtract(2);
        this.nameTableColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.6));
        this.expirationTableColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.4));
        this.authoritiesTableView.setItems(this.terminateableResources);
        this.authoritiesTableView.setPrefHeight((double)(26 + this.terminateableResources.size() * 25));
        this.selectionTableColumn.setCellValueFactory(t -> ((TerminableExperimentPart)t.getValue()).terminateRequestedProperty());
        this.selectionTableColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.selectionTableColumn));
        this.nameTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((TerminableExperimentPart)t.getValue()).getExperimentPart().getName()));
        this.expirationTableColumn.setCellValueFactory(t -> ((TerminableExperimentPart)t.getValue()).getExperimentPart().expirationTimeProperty());
        this.expirationTableColumn.setCellFactory(t -> new TableCell<TerminableExperimentPart, Instant>(){

            protected void updateItem(Instant date, boolean empty) {
                if (date == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(DateTimeUtils.DATE_HOUR_MINUTES_SECONDS_FORMATTER.format(LocalDateTime.ofInstant(date, ZoneId.systemDefault())));
                }
            }
        });
        assert (this.slice.getExpirationDate() != null);
        this.sliceTerminationLabel.setText(String.format("While all resources can be released from your experiment '%s', the experiment container itself (slice) must expire to be invalidated. This will happen at %s.", this.slice.getName(), DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(LocalDateTime.ofInstant(this.slice.getExpirationDate(), ZoneId.systemDefault()))));
        SliceRunDuration sliceRunDuration = new SliceRunDuration(this.slice);
        if (sliceRunDuration.isLongRunning(false)) {
            this.showLongRunning(true, sliceRunDuration.getDuration(null), this.slice.getName());
        } else {
            this.showLongRunning(false, null, null);
        }
    }

    @Contract(value="true, null, _ -> fail; true, _, null -> fail")
    private void showLongRunning(boolean show, @Nullable Duration runDuration, @Nullable String sliceName) {
        if (show && (runDuration == null || sliceName == null)) {
            throw new IllegalArgumentException("showLongRunning with show=true requires runDuration and sliceName");
        }
        this.longRunningBox.setVisible(show);
        if (!show) {
            this.confirmedSliceName.unbind();
            this.confirmedSliceName.set(true);
            return;
        }
        this.longRunningExperimentNameLabel.setText(sliceName);
        this.longRunningExperimentDurationLabel.setText(TimeUtil.durationToDoubleHumanString((Duration)runDuration));
        this.confirmTerminateField.setText("");
        this.confirmedSliceName.bind((ObservableValue)this.confirmTerminateField.textProperty().isEqualTo(sliceName));
    }

    public void showDialog() {
        Collection partsToTerminate = this.dialog.showAndWait().orElse(Collections.emptyList());
        if (!partsToTerminate.isEmpty()) {
            this.experimentController.stop(partsToTerminate);
        }
    }

    private class TerminableExperimentPart {
        private final ExperimentPart experimentPart;
        private final BooleanProperty terminateRequested = new SimpleBooleanProperty(true);

        private TerminableExperimentPart(ExperimentPart experimentPart) {
            TerminateSliceDialog.this.selectedAuthoritesCount.setValue((Number)(TerminateSliceDialog.this.selectedAuthoritesCount.getValue() + 1));
            this.terminateRequested.addListener(observable -> {
                if (this.terminateRequested.get()) {
                    TerminateSliceDialog.this.selectedAuthoritesCount.setValue((Number)(TerminateSliceDialog.this.selectedAuthoritesCount.getValue() + 1));
                } else {
                    TerminateSliceDialog.this.selectedAuthoritesCount.setValue((Number)(TerminateSliceDialog.this.selectedAuthoritesCount.getValue() - 1));
                }
            });
            this.experimentPart = experimentPart;
        }

        public boolean getTerminateRequested() {
            return this.terminateRequested.get();
        }

        public BooleanProperty terminateRequestedProperty() {
            return this.terminateRequested;
        }

        public void setTerminateRequested(boolean terminateRequested) {
            this.terminateRequested.set(terminateRequested);
        }

        public ExperimentPart getExperimentPart() {
            return this.experimentPart;
        }
    }
}

