/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.JFedBrowser;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.URLStreamFactoryCustomizer;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecStringEvent;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecParser;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import com.google.common.eventbus.EventBus;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedSiteDialog
extends JFedBrowser {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedSiteDialog.class);
    private Testbed testbed;
    private String url;
    private String title;
    @Nonnull
    private final EventBus eventBus;

    @Inject
    public TestbedSiteDialog(@Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaConnectionPool connectionPool, @Nonnull JFedTrustStore trustStore, @Nonnull JFedPreferences preferences, @Nonnull ProxyPreferencesManager proxyPreferencesManager, @Nonnull EventBus eventBus) {
        super(geniUserProvider, connectionPool, trustStore, preferences, proxyPreferencesManager);
        this.eventBus = eventBus;
    }

    public void setUrlAndTestbed(@Nonnull URL url, @Nonnull Testbed testbed, @Nonnull String title) {
        this.url = url.toExternalForm();
        this.testbed = testbed;
        this.title = title;
        this.loadPageWhenReady();
    }

    @Override
    @FXML
    protected void initialize() {
        this.webEngine = this.webView.getEngine();
        URLStreamFactoryCustomizer.useDedicatedProxyForWebkit(new JFedBrowser.MyHttpUrlStreamHandler(this), "https");
        this.initialized = true;
        this.webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                this.jsBridgeBackoff = 1;
                this.registerJsBridge();
            }
        });
        this.loadPageWhenReady();
    }

    @Override
    protected void loadPageWhenReady() {
        if (!this.initialized) {
            return;
        }
        if (this.testbed == null) {
            return;
        }
        Platform.runLater(this::registerJsBridge);
        this.loadPage();
    }

    @Override
    protected Object makeJavascriptBridge() {
        return new TestbedSiteDialogJavaScriptBridge(this);
    }

    protected void loadPage() {
        this.headerLabel.setText(this.title);
        this.webEngine.load(this.url);
    }

    public static class TestbedSiteDialogJavaScriptBridge
    extends JFedBrowser.JavaScriptBridge {
        @Nonnull
        private final TestbedSiteDialog testbedSiteDialog;
        final List<String> nodeUrns = new ArrayList<String>();
        final List<String> requestRspecs = new ArrayList<String>();
        String requestRspec = null;

        public TestbedSiteDialogJavaScriptBridge(@Nonnull TestbedSiteDialog testbedSiteDialog) {
            super(testbedSiteDialog);
            this.testbedSiteDialog = testbedSiteDialog;
        }

        public void addRequestRspec(String requestRSpec) {
            LOG.debug("TestbedSiteDialogJavaScriptBridge.addRequestRspec");
            this.requestRspecs.add(requestRSpec);
        }

        public void setRequestRspec(String requestRSpec) {
            LOG.debug("TestbedSiteDialogJavaScriptBridge.setRequestRspec(requestRSpec) with requestRSpec=" + requestRSpec);
            this.requestRspecs.clear();
            this.nodeUrns.clear();
            this.requestRspec = requestRSpec;
        }

        public void addNode(String urn) {
            LOG.debug("TestbedSiteDialogJavaScriptBridge.addNode");
            this.nodeUrns.add(urn);
        }

        @Override
        public void close() {
            LOG.debug("TestbedSiteDialogJavaScriptBridge.close");
            RspecFactory factory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.FX);
            FXModelRspec generatedModelRspec = null;
            try {
                if (this.requestRspec != null) {
                    generatedModelRspec = (FXModelRspec)new StaxRspecParser(this.requestRspec, factory).call();
                }
            }
            catch (RspecParseException e) {
                LOG.warn("Failed to process requestRspec=" + this.requestRspec, (Throwable)e);
                generatedModelRspec = null;
            }
            if (generatedModelRspec == null) {
                generatedModelRspec = (FXModelRspec)factory.createModelRspec("request");
            }
            for (String req : this.requestRspecs) {
                try {
                    FXModelRspec addedMR = (FXModelRspec)new StaxRspecParser(req, factory).call();
                    if (addedMR == null) continue;
                    addedMR.getNodes().forEach(arg_0 -> ((FXModelRspec)generatedModelRspec).addNode(arg_0));
                }
                catch (RspecParseException e) {
                    LOG.warn("Failed to process req=" + req, (Throwable)e);
                }
            }
            for (String nodeUrn : this.nodeUrns) {
                RspecNode node = factory.createNode((ModelRspec)generatedModelRspec);
                node.setComponentManagerId(this.testbedSiteDialog.testbed.getDefaultComponentManagerUrn());
                node.setComponentId(nodeUrn);
                node.setExclusive(Boolean.valueOf(true));
                node.setSliverTypeName("raw-pc");
                generatedModelRspec.addNode(node);
            }
            this.testbedSiteDialog.eventBus.post((Object)new OpenRequestRspecStringEvent(generatedModelRspec.toGeni3Rspec()));
            Window stage = this.testbedSiteDialog.scene.getWindow();
            stage.hide();
        }
    }
}

