/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLStreamFactoryCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(URLStreamFactoryCustomizer.class);

    public static void useDedicatedProxyForWebkit(URLStreamHandler httpsURLStreamHandler, String protocols) {
        URLStreamFactoryCustomizer.forceInitializationOfOriginalUrlStreamHandlers();
        URLStreamFactoryCustomizer.tryReplaceOriginalUrlStreamHandlersWithScopeProxyAwareVariants(httpsURLStreamHandler, protocols);
    }

    private static void tryReplaceOriginalUrlStreamHandlersWithScopeProxyAwareVariants(URLStreamHandler httpsURLStreamHandler, String protocols) {
        try {
            Hashtable handlers = URLStreamFactoryCustomizer.tryExtractInternalHandlerTableFromUrl();
            LOG.debug("tryReplaceOriginalUrlStreamHandlersWithScopeProxyAwareVariants handlers=" + String.valueOf(handlers));
            Consumer<String> wrapStreamHandlerWithScopedProxyHandler = protocol -> {
                URLStreamHandler originalHandler = (URLStreamHandler)handlers.get(protocol);
                handlers.put(protocol, new DelegatingScopedUrlStreamHandler(originalHandler, httpsURLStreamHandler));
            };
            Arrays.asList(protocols.split(",")).stream().map(String::trim).filter(s -> !s.isEmpty()).forEach(wrapStreamHandlerWithScopedProxyHandler);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Hashtable tryExtractInternalHandlerTableFromUrl() {
        try {
            Field handlersField = URL.class.getDeclaredField("handlers");
            handlersField.setAccessible(true);
            return (Hashtable)handlersField.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void forceInitializationOfOriginalUrlStreamHandlers() {
        try {
            new URL("http://example.com");
            new URL("https://example.com");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static class DelegatingScopedUrlStreamHandler
    extends URLStreamHandler {
        private static final Method openConnectionMethod;
        private static final Method openConnectionWithProxyMethod;
        private final URLStreamHandler origStreamHandler;
        private final URLStreamHandler newStreamHandler;

        public DelegatingScopedUrlStreamHandler(URLStreamHandler origStreamHandler, URLStreamHandler newStreamHandler) {
            this.origStreamHandler = origStreamHandler;
            this.newStreamHandler = newStreamHandler;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            try {
                if (this.isWebKitURLLoaderThread(Thread.currentThread())) {
                    return (URLConnection)openConnectionMethod.invoke((Object)this.newStreamHandler, url);
                }
                return (URLConnection)openConnectionMethod.invoke((Object)this.origStreamHandler, url);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isWebKitURLLoaderThread(Thread thread) {
            StackTraceElement[] st = thread.getStackTrace();
            boolean res = st.length > 4 && st[4].getClassName().startsWith("com.sun.webkit.network");
            LOG.debug("isWebKitURLLoaderThread for " + (st.length > 4 ? st[4].getClassName() : "unknown") + "  => " + res);
            return res;
        }

        static {
            try {
                openConnectionMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
                openConnectionWithProxyMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class, Proxy.class);
                openConnectionMethod.setAccessible(true);
                openConnectionWithProxyMethod.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

