/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.util.WaitForTaskExecutionsTask;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSliceMembersTask;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnshareSliceDialog
extends VBox {
    private static final Logger LOG = LoggerFactory.getLogger(UnshareSliceDialog.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final ExperimentController experimentController;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final HighLevelTaskFactory hltf;
    @FXML
    private ListView<SelectableUser> usersList;
    @FXML
    private HBox initializingBox;
    @FXML
    private CheckBox removeSshKeysCheckBox;
    private final Dialog<ButtonType> dialog;
    private final ButtonType unshareType = new ButtonType("Unshare", ButtonBar.ButtonData.OK_DONE);
    private final IntegerProperty selectedNewUsersCount = new SimpleIntegerProperty(0);

    UnshareSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController, @Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaModel sfaModel, @Nonnull HighLevelTaskFactory hltf) {
        if (experimentController.getExperiment().getSliceOrNull() == null) {
            throw new IllegalArgumentException("Can't create RenewSliceDialog if there experiment has slice == null");
        }
        this.experimentController = experimentController;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.slice = experimentController.getExperiment().getSliceOrNull();
        FXMLUtil.injectFXML((Object)((Object)this));
        this.usersList.setCellFactory((Callback)new Callback<ListView<SelectableUser>, ListCell<SelectableUser>>(){

            public ListCell<SelectableUser> call(ListView<SelectableUser> param) {
                return new CheckBoxListCell<SelectableUser>(SelectableUser::selectedProperty){

                    public void updateItem(SelectableUser item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setDisable(item.isFixed());
                        }
                    }
                };
            }
        });
        WaitForTaskExecutionsTask waitTask = new WaitForTaskExecutionsTask(){

            @Override
            public void onTaskExecutionsFinished() {
                Platform.runLater(() -> {
                    UnshareSliceDialog.this.updateUsersList();
                    UnshareSliceDialog.this.initializingBox.setVisible(false);
                });
            }
        };
        this.initializingBox.setVisible(true);
        ListSliceMembersTask listSliceMembersTask = this.hltf.listSliceMembers(experimentController.getExperiment().getSliceOrNull());
        waitTask.addTaskExecution(this.hltf.submitTask((Task)listSliceMembersTask));
        new Thread(null, (Runnable)((Object)waitTask), "UnshareSlice-WaitForBTaskExecutionsTasks").start();
        String sliceProject = this.slice.getSubAuthorityName();
        Server userAuthServer = geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        String authName = userAuthServer == null ? null : userAuthServer.getName();
        this.dialog = new Dialog();
        this.dialog.initOwner(parentWindow);
        this.dialog.setTitle("Unshare Experiment");
        this.dialog.setHeaderText("Unshare your experiment");
        this.dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.AMBULANCE, (Color)Color.GREEN));
        this.dialog.getDialogPane().setContent((Node)this);
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{this.unshareType, ButtonType.CANCEL});
        Node unshareButton = this.dialog.getDialogPane().lookupButton(this.unshareType);
        unshareButton.disableProperty().bind((ObservableValue)this.selectedNewUsersCount.isEqualTo(0));
        this.dialog.resultProperty().addListener(observable -> {
            if (this.dialog.getResult() == this.unshareType) {
                List selectedUsers = this.usersList.getItems().stream().filter(SelectableUser::getSelected).map(SelectableUser::getUrn).collect(Collectors.toList());
                if (!selectedUsers.isEmpty()) {
                    experimentController.unshareWithUsers(selectedUsers, this.removeSshKeysCheckBox.isSelected());
                } else {
                    LOG.warn("Unexpectedly got an empty list of slice members to remove");
                }
            }
        });
    }

    private void updateUsersList() {
        assert (!this.experimentController.getExperiment().getSliceOrNull().getUsers().isEmpty());
        this.usersList.getItems().clear();
        Slice slice = this.experimentController.getExperiment().getSliceOrNull();
        Collection<Object> currentMembers = slice == null ? Collections.emptyList() : slice.getUsers();
        for (GeniUrn geniUrn : currentMembers) {
            boolean owner = slice != null && slice.getCreator_urn() != null && geniUrn.toString().equals(slice.getCreator_urn());
            this.usersList.getItems().addAll((Object[])new SelectableUser[]{new SelectableUser(geniUrn, false, owner)});
        }
        if (slice != null) {
            LOG.debug("Slice owner: " + slice.getCreator_urn());
        }
        this.usersList.getItems().sort(Comparator.comparing(su -> su.getUrn().getResourceName().toLowerCase()));
    }

    public void showDialog() {
        this.dialog.show();
    }

    private final class SelectableUser {
        private final GeniUrn urn;
        private final BooleanProperty selected = new SimpleBooleanProperty(false);
        private final boolean fixed;

        public SelectableUser(GeniUrn urn, boolean selected, boolean fixed) {
            this.fixed = fixed;
            if (!fixed) {
                this.selected.addListener((observable, oldValue, newValue) -> {
                    if (oldValue != newValue) {
                        if (newValue.booleanValue()) {
                            UnshareSliceDialog.this.selectedNewUsersCount.set(UnshareSliceDialog.this.selectedNewUsersCount.get() + 1);
                        } else {
                            UnshareSliceDialog.this.selectedNewUsersCount.set(UnshareSliceDialog.this.selectedNewUsersCount.get() - 1);
                        }
                    }
                });
            }
            this.selected.set(selected);
            this.urn = urn;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public boolean getSelected() {
            return this.selected.get();
        }

        public BooleanProperty selectedProperty() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected.set(selected);
        }

        public GeniUrn getUrn() {
            return this.urn;
        }

        public String toString() {
            return this.urn.getResourceName();
        }
    }
}

