/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.parser.RspecCompare;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.io.File;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableRspec {
    private static final Logger LOG = LoggerFactory.getLogger(EditableRspec.class);
    @Nullable
    private File file = null;
    private final StringProperty name;
    private final ReadOnlyObjectWrapper<RequestRspecSource> requestRspecSource;
    @Nullable
    private String lastSavedRequestRspec = null;

    public EditableRspec(@Nonnull RequestRspecSource requestRspecSource, @Nonnull String name, @Nullable File inputFile) {
        assert (requestRspecSource != null);
        assert (name != null);
        this.requestRspecSource = new ReadOnlyObjectWrapper((Object)requestRspecSource);
        this.name = new SimpleStringProperty(name);
        this.setFile(inputFile);
    }

    public EditableRspec(@Nonnull String name) {
        assert (name != null);
        this.requestRspecSource = new ReadOnlyObjectWrapper((Object)new ImmutableRequestRspecSource((ModelRspec)new FXModelRspec("request")));
        this.name = new SimpleStringProperty(name);
        this.lastSavedRequestRspec = ((RequestRspecSource)this.requestRspecSource.get()).getRspecXmlString();
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    public void setFile(@Nullable File file) {
        this.file = file;
        this.lastSavedRequestRspec = ((RequestRspecSource)this.requestRspecSource.get()).getRspecXmlString();
    }

    @Nonnull
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(@Nonnull String name) {
        this.name.set((Object)name);
    }

    @Nonnull
    public StringProperty nameProperty() {
        return this.name;
    }

    @Nonnull
    public RequestRspecSource getRequestRspecSource() {
        return (RequestRspecSource)this.requestRspecSource.get();
    }

    @Nonnull
    public ReadOnlyObjectProperty<RequestRspecSource> requestRspecSourceProperty() {
        return this.requestRspecSource.getReadOnlyProperty();
    }

    public void setRequestRspecSource(@Nonnull RequestRspecSource requestRspecSource) {
        this.requestRspecSource.set((Object)requestRspecSource);
    }

    public boolean isDirty() {
        if (this.lastSavedRequestRspec == null) {
            return false;
        }
        if (this.requestRspecSource.get() == null) {
            return true;
        }
        String rspecString = ((RequestRspecSource)this.requestRspecSource.get()).getRspecXmlString();
        if (rspecString == null) {
            return true;
        }
        try {
            RspecCompare compare = new RspecCompare(rspecString, this.lastSavedRequestRspec);
            return !compare.isEqual();
        }
        catch (RspecParseException | XMLStreamException e) {
            LOG.warn("Could not properly parse Rspecs to compare for dirty detection", e);
            return true;
        }
    }
}

