/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorActionsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationEngine;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableCanvasEditorView;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableRspecView;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditorViewType;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditorViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ModelSliceView;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentEditor
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentEditor.class);
    private final EditableRspec editableRspec;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedGuiConfig config;
    private final EditorViewsFactory editorViewsFactory;
    private final EditorActionsFactory editorActionsFactory;
    private final StringProperty statusProperty = new SimpleStringProperty();
    private final RspecValidationEngine validationEngine = new RspecValidationEngine();
    private EditableRspecView currentEditableRspecView;
    private boolean switchingView = false;
    @Nullable
    private ModelRspecEditor modelRspecEditor;
    @Nonnull
    private final ObjectProperty<ToolBoxFilter> toolBoxFilterProperty = new SimpleObjectProperty((Object)new ToolBoxFilter());

    public ExperimentEditor(EditableRspec editableRspec, TestbedInfoSource testbedInfoSource, JFedGuiConfig config, EditorViewsFactory editorViewsFactory, EditorActionsFactory editorActionsFactory) {
        this.editableRspec = editableRspec;
        this.testbedInfoSource = testbedInfoSource;
        this.config = config;
        this.editorViewsFactory = editorViewsFactory;
        this.editorActionsFactory = editorActionsFactory;
        this.updateModelRspecEditor();
        editableRspec.requestRspecSourceProperty().addListener(observable -> this.updateModelRspecEditor());
        if (this.modelRspecEditor == null) {
            this.setEditorViewByType(EditorViewType.RAW);
        } else {
            if (!editableRspec.getRequestRspecSource().isXmlBased()) {
                this.setEditorViewByType(EditorViewType.CANVAS);
                EditableCanvasEditorView editableCanvasEditorView = (EditableCanvasEditorView)this.currentEditableRspecView;
                if (!ModelSliceView.areAllNodePositionsDefined((ModelRspec)this.modelRspecEditor.getModelRspec())) {
                    editableCanvasEditorView.autoLayout();
                }
                editableCanvasEditorView.getCanvas().widthProperty().addListener((observable, oldValue, newValue) -> this.checkAutoFit());
                editableCanvasEditorView.getCanvas().heightProperty().addListener((observable, oldValue, newValue) -> this.checkAutoFit());
            } else {
                this.setEditorViewByType(EditorViewType.RAW);
            }
            Platform.runLater(new FutureTask<Boolean>(editorActionsFactory.createProcessUnboundNodesAction(editableRspec, null)));
        }
        editableRspec.requestRspecSourceProperty().addListener(observable -> {
            ExperimentEditor experimentEditor = this;
            synchronized (experimentEditor) {
                if (!this.switchingView) {
                    this.setEditorViewByType(this.currentEditableRspecView.getType());
                }
            }
        });
    }

    public void checkAutoFit() {
        if (this.modelRspecEditor != null && this.editableRspec != null && this.editableRspec.getRequestRspecSource() != null && this.currentEditableRspecView.getType() == EditorViewType.CANVAS && this.currentEditableRspecView != null) {
            EditableCanvasEditorView editableCanvasEditorView = (EditableCanvasEditorView)this.currentEditableRspecView;
            double width = editableCanvasEditorView.getCanvas().getWidth();
            double height = editableCanvasEditorView.getCanvas().getHeight();
            if (width != 0.0 && height != 0.0 && ModelSliceView.areNodePositionsOutsideWindow((ModelRspec)this.modelRspecEditor.getModelRspec(), width, height)) {
                editableCanvasEditorView.autoFit(width, height);
            }
        }
    }

    private void updateModelRspecEditor() {
        FXModelRspec modelRspec = (FXModelRspec)this.editableRspec.getRequestRspecSource().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        this.modelRspecEditor = modelRspec != null ? new ModelRspecEditor(modelRspec, this.testbedInfoSource, this.config, this.toolBoxFilterProperty) : null;
    }

    private void setEditorViewByType(EditorViewType type) {
        if (this.currentEditableRspecView != null) {
            this.currentEditableRspecView.dispose();
        }
        if (this.toolBoxFilterProperty.isBound()) {
            this.toolBoxFilterProperty.unbind();
        }
        if (type == EditorViewType.CANVAS) {
            assert (this.modelRspecEditor != null);
            this.currentEditableRspecView = this.editorViewsFactory.createEditableCanvasEditorView(this.modelRspecEditor);
            EditableCanvasEditorView editableCanvasEditorView = (EditableCanvasEditorView)this.currentEditableRspecView;
            this.toolBoxFilterProperty.bind(editableCanvasEditorView.toolBoxFilterProperty());
            editableCanvasEditorView.getCanvas().widthProperty().addListener((observable, oldValue, newValue) -> this.checkAutoFit());
            editableCanvasEditorView.getCanvas().heightProperty().addListener((observable, oldValue, newValue) -> this.checkAutoFit());
            this.checkAutoFit();
        } else if (type == EditorViewType.RAW) {
            this.currentEditableRspecView = this.editorViewsFactory.createRawRspecEditor(this.editableRspec.getRequestRspecSource().getStringRspec());
            this.toolBoxFilterProperty.set((Object)new ToolBoxFilter());
        }
        assert (this.currentEditableRspecView != null);
        this.setCenter((Node)this.currentEditableRspecView.getView());
        this.statusProperty.unbind();
        this.statusProperty.bind((ObservableValue)this.currentEditableRspecView.statusProperty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToEditorViewByType(EditorViewType type) {
        assert (this.currentEditableRspecView != null);
        ExperimentEditor experimentEditor = this;
        synchronized (experimentEditor) {
            this.switchingView = true;
            if (this.currentEditableRspecView.getType() == type) {
                return;
            }
            this.editableRspec.setRequestRspecSource(this.currentEditableRspecView.getRequestRspecSource());
            this.setEditorViewByType(type);
            this.switchingView = false;
        }
    }

    public boolean trySwitchToEditorViewByType(EditorViewType type) {
        RequestRspecSource currentRequestRspecSource;
        RspecValidationResult validationResult;
        assert (this.currentEditableRspecView != null);
        if (this.currentEditableRspecView.getType() == type) {
            return true;
        }
        if (this.currentEditableRspecView.getType() == EditorViewType.RAW && (validationResult = this.validationEngine.validateRSpec(RspecCheckReason.SWITCH_TO_VISUAL_EDITOR, currentRequestRspecSource = this.getCurrentRequestRspecSource(), this.getScene().getWindow())) != null) {
            if (validationResult.isAbort()) {
                return false;
            }
            this.editableRspec.setRequestRspecSource(validationResult.getReplacementRequestRspecSource());
        }
        this.switchToEditorViewByType(type);
        return true;
    }

    public EditorViewType getCurrentEditorViewType() {
        return this.currentEditableRspecView.getType();
    }

    public void setStatus(String status) {
        this.statusProperty.set((Object)status);
    }

    public RequestRspecSource getCurrentRequestRspecSource() {
        return this.currentEditableRspecView.getRequestRspecSource();
    }

    public StringProperty statusProperty() {
        return this.statusProperty;
    }

    public void save() {
        this.flushCurrentRequestRspecSource();
        this.editorActionsFactory.createSaveRspecAction(this.editableRspec, this.getScene().getWindow()).call();
    }

    public EditableRspec getEditableRspec() {
        return this.editableRspec;
    }

    public EditableRspecView getCurrentEditableRspecView() {
        return this.currentEditableRspecView;
    }

    public void startExperiment() {
        this.flushCurrentRequestRspecSource();
        this.editorActionsFactory.createStartExperimentAction(this.editableRspec, this.getScene().getWindow()).call();
    }

    public void createReservation() {
        this.flushCurrentRequestRspecSource();
        this.editorActionsFactory.createCreateReservationAction(this.editableRspec, this.getScene().getWindow()).call();
    }

    private void flushCurrentRequestRspecSource() {
        this.editableRspec.setRequestRspecSource(this.getCurrentRequestRspecSource());
    }

    public boolean isDirty() {
        this.flushCurrentRequestRspecSource();
        return this.editableRspec.isDirty();
    }
}

