/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.experimenter_gui.editor.channel_properties.ChannelPropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.events.ShowChannelPropertiesEvent;
import be.iminds.ilabt.jfed.experimenter_gui.editor.events.ShowLinkPropertiesEvent;
import be.iminds.ilabt.jfed.experimenter_gui.editor.events.ShowNodePropertiesEvent;
import be.iminds.ilabt.jfed.experimenter_gui.editor.link_properties.LinkPropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.DelayNodePropertiesDialog;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.DelayRspecNode;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExperimentEditorEventHandler {
    private final AdaptivePropertiesDialogFactory adaptivePropertiesDialogFactory;
    private final LinkPropertiesDialogFactory linkPropertiesDialogFactory;
    private final ChannelPropertiesDialogFactory channelPropertiesDialogFactory;

    @Inject
    public ExperimentEditorEventHandler(AdaptivePropertiesDialogFactory adaptivePropertiesDialogFactory, LinkPropertiesDialogFactory linkPropertiesDialogFactory, ChannelPropertiesDialogFactory channelPropertiesDialogFactory) {
        this.adaptivePropertiesDialogFactory = adaptivePropertiesDialogFactory;
        this.linkPropertiesDialogFactory = linkPropertiesDialogFactory;
        this.channelPropertiesDialogFactory = channelPropertiesDialogFactory;
    }

    @Subscribe
    public void handleShowNodePropertiesEvent(ShowNodePropertiesEvent event) {
        if (event.getNode() instanceof DelayRspecNode) {
            DelayNodePropertiesDialog.showNodePropertiesDialog(event.getParentWindow(), event.getModelRspecEditor(), (DelayRspecNode)event.getNode());
        } else {
            this.adaptivePropertiesDialogFactory.showAdaptivePropertiesDialog(event.getParentWindow(), event.getModelRspecEditor(), event.getNode());
        }
    }

    @Subscribe
    public void handleShowLinkPropertiesEvent(ShowLinkPropertiesEvent event) {
        this.linkPropertiesDialogFactory.showLinkPropertiesDialog(event.getParentWindow(), event.getModelRspecEditor(), event.getLink());
    }

    @Subscribe
    public void handleShowChannelPropertiesEvent(ShowChannelPropertiesEvent event) {
        this.channelPropertiesDialogFactory.showChannelPropertiesDialog(event.getParentWindow(), event.getChannel(), event.getModelRspecEditor().getModelRspec());
    }
}

