/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorActionsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.RspecEditorRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.TopologyEditorRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditorViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.AskOnCloseRequest;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.RibbonEnabled;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.StatusEnabled;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonTab;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentEditorTab
extends Tab
implements RibbonEnabled,
StatusEnabled,
AskOnCloseRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentEditorTab.class);
    private static final List<RibbonTab> ribbonTabs = new ArrayList<RibbonTab>();
    private final ExperimentEditor experimentEditor;
    private final JFedHLPreferences jFedPreferences;
    private static final RspecEditorRibbonTab rspecEditorRibbonTab = new RspecEditorRibbonTab();
    private static final TopologyEditorRibbonTab topologyEditorRibbonTab = new TopologyEditorRibbonTab(rspecEditorRibbonTab);
    private final EditableRspec editableRspec;

    ExperimentEditorTab(EditableRspec editableRspec, TestbedInfoSource testbedInfoSource, JFedGuiConfig config, EditorViewsFactory editorViewsFactory, EditorActionsFactory editorActionsFactory, JFedGuiConfig jFedConfiguration, JFedHLPreferences jFedPreferences) {
        this.jFedPreferences = jFedPreferences;
        this.editableRspec = editableRspec;
        rspecEditorRibbonTab.setAuthorityList(testbedInfoSource);
        rspecEditorRibbonTab.setJFedGuiConfig(jFedConfiguration);
        this.textProperty().bind((ObservableValue)editableRspec.nameProperty());
        this.getStyleClass().add((Object)"tab-experiment-design");
        this.setGraphic((Node)new Glyph("FontAwesome", '\uf044'));
        ContextMenu contextMenu = new ContextMenu();
        MenuItem changeNameMenuItem = new MenuItem("Change name", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PENCIL));
        changeNameMenuItem.setOnAction(actionEvent -> this.showEditNameDialog());
        contextMenu.getItems().add((Object)changeNameMenuItem);
        this.setContextMenu(contextMenu);
        this.experimentEditor = new ExperimentEditor(editableRspec, testbedInfoSource, config, editorViewsFactory, editorActionsFactory);
        this.setContent((Node)this.experimentEditor);
    }

    private void showEditNameDialog() {
        JFDialogs.create().owner((Node)this.getExperimentEditor()).message("Enter a new name:").masthead("Change Experiment Definition name").title("Change Experiment Definition name").showTextInput(this.editableRspec.getName()).filter(x -> !x.isEmpty()).ifPresent(this.editableRspec::setName);
    }

    public ExperimentEditor getExperimentEditor() {
        return this.experimentEditor;
    }

    @Override
    public List<? extends RibbonTab> getRibbonTabs() {
        return ribbonTabs;
    }

    @Override
    public RibbonTab getInitialTabToActivate() {
        switch (this.experimentEditor.getCurrentEditorViewType()) {
            case RAW: {
                return rspecEditorRibbonTab;
            }
        }
        return topologyEditorRibbonTab;
    }

    public StringProperty statusProperty() {
        return this.experimentEditor.statusProperty();
    }

    @Override
    public boolean onTabCloseRequest() {
        if (this.experimentEditor.isDirty()) {
            Alert saveAlert = new Alert(Alert.AlertType.CONFIRMATION);
            saveAlert.setTitle("Unsaved changes");
            saveAlert.setHeaderText("Unsaved changes");
            saveAlert.setContentText("Do you want to save changes you made to " + this.experimentEditor.getEditableRspec().getName() + "?");
            saveAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            saveAlert.setResizable(true);
            ButtonType saveButtonType = new ButtonType("Save", ButtonBar.ButtonData.YES);
            ButtonType dontSaveButtonType = new ButtonType("Don't save", ButtonBar.ButtonData.NO);
            saveAlert.getButtonTypes().setAll((Object[])new ButtonType[]{saveButtonType, dontSaveButtonType, ButtonType.CANCEL});
            Optional result = saveAlert.showAndWait();
            if (!result.isPresent() || result.get() == ButtonType.CANCEL) {
                return false;
            }
            if (result.get() == saveButtonType) {
                this.experimentEditor.save();
                return true;
            }
            return true;
        }
        return true;
    }

    static {
        ribbonTabs.add(topologyEditorRibbonTab);
        ribbonTabs.add(rspecEditorRibbonTab);
    }
}

