/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorActionsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditorViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ExperimentEditorTabHost;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExperimentEditorTabFactory {
    private final ExperimentEditorTabHost experimentEditorTabHost;
    private final JFedGuiConfig config;
    private final JFedHLPreferences jFedPreferences;
    private final TestbedInfoSource testbedInfoSource;
    private final EditorViewsFactory editorViewsFactory;
    private final EditorActionsFactory editorActionsFactory;

    @Inject
    public ExperimentEditorTabFactory(ExperimentEditorTabHost experimentEditorTabHost, TestbedInfoSource testbedInfoSource, EditorViewsFactory editorViewsFactory, EditorActionsFactory editorActionsFactory, JFedGuiConfig config, JFedHLPreferences jFedPreferences) {
        this.testbedInfoSource = testbedInfoSource;
        this.editorViewsFactory = editorViewsFactory;
        this.editorActionsFactory = editorActionsFactory;
        this.experimentEditorTabHost = experimentEditorTabHost;
        this.config = config;
        this.jFedPreferences = jFedPreferences;
    }

    public ExperimentEditorTab createExperimentEditorTab() {
        EditableRspec editableRspec = new EditableRspec(this.getNextNewExperimentDefinitionName());
        return new ExperimentEditorTab(editableRspec, this.testbedInfoSource, this.config, this.editorViewsFactory, this.editorActionsFactory, this.config, this.jFedPreferences);
    }

    public ExperimentEditorTab createExperimentEditorTab(EditableRspec editableRspec) {
        return new ExperimentEditorTab(editableRspec, this.testbedInfoSource, this.config, this.editorViewsFactory, this.editorActionsFactory, this.config, this.jFedPreferences);
    }

    @Nonnull
    private String getNextNewExperimentDefinitionName() {
        String baseName = "Untitled";
        if (!this.experimentDefinitionNameExists(baseName)) {
            return baseName;
        }
        int counter = 1;
        String name = baseName + counter;
        while (this.experimentDefinitionNameExists(name)) {
            name = baseName + ++counter;
        }
        return name;
    }

    private boolean experimentDefinitionNameExists(String name) {
        return this.experimentEditorTabHost.getExperimentEditorTabs().stream().map(ExperimentEditorTab::getExperimentEditor).map(ExperimentEditor::getEditableRspec).map(EditableRspec::getName).anyMatch(name::equals);
    }
}

