/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.util.InetAddressUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.DelayRspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecFactory;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Point2D;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRspecEditor {
    public static final String DEFAULT_IPV4_NETMASK = "255.255.255.0";
    public static final String DEFAULT_IPV6_NETMASK = "64";
    private static final Logger LOG = LoggerFactory.getLogger(ModelRspecEditor.class);
    private static final long DEFAULT_LINK_CAPACITY = 10000L;
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})\\.(\\d{1,3})");
    private static final FXRspecFactory rspecFactory = FXRspecFactory.getInstance();
    public static final int MAX_NODE_NAME_LENGTH = 10;
    public static final int MAX_IFACE_NAME_LENGTH = 14;
    private final Map<FXRspecNode, Resource> nodeDescriptionMap = new HashMap<FXRspecNode, Resource>();
    private final Map<FXRspecLink, String> linkSubnetworks = new HashMap<FXRspecLink, String>();
    @Nonnull
    private final FXModelRspec modelRspec;
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final ObjectProperty<ToolBoxFilter> toolBoxFilterProperty;
    @Nullable
    private EditableExperimentCanvas editableExperimentCanvas = null;

    public ModelRspecEditor(@Nonnull FXModelRspec modelRspec, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedGuiConfig config, @Nonnull ObjectProperty<ToolBoxFilter> toolBoxFilterProperty) {
        this.modelRspec = modelRspec;
        this.testbedInfoSource = testbedInfoSource;
        this.config = config;
        this.toolBoxFilterProperty = toolBoxFilterProperty;
        for (FXRspecLink link : modelRspec.getLinks()) {
            String subnetwork = ModelRspecEditor.getInet4SubnetworkFromLink(link);
            if (subnetwork == null) continue;
            this.linkSubnetworks.put(link, subnetwork);
        }
    }

    @Nullable
    public static String getInet4SubnetworkFromLink(@Nonnull FXRspecLink link) {
        FXRspecInterface iface2;
        for (FXRspecInterface iface2 : link.getInterfaces()) {
            for (RspecInterface.IpAddress addr : iface2.getIpAddresses()) {
                if (!Objects.equals("ipv4", addr.getType())) {
                    return null;
                }
                if (Objects.equals(DEFAULT_IPV4_NETMASK, addr.getNetmask())) continue;
                return null;
            }
        }
        Iterator it = link.getInterfaces().iterator();
        if (!it.hasNext()) {
            return null;
        }
        iface2 = (FXRspecInterface)it.next();
        if (iface2.getIpAddresses().size() != 1) {
            return null;
        }
        if (!InetAddressUtil.isValidInet4Address(((RspecInterface.IpAddress)iface2.getIpAddresses().get(0)).getAddress())) {
            return null;
        }
        String subnetwork = InetAddressUtil.getInet4Subnetwork(InetAddressUtil.simplifyInet4Address(((RspecInterface.IpAddress)iface2.getIpAddresses().get(0)).getAddress()));
        while (it.hasNext()) {
            iface2 = (FXRspecInterface)it.next();
            if (iface2.getIpAddresses().size() != 1) {
                return null;
            }
            if (InetAddressUtil.isValidInet4Address(((RspecInterface.IpAddress)iface2.getIpAddresses().get(0)).getAddress()) && InetAddressUtil.simplifyInet4Address(((RspecInterface.IpAddress)iface2.getIpAddresses().get(0)).getAddress()).startsWith(subnetwork)) continue;
            return null;
        }
        return subnetwork;
    }

    @Nullable
    public static String getInet6SubnetworkFromLink(@Nonnull FXRspecLink link) {
        FXRspecInterface iface2;
        for (FXRspecInterface iface2 : link.getInterfaces()) {
            for (RspecInterface.IpAddress addr : iface2.getIpAddresses()) {
                if (!Objects.equals("ipv6", addr.getType())) {
                    return null;
                }
                if (Objects.equals(DEFAULT_IPV6_NETMASK, addr.getNetmask())) continue;
                return null;
            }
        }
        Iterator it = link.getInterfaces().iterator();
        if (!it.hasNext()) {
            return null;
        }
        iface2 = (FXRspecInterface)it.next();
        if (iface2.getIpAddresses().size() != 1) {
            return null;
        }
        if (!InetAddressUtil.isValidInet6Address(((RspecInterface.IpAddress)iface2.getIpAddresses().get(0)).getAddress())) {
            return null;
        }
        String subnetwork = InetAddressUtil.getInet6Subnetwork(((RspecInterface.IpAddress)iface2.getIpAddresses().get(0)).getAddress());
        while (it.hasNext()) {
            iface2 = (FXRspecInterface)it.next();
            if (iface2.getIpAddresses().size() != 1) {
                return null;
            }
            if (((RspecInterface.IpAddress)iface2.getIpAddresses().get(0)).getAddress().startsWith(subnetwork)) continue;
            return null;
        }
        return subnetwork;
    }

    private static void clearInterface(@Nonnull FXRspecInterface iface) {
        iface.getIpAddresses().clear();
    }

    public void setEditableExperimentCanvas(@Nullable EditableExperimentCanvas editableExperimentCanvas) {
        this.editableExperimentCanvas = editableExperimentCanvas;
    }

    @Nonnull
    public FXModelRspec getModelRspec() {
        return this.modelRspec;
    }

    @Nonnull
    public ObjectProperty<ToolBoxFilter> toolBoxFilterProperty() {
        return this.toolBoxFilterProperty;
    }

    public void convertLinkToStitchedLink(@Nonnull FXRspecLink rspecLink) {
        rspecLink.getLinkTypes().remove((Object)"lan");
        for (FXRspecInterface iface1 : rspecLink.getInterfaces()) {
            for (FXRspecInterface iface2 : rspecLink.getInterfaces()) {
                if (iface1 == iface2 || rspecLink.getLinkSetting((RspecInterface)iface1, (RspecInterface)iface2).isCapacitySet()) continue;
                rspecLink.getLinkSetting((RspecInterface)iface1, (RspecInterface)iface2).setCapacity_Kbps(Long.valueOf(10000L));
            }
        }
    }

    public void convertLinkToNormalLink(@Nonnull FXRspecLink rspecLink) {
        rspecLink.getLinkTypes().setAll((Object[])new String[]{"lan"});
        for (FXRspecInterface iface1 : rspecLink.getInterfaces()) {
            for (FXRspecInterface iface2 : rspecLink.getInterfaces()) {
                if (iface1 == iface2 || rspecLink.getLinkSetting((RspecInterface)iface1, (RspecInterface)iface2).getCapacity_Kbps() != 10000L) continue;
                rspecLink.getLinkSetting((RspecInterface)iface1, (RspecInterface)iface2).setCapacity_Kbps(Long.valueOf(0L));
            }
        }
    }

    @Nullable
    public String getNextAvailableInet4Subnetwork() {
        int subnetwork = -1;
        String subnetworkString = null;
        boolean inUse = true;
        while (inUse && subnetwork < 255) {
            subnetworkString = "192.168." + ++subnetwork % 255;
            inUse = this.linkSubnetworks.containsValue(subnetworkString);
        }
        if (subnetwork < 255) {
            return subnetworkString;
        }
        return null;
    }

    private int getNextLastIpAddressDigits(@Nonnull String subNetwork) {
        int lastDigit;
        boolean[] usedLastDigits = new boolean[254];
        for (Map.Entry<FXRspecLink, String> entry : this.linkSubnetworks.entrySet()) {
            if (!Objects.equals(subNetwork, entry.getValue())) continue;
            for (FXRspecInterface iface : entry.getKey().getInterfaces()) {
                if (iface.getIpAddresses().isEmpty()) continue;
                Matcher matcher = IP_ADDRESS_PATTERN.matcher(((RspecInterface.IpAddress)iface.getIpAddresses().get(0)).getAddress());
                if (matcher.matches()) {
                    if (!Objects.equals(subNetwork, matcher.group(1))) {
                        LOG.debug("Ignoring IP on link with non matching subnet. subnet=" + subNetwork + " ip=" + ((RspecInterface.IpAddress)iface.getIpAddresses().get(0)).getAddress());
                        continue;
                    }
                    int lastDigit2 = Integer.parseInt(matcher.group(2));
                    if (lastDigit2 >= 1 && lastDigit2 <= 254) {
                        usedLastDigits[lastDigit2 - 1] = true;
                        continue;
                    }
                    throw new IllegalArgumentException("RSpec contains an IP with a wrong last number (" + lastDigit2 + ") : " + ((RspecInterface.IpAddress)iface.getIpAddresses().get(0)).getAddress());
                }
                throw new IllegalArgumentException("RSpec contains an invalid IP: " + ((RspecInterface.IpAddress)iface.getIpAddresses().get(0)).getAddress());
            }
        }
        for (lastDigit = 1; lastDigit < 255 && usedLastDigits[lastDigit - 1]; ++lastDigit) {
        }
        if (lastDigit == 255) {
            throw new IllegalStateException("RSpec already contains uses all IPs in the subnet: " + subNetwork);
        }
        return lastDigit;
    }

    private void configureIfaceForSubnetwork(@Nonnull FXRspecInterface iface, @Nonnull String subnetwork) {
        this.configureIfaceForSubnetwork(iface, subnetwork, this.getNextLastIpAddressDigits(subnetwork));
    }

    private void configureIfaceForSubnetwork(@Nonnull FXRspecInterface iface, @Nonnull String subnetwork, int lastDigit) {
        Preconditions.checkNotNull((Object)iface);
        Preconditions.checkNotNull((Object)subnetwork);
        Preconditions.checkArgument((lastDigit > 0 && lastDigit < 255 ? 1 : 0) != 0, (Object)"Got an illegal last digit");
        iface.getIpAddresses().add((Object)new RspecInterface.IpAddress(subnetwork + "." + lastDigit, DEFAULT_IPV4_NETMASK, "ipv4"));
    }

    @Nullable
    public DelayRspecNode convertLinkToImpairmentBridge(@Nonnull FXRspecLink rspecLink) {
        String impairmentBridgeSubnetwork;
        if (rspecLink.getInterfaces().size() > 2) {
            return null;
        }
        String string = impairmentBridgeSubnetwork = this.linkSubnetworks.containsKey(rspecLink) ? this.linkSubnetworks.get(rspecLink) : this.getNextAvailableInet4Subnetwork();
        if (impairmentBridgeSubnetwork == null) {
            return null;
        }
        FXRspecInterface iface1 = (FXRspecInterface)rspecLink.getInterfaces().get(0);
        FXRspecNode node1 = iface1.getNode();
        String ifaceId1 = iface1.getClientId();
        FXRspecInterface iface2 = (FXRspecInterface)rspecLink.getInterfaces().get(1);
        FXRspecNode node2 = iface2.getNode();
        String ifaceId2 = iface2.getClientId();
        this.modelRspec.deleteLink((RspecLink)rspecLink);
        DelayRspecNode impairmentBridgeNode = new DelayRspecNode(this.modelRspec, this.getNextImpairmentBridgeName());
        impairmentBridgeNode.setEditorX((node1.getEditorX() + node2.getEditorX()) / 2.0);
        impairmentBridgeNode.setEditorY((node1.getEditorY() + node2.getEditorY()) / 2.0);
        impairmentBridgeNode.setExclusive(Boolean.valueOf(true));
        impairmentBridgeNode.setComponentManagerId(node1.getComponentManagerId());
        this.modelRspec.getNodes().add((Object)impairmentBridgeNode);
        FXRspecLink newLink1 = rspecFactory.createLinkWithClientId((ModelRspec)this.modelRspec, this.modelRspec.nextLinkName(), "lan");
        FXRspecInterface link1Iface1 = rspecFactory.createInterface((RspecNode)node1, (RspecLink)newLink1, ifaceId1);
        this.configureIfaceForSubnetwork(link1Iface1, impairmentBridgeSubnetwork);
        rspecFactory.createInterface((RspecNode)impairmentBridgeNode, (RspecLink)newLink1, impairmentBridgeNode.getClientId() + ":left");
        this.modelRspec.getLinks().add((Object)newLink1);
        FXRspecLink newLink2 = rspecFactory.createLinkWithClientId((ModelRspec)this.modelRspec, this.modelRspec.nextLinkName(), "lan");
        FXRspecInterface link2Iface1 = rspecFactory.createInterface((RspecNode)node2, (RspecLink)newLink2, ifaceId2);
        this.configureIfaceForSubnetwork(link2Iface1, impairmentBridgeSubnetwork);
        rspecFactory.createInterface((RspecNode)impairmentBridgeNode, (RspecLink)newLink2, impairmentBridgeNode.getClientId() + ":right");
        this.modelRspec.getLinks().add((Object)newLink2);
        return impairmentBridgeNode;
    }

    @Nonnull
    private String getNextImpairmentBridgeName() {
        int nr = 0;
        while (this.modelRspec.getNodeByClientId("bridge" + nr) != null) {
            ++nr;
        }
        return "bridge" + nr;
    }

    private boolean isInterfaceConfigurationAllowed(@Nonnull FXRspecNode node) {
        Resource resource = this.nodeDescriptionMap.get(node);
        return resource == null || resource.getAllowLinksOrDefault() || resource.getAllowStitchedLinksOrDefault();
    }

    @Nonnull
    public FXRspecNode addNode(@Nonnull ResourceClass resourceClass, @Nonnull Point2D location) {
        assert (resourceClass != null);
        assert (resourceClass.getResources() != null);
        Resource defaultResource = this.config.getDefaultResource(resourceClass);
        assert (defaultResource != null) : "There is no default resource for " + (String)resourceClass.getId();
        if (defaultResource == null && !resourceClass.getResources().isEmpty()) {
            defaultResource = (Resource)resourceClass.getResources().get(0);
        }
        Set allowedResources = resourceClass.getResources().stream().filter(((ToolBoxFilter)this.toolBoxFilterProperty.get()).getResourceFilter()).collect(Collectors.toSet());
        if (defaultResource != null && !allowedResources.isEmpty()) {
            if (allowedResources.stream().map(PrimaryIdObject::getId).noneMatch(((Integer)defaultResource.getId())::equals)) {
                defaultResource = (Resource)allowedResources.iterator().next();
            }
        }
        if (defaultResource == null) {
            throw new RuntimeException("There is no resource for " + (String)resourceClass.getId());
        }
        FXRspecNode rspecNode = rspecFactory.createNodeWithClientId((ModelRspec)this.modelRspec, this.modelRspec.nextNodeName());
        rspecNode.setResourceClassId((String)resourceClass.getId());
        rspecNode.setComponentManagerId(defaultResource.getServer().getDefaultComponentManagerAsGeniUrn());
        rspecNode.setExclusive(defaultResource.getDefaultExclusive());
        if (!Objects.equals(defaultResource.getAllowFixedNodeAssignment(), Boolean.FALSE)) {
            rspecNode.setComponentId(defaultResource.getComponentUrn());
        }
        if (defaultResource.getSliverType() != null) {
            SliverTypeBuilder sliverTypeBuilder = new SliverTypeBuilder(defaultResource.getSliverType());
            if (!Objects.equals(defaultResource.getAllowDiskImage(), Boolean.FALSE) && defaultResource.getDiskImage() != null) {
                sliverTypeBuilder.addDiskImage(defaultResource.getDiskImage());
            }
            rspecNode.setSliverType(sliverTypeBuilder.build());
        } else if (!Objects.equals(defaultResource.getRequireDiskImage(), Boolean.FALSE)) {
            LOG.error("Disk image requires a sliver type!");
        }
        if (Objects.equals(defaultResource.getAllowHardwareType(), Boolean.TRUE) && defaultResource.getHardwareType() != null) {
            rspecNode.getHardwareTypes().add((Object)new HardwareType(defaultResource.getHardwareType()));
        }
        rspecNode.setEditorX(location.getX());
        rspecNode.setEditorY(location.getY());
        this.modelRspec.getNodes().add((Object)rspecNode);
        this.nodeDescriptionMap.put(rspecNode, defaultResource);
        return rspecNode;
    }

    @Nonnull
    public FXRspecLink addLink(@Nonnull FXRspecNode node1, @Nonnull FXRspecNode node2) {
        ResourceClass resourceClass;
        Resource nodesResource;
        LOG.trace("Adding link between {} and {}", (Object)node1.getClientId(), (Object)node2.getUniqueId());
        String linkType = "lan";
        if (Objects.equals(node1.getComponentManagerId(), node2.getComponentManagerId()) && (nodesResource = this.config.findBestResource(resourceClass = node1.getResourceClassId() == null ? null : this.config.getResourceClass(node1.getResourceClassId()), (RspecNode)node1, null)) != null) {
            linkType = nodesResource.getDefaultLinkTypeOrDefault();
        }
        FXRspecLink rspecLink = rspecFactory.createLinkWithClientId((ModelRspec)this.modelRspec, this.modelRspec.nextLinkName(), linkType);
        this.linkSubnetworks.put(rspecLink, this.getNextAvailableInet4Subnetwork());
        this.addNodeToLink(node1, rspecLink);
        this.addNodeToLink(node2, rspecLink);
        this.modelRspec.getLinks().add((Object)rspecLink);
        if (this.shouldBeStitchedLink(node1, node2)) {
            this.convertLinkToStitchedLink(rspecLink);
        }
        return rspecLink;
    }

    @Nonnull
    public FXRspecInterface addUnboundInterface(@Nonnull FXRspecNode node) {
        LOG.trace("Adding an unbound link to node {}", (Object)node.getUniqueId());
        return rspecFactory.createInterface((RspecNode)node, this.modelRspec.nextIfaceName((RspecNode)node));
    }

    @Nonnull
    private FXRspecInterface addNodeToLink(@Nonnull FXRspecNode node, @Nonnull FXRspecLink link) {
        FXRspecInterface iface = rspecFactory.createInterface((RspecNode)node, (RspecLink)link, this.modelRspec.nextIfaceName((RspecNode)node));
        LOG.trace("Added node {} to link {} with iface {}", new Object[]{node.getUniqueId(), link.getUniqueId(), iface.getClientId()});
        if (this.isInterfaceConfigurationAllowed(node)) {
            if (this.linkSubnetworks.containsKey(link)) {
                this.configureIfaceForSubnetwork(iface, this.linkSubnetworks.get(link));
            }
        } else {
            Server nodeServer = this.testbedInfoSource.getByUrn(node.getComponentManagerId(), TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
            if (nodeServer == null || !nodeServer.isEdgeVlan()) {
                if (this.linkSubnetworks.containsKey(link)) {
                    this.linkSubnetworks.remove(link);
                }
                link.getInterfaces().forEach(ModelRspecEditor::clearInterface);
            }
        }
        return iface;
    }

    public boolean addLink(@Nonnull FXRspecLink link, @Nonnull FXRspecNode node) {
        return this.addNodeToLink(node, link) != null;
    }

    @Nonnull
    public FXRspecChannel addChannel(@Nonnull Point2D location) {
        FXRspecChannel channel = (FXRspecChannel)rspecFactory.createChannel((ModelRspec)this.modelRspec);
        channel.setEditorX(location.getX());
        channel.setEditorY(location.getY());
        this.modelRspec.addChannel((Channel)channel);
        return channel;
    }

    private boolean shouldBeStitchedLink(@Nonnull FXRspecNode node1, @Nonnull FXRspecNode node2) {
        return node1.getComponentManagerId() != null && !Objects.equals(node1.getComponentManagerId(), node2.getComponentManagerId()) || node2.getComponentManagerId() == null;
    }

    @Nonnull
    public FXAddressPool addAddressPool(@Nonnull Point2D location) {
        FXAddressPool addressPool = (FXAddressPool)rspecFactory.createAddressPool((ModelRspec)this.modelRspec);
        addressPool.setClientId(this.nextAddressPoolName());
        addressPool.setCount(Integer.valueOf(1));
        addressPool.setType("any");
        addressPool.setEditorX(location.getX());
        addressPool.setEditorY(location.getY());
        this.modelRspec.addAddressPool((AddressPool)addressPool);
        return addressPool;
    }

    @Nonnull
    private String nextAddressPoolName() {
        String base = "pool";
        int number = 0;
        String name = "pool" + number;
        while (this.modelRspec.getAddressPools().stream().map(AddressPool::getClientId).anyMatch(name::equals)) {
            name = "pool" + ++number;
        }
        return name;
    }

    public void updateNodeClientId(@Nonnull FXRspecNode node, @Nonnull String newClientId) throws IllegalArgumentException {
        if (this.modelRspec.getNodeByClientId(newClientId) != null) {
            throw new IllegalArgumentException("New clientId already exists in current Rspec");
        }
        String oldClientId = node.getClientId();
        assert (oldClientId != null);
        node.setClientId(newClientId);
        for (FXRspecInterface fxRspecInterface : node.getInterfaces()) {
            fxRspecInterface.setClientId(fxRspecInterface.getClientId().replace(oldClientId, newClientId));
        }
    }

    public static boolean isValidNodeName(@Nonnull String text) {
        if (text.isEmpty()) {
            return false;
        }
        if (text.length() > 10) {
            return false;
        }
        if (text.startsWith("-")) {
            return false;
        }
        for (char c : text.toCharArray()) {
            boolean validChar;
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

