/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ToolBoxFilter {
    @Nonnull
    private final SortedSet<String> testbedIds;
    @Nonnull
    private final SortedSet<String> organisationIds;
    @Nonnull
    private final SortedSet<String> categoryNames;
    @Nonnull
    private final SortedSet<String> federationIds;
    private final boolean orIntra;

    public ToolBoxFilter() {
        this.testbedIds = Collections.emptySortedSet();
        this.organisationIds = Collections.emptySortedSet();
        this.categoryNames = Collections.emptySortedSet();
        this.federationIds = Collections.emptySortedSet();
        this.orIntra = false;
    }

    @JsonCreator
    public ToolBoxFilter(@Nullable @JsonProperty(value="testbedIds") Collection<String> testbedIds, @Nullable @JsonProperty(value="organisationIds") Collection<String> organisationIds, @Nullable @JsonProperty(value="categoryNames") Collection<String> categoryNames, @Nullable @JsonProperty(value="federationIds") Collection<String> federationIds, @Nullable @JsonProperty(value="orIntra") Boolean orIntra) {
        this.testbedIds = testbedIds == null ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet<String>(testbedIds));
        this.organisationIds = organisationIds == null ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet<String>(organisationIds));
        this.categoryNames = categoryNames == null ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet<String>(categoryNames));
        this.federationIds = federationIds == null ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet<String>(federationIds));
        this.orIntra = Objects.equals(orIntra, Boolean.TRUE);
    }

    @Nonnull
    @JsonProperty
    public SortedSet<String> getTestbedIds() {
        return this.testbedIds;
    }

    @Nonnull
    @JsonProperty
    public SortedSet<String> getOrganisationIds() {
        return this.organisationIds;
    }

    @Nonnull
    @JsonProperty
    public SortedSet<String> getFederationIds() {
        return this.federationIds;
    }

    @Nonnull
    @JsonProperty
    public SortedSet<String> getCategoryNames() {
        return this.categoryNames;
    }

    @JsonProperty
    public boolean isOrIntra() {
        return this.orIntra;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.testbedIds.isEmpty() && this.organisationIds.isEmpty() && this.categoryNames.isEmpty() && this.federationIds.isEmpty();
    }

    @JsonIgnore
    public boolean serverMatches(@Nullable Server server) {
        if (server == null) {
            return false;
        }
        if (server.getTestbedId() == null || server.getTestbed() == null) {
            return false;
        }
        Testbed testbed = server.getTestbed();
        assert (Objects.equals(testbed.getId(), server.getTestbedId()));
        String testbedId = server.getTestbedId();
        boolean testbedMatch = this.testbedIds.stream().anyMatch(testbedId::equals);
        if (testbedMatch && this.orIntra) {
            return true;
        }
        if (!(this.testbedIds.isEmpty() || testbedMatch || this.orIntra)) {
            return false;
        }
        if (testbed.getFederations() != null) {
            boolean anyFedMatch = false;
            for (String federationId : this.federationIds) {
                if (!testbed.getFederations().stream().map(PrimaryIdObject::getId).anyMatch(federationId::equals)) continue;
                anyFedMatch = true;
            }
            if (anyFedMatch && this.orIntra) {
                return true;
            }
            if (!(this.federationIds.isEmpty() || anyFedMatch || this.orIntra)) {
                return false;
            }
        }
        if (testbed.getOrganisation() != null) {
            boolean anyOrgMatch = false;
            if (this.organisationIds.stream().anyMatch(oid -> ((String)testbed.getOrganisation().getId()).equals(oid))) {
                anyOrgMatch = true;
            }
            if (anyOrgMatch && this.orIntra) {
                return true;
            }
            if (!(this.organisationIds.isEmpty() || anyOrgMatch || this.orIntra)) {
                return false;
            }
        }
        if (testbed.getCategoryNames() != null) {
            boolean anyCatMatch = false;
            if (!Collections.disjoint(testbed.getCategoryNames(), this.categoryNames)) {
                anyCatMatch = true;
            }
            if (anyCatMatch && this.orIntra) {
                return true;
            }
            if (!(this.categoryNames.isEmpty() || anyCatMatch || this.orIntra)) {
                return false;
            }
        }
        return !this.orIntra;
    }

    @Nonnull
    @JsonIgnore
    public Predicate<Server> getServerFilter() {
        if (this.isEmpty()) {
            return s -> true;
        }
        return this::serverMatches;
    }

    @Nonnull
    @JsonIgnore
    public Predicate<Resource> getResourceFilter() {
        if (this.isEmpty()) {
            return r -> true;
        }
        return resource -> this.serverMatches(resource.getServer());
    }

    @Nonnull
    @JsonIgnore
    public Predicate<ResourceClass> getResourceClassFilter() {
        if (this.isEmpty()) {
            return rc -> true;
        }
        return resourceClass -> {
            if (!this.isEmpty() && ((String)resourceClass.getId()).toLowerCase().startsWith("generic-node")) {
                return false;
            }
            return resourceClass.getResources().stream().anyMatch(this.getResourceFilter());
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolBoxFilter that = (ToolBoxFilter)o;
        return Objects.equals(this.testbedIds, that.testbedIds) && Objects.equals(this.organisationIds, that.organisationIds) && Objects.equals(this.categoryNames, that.categoryNames) && Objects.equals(this.federationIds, that.federationIds) && this.orIntra == ((ToolBoxFilter)o).orIntra;
    }

    public int hashCode() {
        return Objects.hash(this.testbedIds, this.organisationIds, this.categoryNames, this.federationIds, this.orIntra);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (String testbedId : this.testbedIds) {
            res.append(" ").append(testbedId);
        }
        for (String organisationId : this.organisationIds) {
            res.append(" org:").append(organisationId);
        }
        for (String categoryName : this.categoryNames) {
            res.append(" cat:").append(categoryName);
        }
        for (String federationId : this.federationIds) {
            res.append(" fed:").append(federationId);
        }
        return res.toString();
    }
}

