/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class ToolBoxFilterBuilder {
    @Nonnull
    private Set<String> testbedIds;
    @Nonnull
    private Set<String> organisationIds;
    @Nonnull
    private Set<String> categoryNames;
    @Nonnull
    private Set<String> federationIds;
    private boolean orIntra;

    public ToolBoxFilterBuilder() {
        this.testbedIds = new TreeSet<String>();
        this.organisationIds = new TreeSet<String>();
        this.categoryNames = new TreeSet<String>();
        this.federationIds = new TreeSet<String>();
        this.orIntra = false;
    }

    public ToolBoxFilterBuilder(ToolBoxFilter orig) {
        this.testbedIds = new TreeSet<String>(orig.getTestbedIds());
        this.organisationIds = new TreeSet<String>(orig.getOrganisationIds());
        this.categoryNames = new TreeSet<String>(orig.getCategoryNames());
        this.federationIds = new TreeSet<String>(orig.getFederationIds());
        this.orIntra = orig.isOrIntra();
    }

    public ToolBoxFilterBuilder(ToolBoxFilterBuilder orig) {
        this.testbedIds = new TreeSet<String>(orig.testbedIds);
        this.organisationIds = new TreeSet<String>(orig.organisationIds);
        this.categoryNames = new TreeSet<String>(orig.categoryNames);
        this.federationIds = new TreeSet<String>(orig.federationIds);
        this.orIntra = orig.orIntra;
    }

    public ToolBoxFilterBuilder setTestbedIds(Collection<String> testbedIds) {
        this.testbedIds = new TreeSet<String>(testbedIds);
        return this;
    }

    public ToolBoxFilterBuilder setOrganisationIds(Collection<String> organisationIds) {
        this.organisationIds = new TreeSet<String>(organisationIds);
        return this;
    }

    public ToolBoxFilterBuilder setCategoryNames(Collection<String> categoryNames) {
        this.categoryNames = new TreeSet<String>(categoryNames);
        return this;
    }

    public ToolBoxFilterBuilder setFederationIds(Collection<String> federationIds) {
        this.federationIds = new TreeSet<String>(federationIds);
        return this;
    }

    public ToolBoxFilterBuilder setOrIntra(boolean orIntra) {
        this.orIntra = orIntra;
        return this;
    }

    public ToolBoxFilterBuilder addTestbedId(String ... ids) {
        this.testbedIds.addAll(Arrays.asList(ids));
        return this;
    }

    public ToolBoxFilterBuilder addOrganisationId(String ... ids) {
        this.organisationIds.addAll(Arrays.asList(ids));
        return this;
    }

    public ToolBoxFilterBuilder addCategoryName(String ... names) {
        this.categoryNames.addAll(Arrays.asList(names));
        return this;
    }

    public ToolBoxFilterBuilder addFederationId(String ... ids) {
        this.federationIds.addAll(Arrays.asList(ids));
        return this;
    }

    public ToolBoxFilterBuilder removeTestbedId(String id) {
        this.testbedIds.remove(id);
        return this;
    }

    public ToolBoxFilterBuilder removeOrganisationId(String id) {
        this.organisationIds.remove(id);
        return this;
    }

    public ToolBoxFilterBuilder removeCategoryName(String name) {
        this.categoryNames.remove(name);
        return this;
    }

    public ToolBoxFilterBuilder removeFederationId(String id) {
        this.federationIds.remove(id);
        return this;
    }

    public ToolBoxFilter create() {
        return new ToolBoxFilter(this.testbedIds, this.organisationIds, this.categoryNames, this.federationIds, this.orIntra);
    }
}

