/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor;

import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableExperimentCanvas;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Point2D;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DataFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ToolboxItem
extends Label
implements Comparable<ToolboxItem> {
    private static final DataFormat DATA_FORMAT = new DataFormat(new String[]{"jfed/experiment-toolbox-item"});
    @FXML
    protected ImageView imageView;
    private final int weight;
    @Nullable
    private final Image dragImage;

    public ToolboxItem(String id, String text, @Nullable Image image, @Nullable Image dragImage, int weight) {
        this.setId(id);
        URL location = ToolboxItem.class.getResource("ToolboxItem.fxml");
        assert (location != null);
        FXMLLoader fxmlLoader = new FXMLLoader(location, null);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setText(text);
        this.imageView.setImage(image);
        this.dragImage = dragImage;
        this.weight = weight;
    }

    public ToolboxItem(String newId, @Nonnull ToolboxItem item) {
        this(newId, item.getText(), item.getImageView().getImage(), item.dragImage, item.weight);
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    @Nullable
    public Image getDragImage() {
        return this.dragImage;
    }

    public String toString() {
        return "ToolboxItem{imageView=" + String.valueOf(this.imageView) + "}";
    }

    public static DataFormat getDragDataFormat() {
        return DATA_FORMAT;
    }

    public final int getWeight() {
        return this.weight;
    }

    public abstract void onAddedToCanvas(EditableExperimentCanvas var1, Point2D var2);

    @Override
    public int compareTo(@Nonnull ToolboxItem o) {
        return o.getWeight() - this.getWeight();
    }
}

