/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.actions;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.CreateReservationAction;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.ProcessUnboundNodesAction;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.SaveRspecAction;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.StartExperimentAction;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EditorActionsFactory {
    private final TaskService taskService;
    private final JFedPreferences jFedPreferences;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final JFedGuiConfig conf;
    private final DialogsFactory dialogsFactory;
    private final BrowserUtil browserUtil;

    @Inject
    public EditorActionsFactory(TaskService taskService, JFedPreferences jFedPreferences, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, JFedGuiConfig conf, DialogsFactory dialogsFactory, BrowserUtil browserUtil) {
        this.taskService = taskService;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.conf = conf;
        this.dialogsFactory = dialogsFactory;
        this.browserUtil = browserUtil;
    }

    public SaveRspecAction createSaveRspecAction(EditableRspec editableRspec, Window parentWindow) {
        return new SaveRspecAction(editableRspec, parentWindow, this.taskService, this.jFedPreferences);
    }

    public ProcessUnboundNodesAction createProcessUnboundNodesAction(EditableRspec editableRspec, Window parentWindow) {
        return new ProcessUnboundNodesAction(editableRspec, parentWindow, this.testbedInfoSource, this.conf, this.browserUtil);
    }

    public StartExperimentAction createStartExperimentAction(EditableRspec editableRspec, Window parentWindow) {
        return new StartExperimentAction(editableRspec, parentWindow, this, this.testbedInfoSource, this.authorityFinder, this.dialogsFactory);
    }

    public CreateReservationAction createCreateReservationAction(EditableRspec editableRspec, Window parentWindow) {
        return new CreateReservationAction(editableRspec, parentWindow, this, this.testbedInfoSource, this.authorityFinder, this.dialogsFactory);
    }
}

