/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.actions;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorAction;
import be.iminds.ilabt.jfed.experimenter_gui.ui.HealthStatusPane;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ResourceCell;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUnboundNodesAction
extends EditorAction<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUnboundNodesAction.class);
    private final RequestRspecSource requestRspecSource;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedGuiConfig config;
    private final BrowserUtil browserUtil;

    ProcessUnboundNodesAction(EditableRspec editableRspec, Window parentWindow, TestbedInfoSource testbedInfoSource, JFedGuiConfig config, BrowserUtil browserUtil) {
        super(editableRspec, parentWindow);
        this.testbedInfoSource = testbedInfoSource;
        this.config = config;
        this.requestRspecSource = editableRspec.getRequestRspecSource();
        this.browserUtil = browserUtil;
    }

    @Override
    public Boolean call() {
        FXModelRspec modelRspec = (FXModelRspec)this.requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        if (modelRspec == null) {
            LOG.warn("Cannot process unbound nodes as modelRspec is null!");
            return false;
        }
        FilteredList unboundNodes = modelRspec.getNodes().filtered(input1 -> input1.getComponentManagerId() == null);
        if (!unboundNodes.isEmpty()) {
            if (this.requestRspecSource.isLosingData(ModelRspecType.FX)) {
                LOG.warn("Cannot process unbound nodes as modelRspec is losing data!");
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setContentText("jFed detected unbound resources. These need to be bound to an authority before the experiment can be run.jFed has detected that information will be lost when resolving this issue. Do you want to continue?");
                alert.setTitle("Unbound nodes detected");
                alert.setHeaderText("Unbound nodes detected");
                alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                alert.setResizable(true);
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
                if (alert.showAndWait().orElse(ButtonType.NO) == ButtonType.NO) {
                    return false;
                }
                LOG.info("User accepted data loss to resolve unbound nodes.");
            }
            Dialog dialog = new Dialog();
            dialog.initOwner(this.parentWindow);
            dialog.setTitle("Unbound nodes detected");
            dialog.setHeaderText("Unbound nodes detected");
            dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PUZZLE_PIECE, (Color)Color.CHOCOLATE));
            dialog.setContentText(String.format("This RSpec contains %d unbound nodes. These nodes need to be assigned to a testbed before starting the experiment.\n\nDo you want to assign these nodes to a testbed now, or do you want to resolve this issue later?", unboundNodes.size()));
            ButtonType resolveNowButtonType = new ButtonType("Assign these nodes now", ButtonBar.ButtonData.YES);
            ButtonType resolveLaterButtonType = new ButtonType("Resolve later", ButtonBar.ButtonData.NO);
            dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{resolveNowButtonType, resolveLaterButtonType});
            Optional result = dialog.showAndWait();
            if (!result.isPresent() || result.get() != resolveNowButtonType) {
                return false;
            }
            ArrayList<Server> bindableAuthorities = new ArrayList<Server>(this.config.getBindableServers());
            bindableAuthorities.sort(Comparator.comparing(auth -> auth.getName().toLowerCase()));
            Dialog unboundNodesDialog = new Dialog();
            unboundNodesDialog.initOwner(this.parentWindow);
            unboundNodesDialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PUZZLE_PIECE, (Color)Color.CHOCOLATE));
            unboundNodesDialog.setHeaderText("Unbound nodes detected");
            VBox dialogContent = new VBox(10.0);
            dialogContent.getChildren().add((Object)new Label(String.format("Please select the testbed to which the %d unbound nodes must be assigned:", unboundNodes.size())));
            ComboBox serverComboBox = new ComboBox();
            serverComboBox.setPrefWidth(300.0);
            serverComboBox.setCellFactory(param -> new ResourceCell(null, this.config, null));
            serverComboBox.setConverter(StringConverters.SERVER_STRING_CONVERTER);
            serverComboBox.getItems().setAll(bindableAuthorities);
            unboundNodesDialog.getDialogPane().setContent((Node)dialogContent);
            unboundNodesDialog.setResultConverter(param -> {
                if (param == ButtonType.OK) {
                    return (Server)serverComboBox.getSelectionModel().getSelectedItem();
                }
                return null;
            });
            dialogContent.getChildren().add((Object)serverComboBox);
            HealthStatusPane healthStatusPane = new HealthStatusPane();
            healthStatusPane.setBrowserUtil(this.browserUtil);
            healthStatusPane.setConfig(this.config);
            dialogContent.getChildren().add((Object)healthStatusPane);
            serverComboBox.getSelectionModel().selectedItemProperty().addListener(observable -> healthStatusPane.setServer((Server)serverComboBox.getSelectionModel().getSelectedItem()));
            unboundNodesDialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
            Node okButton = unboundNodesDialog.getDialogPane().lookupButton(ButtonType.OK);
            okButton.disableProperty().bind((ObservableValue)serverComboBox.getSelectionModel().selectedItemProperty().isNull());
            Optional chosenAuthorityInfo = unboundNodesDialog.showAndWait();
            if (chosenAuthorityInfo.isPresent()) {
                for (RspecNode rspecNode : unboundNodes) {
                    rspecNode.setComponentManagerId(((Server)chosenAuthorityInfo.get()).getDefaultComponentManagerAsGeniUrn());
                }
                this.editableRspec.setRequestRspecSource((RequestRspecSource)new ImmutableRequestRspecSource((ModelRspec)modelRspec));
                return true;
            }
            return false;
        }
        return true;
    }
}

