/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.actions;

import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorAction;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorActionsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.ProcessUnboundNodesAction;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationEngine;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.HashSet;
import java.util.Set;
import javafx.stage.Window;

public abstract class RspecValidatingEditorAction<T>
extends EditorAction<T> {
    private final RspecValidationEngine validationEngine = new RspecValidationEngine();
    protected final EditorActionsFactory editorActionsFactory;
    protected final AuthorityFinder authorityFinder;
    protected final TestbedInfoSource testbedInfoSource;

    protected RspecValidatingEditorAction(EditableRspec editableRspec, Window parentWindow, EditorActionsFactory editorActionsFactory, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder) {
        super(editableRspec, parentWindow);
        this.editorActionsFactory = editorActionsFactory;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
    }

    protected boolean prepareAndValidateRequestRspec() {
        RequestRspecSource requestRspecSource = this.editableRspec.getRequestRspecSource();
        RspecValidationResult verifyRspecResult = this.validationEngine.validateRSpec(RspecCheckReason.RUN_EXPERIMENT, requestRspecSource, this.parentWindow);
        if (verifyRspecResult != null) {
            if (verifyRspecResult.isAbort()) {
                return false;
            }
            this.editableRspec.setRequestRspecSource(verifyRspecResult.getReplacementRequestRspecSource());
        }
        ProcessUnboundNodesAction processUnboundNodesAction = this.editorActionsFactory.createProcessUnboundNodesAction(this.editableRspec, this.parentWindow);
        return processUnboundNodesAction.call();
    }

    protected Set<GeniUrn> getUnkownComponentManagerUrns(RequestRspecSource requestRspecSource) {
        HashSet<GeniUrn> unknownComponentManagerUrns = new HashSet<GeniUrn>();
        for (GeniUrn componentManagerUrn : requestRspecSource.getAllComponentManagerUrns()) {
            Server auth = this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.CREATE_SLIVER);
            if (auth != null) continue;
            unknownComponentManagerUrns.add(componentManagerUrn);
        }
        return unknownComponentManagerUrns;
    }
}

