/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.actions;

import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorAction;
import be.iminds.ilabt.jfed.experimenter_gui.editor.tasks.SaveRspecTask;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.util.FileUtils;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.io.File;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveRspecAction
extends EditorAction<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(SaveRspecAction.class);
    private final TaskService taskService;
    private final JFedPreferences jFedPreferences;

    SaveRspecAction(EditableRspec editableRspec, Window parentWindow, TaskService taskService, JFedPreferences jFedPreferences) {
        super(editableRspec, parentWindow);
        this.taskService = taskService;
        this.jFedPreferences = jFedPreferences;
    }

    @Override
    public Boolean call() {
        File file;
        File dir;
        String defaultRspecFolder;
        File home;
        FileChooser fc = new FileChooser();
        fc.setTitle("Save experiment");
        fc.getExtensionFilters().add((Object)FileUtils.RSPEC_EXTENSION_FILTER);
        fc.setInitialFileName(this.editableRspec.getName() + ".rspec");
        if (System.getProperty("user.home") != null && (home = new File(System.getProperty("user.home"))).exists() && home.isDirectory()) {
            fc.setInitialDirectory(home);
        }
        if ((defaultRspecFolder = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST)) != null && (dir = new File(defaultRspecFolder)).exists() && dir.isDirectory()) {
            fc.setInitialDirectory(dir);
        }
        if (this.editableRspec.getFile() != null) {
            File initial = this.editableRspec.getFile().getParentFile();
            if (initial != null && initial.exists() && initial.isDirectory()) {
                fc.setInitialDirectory(initial);
            }
            fc.setInitialFileName(this.editableRspec.getFile().getName());
        }
        if ((file = fc.showSaveDialog(this.parentWindow)) == null) {
            return false;
        }
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST, file.getParentFile().getAbsolutePath());
        if (!file.getAbsolutePath().endsWith(".rspec")) {
            file = new File(file.getAbsolutePath() + ".rspec");
        }
        this.editableRspec.setName(file.getName().substring(0, file.getName().length() - ".rspec".length()));
        this.taskService.submitTask(new SaveRspecTask(this.editableRspec.getRequestRspecSource(), file));
        this.editableRspec.setFile(file);
        return true;
    }
}

