/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.actions;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.EditorActionsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.actions.RspecValidatingEditorAction;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartExperimentAction
extends RspecValidatingEditorAction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(StartExperimentAction.class);
    private final AuthorityFinder authorityFinder;
    private final DialogsFactory dialogsFactory;

    StartExperimentAction(EditableRspec editableRspec, Window parentWindow, EditorActionsFactory editorActionsFactory, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, DialogsFactory dialogsFactory) {
        super(editableRspec, parentWindow, editorActionsFactory, testbedInfoSource, authorityFinder);
        this.authorityFinder = authorityFinder;
        this.dialogsFactory = dialogsFactory;
    }

    @Override
    public Void call() {
        if (!this.prepareAndValidateRequestRspec()) {
            LOG.debug("Starting experiment aborted because validation failed");
            return null;
        }
        RequestRspecSource requestRspecSource = this.editableRspec.getRequestRspecSource();
        assert (requestRspecSource.getStringRspec() != null);
        if (requestRspecSource.getAllComponentManagerUrns().isEmpty()) {
            JFDialogs.create().owner(this.parentWindow).message("jFed could not find component managers in the RSpec XML. Either there is an error in the RSpec, or jFed does not support this RSpec. Either way, it is impossible to continue, \"Run Experiment\" aborted.").masthead("Fatal Error").showError();
            return null;
        }
        Set<GeniUrn> unknownComponentManagerUrns = this.getUnkownComponentManagerUrns(requestRspecSource);
        if (!unknownComponentManagerUrns.isEmpty()) {
            boolean isStitching;
            String urns = unknownComponentManagerUrns.stream().map(GeniUrn::toString).collect(Collectors.joining(", "));
            StringRspec stringRspec = requestRspecSource.getStringRspec();
            boolean bl = isStitching = stringRspec == null ? false : Objects.equals(stringRspec.isStitching(this.testbedInfoSource, this.authorityFinder), Boolean.TRUE);
            if (!isStitching) {
                JFDialogs.create().owner(this.parentWindow).message("jFed does not have information about some component managers in the RSpec XML: " + urns + " \nIt is impossible to correctly continue, \"Run Experiment\" aborted.").masthead("Fatal Error").showError();
                return null;
            }
            JFDialogs.create().owner(this.parentWindow).message("jFed does not have information about some component managers in the RSpec XML: " + urns + " \nSince the RSpec uses stitching, it is possible to continue. There might be an error later on, or the problem might fix itself.").masthead("Dragons Ahead!").showWarning();
        }
        this.dialogsFactory.showCreateSliceDialog(this.parentWindow, requestRspecSource);
        return null;
    }
}

