/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.addresspool_properties;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressPoolPropertiesDialog
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(AddressPoolPropertiesDialog.class);
    private final FXAddressPool addressPool;
    private final ValidationSupport validationSupport;
    @FXML
    private TextField nameTextField;
    @FXML
    private ComboBox<Server> serverComboBox;
    @FXML
    private TextField countTextField;
    @FXML
    private HBox ipFreeHBox;
    @FXML
    private Label ipFreeLabel;
    @FXML
    private Button saveButton;
    @FXML
    private Button cancelButton;
    private boolean success = false;

    AddressPoolPropertiesDialog(FXAddressPool addressPool, JFedGuiConfig config, TestbedInfoSource testbedInfoSource) {
        this.addressPool = addressPool;
        FXMLUtil.injectFXML((Object)((Object)this));
        assert (this.serverComboBox != null);
        this.serverComboBox.getSelectionModel().selectedItemProperty().addListener(observable -> {
            Server server = (Server)this.serverComboBox.getSelectionModel().getSelectedItem();
            ServerGlimpse serverGlimpse = config.getServerGlimpse(server);
            if (serverGlimpse != null && serverGlimpse.getAdvertisementInfo() != null && serverGlimpse.getAdvertisementInfo().getCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.ALL) != null && serverGlimpse.getAdvertisementInfo().getCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.ALL) > 0) {
                this.ipFreeLabel.setText(serverGlimpse.getAdvertisementInfo().getCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.AVAILABLE) + " of " + serverGlimpse.getAdvertisementInfo().getCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.ALL));
                this.ipFreeHBox.setVisible(true);
            } else {
                this.ipFreeHBox.setVisible(false);
            }
        });
        testbedInfoSource.getServers().stream().filter(server -> server.hasFlag(Server.Flag.featureIPv4AddressPool)).sorted(Comparator.comparing(server -> server.getName().toLowerCase().trim())).forEach(arg_0 -> this.serverComboBox.getItems().add(arg_0));
        this.serverComboBox.setConverter(StringConverters.SERVER_STRING_CONVERTER);
        this.nameTextField.setText(addressPool.getClientId());
        if (addressPool.getComponentManagerId() != null) {
            Server server2 = testbedInfoSource.getByUrnExact(addressPool.getComponentManagerId());
            if (server2 != null) {
                this.serverComboBox.getSelectionModel().select((Object)server2);
            } else {
                LOG.warn("Could not find CMI with URN {}", (Object)addressPool.getComponentManagerId());
            }
        } else {
            this.serverComboBox.getSelectionModel().clearSelection();
        }
        this.countTextField.setText(addressPool.getCount() != null ? Integer.toString(addressPool.getCount()) : "0");
        this.validationSupport = new ValidationSupport();
        this.validationSupport.registerValidator((Control)this.nameTextField, Validator.createPredicateValidator(ModelRspecEditor::isValidNodeName, (String)"You must provide a client ID"));
        this.validationSupport.registerValidator(this.serverComboBox, Validator.createEmptyValidator((String)"You must choose a testbed"));
        this.validationSupport.registerValidator((Control)this.countTextField, Validator.createPredicateValidator(s -> {
            try {
                return Integer.parseInt(s) > 0;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }, (String)"You must provide a positive number of IPs to request"));
        this.saveButton.disableProperty().bind((ObservableValue)this.validationSupport.invalidProperty());
    }

    @FXML
    public void onSaveAction(ActionEvent actionEvent) {
        this.addressPool.setClientId(this.nameTextField.getText());
        this.addressPool.setComponentManagerId(((Server)this.serverComboBox.getSelectionModel().getSelectedItem()).getDefaultComponentManagerAsGeniUrn());
        this.addressPool.setCount(Integer.valueOf(Integer.parseInt(this.countTextField.getText())));
        this.success = true;
        Stage stage = (Stage)this.saveButton.getScene().getWindow();
        stage.close();
    }

    public boolean isSuccess() {
        return this.success;
    }

    @FXML
    public void onCancelAction(ActionEvent actionEvent) {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }
}

