/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.channel_properties;

import be.iminds.ilabt.jfed.experimenter_gui.config.AdvertisementFetchManager;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.lib.JFedConnectivityException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class ChannelPropertiesDialog
extends BorderPane {
    private final FXRspecChannel channel;
    private final FXModelRspec modelRspec;
    private final AdvertisementFetchManager advertisementFetchManager;
    private final ObjectProperty<AdvertisementFetchManager.Resources.RefreshAdvertisementTask> activeRefreshTask = new SimpleObjectProperty(null);
    @FXML
    private ComboBox<Server> serverComboBox;
    @FXML
    private ComboBox<Channel> channelComboBox;
    @FXML
    private ProgressBar advertisementFetchProgressBar;
    @FXML
    private VBox advertisementFetchOverlay;
    @FXML
    private Button saveButton;
    @FXML
    private Button cancelButton;
    private boolean success = false;

    ChannelPropertiesDialog(FXRspecChannel channel, FXModelRspec modelRspec, TestbedInfoSource testbedInfoSource, AdvertisementFetchManager advertisementFetchManager) {
        this.channel = channel;
        this.modelRspec = modelRspec;
        this.advertisementFetchManager = advertisementFetchManager;
        FXMLUtil.injectFXML((Object)((Object)this));
        testbedInfoSource.getServers().stream().filter(server -> server.hasFlag(Server.Flag.featureWirelessChannelReservation)).forEach(arg_0 -> this.serverComboBox.getItems().add(arg_0));
        this.serverComboBox.setConverter(StringConverters.SERVER_STRING_CONVERTER);
        this.channelComboBox.setConverter(StringConverters.CHANNEL_CONVERTER);
        this.serverComboBox.getSelectionModel().selectedItemProperty().addListener(obj -> this.updateChannels());
        this.advertisementFetchOverlay.visibleProperty().bind((ObservableValue)this.activeRefreshTask.isNotNull());
        this.activeRefreshTask.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.advertisementFetchProgressBar.progressProperty().unbind();
            }
            if (newValue != null) {
                this.advertisementFetchProgressBar.progressProperty().bind((ObservableValue)newValue.progressProperty());
            }
        });
        if (channel.getComponentManagerId() != null) {
            Server server2 = testbedInfoSource.getByUrnExact(channel.getComponentManagerId());
            this.serverComboBox.setValue((Object)server2);
        } else {
            this.serverComboBox.getItems().sort(Comparator.comparing(this::getNumberOfNodesInRspec).reversed().thenComparing(server -> server.getName().toLowerCase().trim()));
            this.serverComboBox.getSelectionModel().selectFirst();
        }
        if (channel.getComponentId() != null) {
            this.channelComboBox.setValue((Object)this.channelComboBox.getItems().stream().filter(ch -> Objects.equals(ch.getComponentId(), channel.getComponentId())).findAny().orElse((Channel)channel));
        }
    }

    private int getNumberOfNodesInRspec(Server server) {
        return this.modelRspec.getNodes().filtered(node -> node.getComponentManagerId() != null && Objects.equals(node.getComponentManagerId(), server.getDefaultComponentManagerAsGeniUrn())).size();
    }

    private void updateChannels() {
        Server server = (Server)this.serverComboBox.getSelectionModel().getSelectedItem();
        if (server != null) {
            AdvertisementFetchManager.AllResources resources = this.advertisementFetchManager.getAllResources(server);
            if (resources.getAdvertisementRspecSource() == null) {
                resources = this.advertisementFetchManager.getAvailableResources(server);
            }
            if (resources.getAdvertisementRspecSource() == null) {
                this.onRefreshAdvertisementAction();
            } else {
                FXModelRspec modelRspec = (FXModelRspec)resources.getAdvertisementRspecSource().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
                assert (modelRspec != null);
                this.channelComboBox.getItems().setAll((Collection)modelRspec.getChannels());
            }
        }
    }

    @FXML
    private void onRefreshAdvertisementAction() {
        Server server = (Server)this.serverComboBox.getSelectionModel().getSelectedItem();
        assert (server != null);
        AdvertisementFetchManager.Resources.RefreshAdvertisementTask updateAdvTask = this.advertisementFetchManager.getAllResources(server).refreshAdvertisement();
        this.activeRefreshTask.set((Object)updateAdvTask);
        EventHandler removeOnFinished = value -> {
            if (this.activeRefreshTask.get() == updateAdvTask) {
                this.activeRefreshTask.set(null);
            }
            this.updateChannels();
        };
        updateAdvTask.setOnSucceeded(removeOnFinished);
        updateAdvTask.setOnCancelled(removeOnFinished);
        updateAdvTask.setOnFailed(workerStateEvent -> {
            removeOnFinished.handle(workerStateEvent);
            if (this.getScene() != null) {
                if (ChannelPropertiesDialog.isConnectivityException(updateAdvTask.getException())) {
                    JFDialogs.create().owner((Node)this).message(String.format("A connectivity exception occurred while fetching the advertisement RSpec from %s.\n\nVerify your internet connection, and consider enabling a proxy in the jFed Preferences.", server.getName())).masthead("Fetching advertisement RSpec failed").title("Fetching advertisement RSpec failed").showException(updateAdvTask.getException());
                } else {
                    JFDialogs.create().owner((Node)this).message(String.format("An error occurred while fetching the advertisement RSpec from %s.", server.getName())).masthead("Fetching advertisement RSpec failed").title("Fetching advertisement RSpec failed").showException(updateAdvTask.getException());
                }
            }
        });
    }

    private static boolean isConnectivityException(Throwable t) {
        while (t != null) {
            if (t.getCause() instanceof JFedConnectivityException) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    @FXML
    public void onSaveAction(ActionEvent actionEvent) {
        if (this.channelComboBox.getValue() == null) {
            JFDialogs.create().owner((Node)this).message("Please select a channel from the dropdown list.").masthead("No channel selected.").showError();
            return;
        }
        Channel selectedChannel = (Channel)this.channelComboBox.getValue();
        this.channel.setComponentManagerId(selectedChannel.getComponentManagerId());
        this.channel.setComponentId(selectedChannel.getComponentId());
        this.channel.setComponentName(selectedChannel.getComponentName());
        this.success = true;
        Stage stage = (Stage)this.saveButton.getScene().getWindow();
        stage.close();
    }

    @FXML
    public void onCancelAction(ActionEvent actionEvent) {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }

    public boolean isSuccess() {
        return this.success;
    }
}

