/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.channel_properties;

import be.iminds.ilabt.jfed.experimenter_gui.config.AdvertisementFetchManager;
import be.iminds.ilabt.jfed.experimenter_gui.editor.channel_properties.ChannelPropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.FXUtils;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChannelPropertiesDialogFactory {
    private final TestbedInfoSource testbedInfoSource;
    private final AdvertisementFetchManager advertisementFetchManager;

    @Inject
    public ChannelPropertiesDialogFactory(TestbedInfoSource testbedInfoSource, AdvertisementFetchManager advertisementFetchManager) {
        this.testbedInfoSource = testbedInfoSource;
        this.advertisementFetchManager = advertisementFetchManager;
    }

    public ChannelPropertiesDialog createChannelPropertiesDialog(FXRspecChannel channel, FXModelRspec modelRspec) {
        return new ChannelPropertiesDialog(channel, modelRspec, this.testbedInfoSource, this.advertisementFetchManager);
    }

    public boolean showChannelPropertiesDialog(Window parent, FXRspecChannel channel, FXModelRspec modelRspec) {
        ChannelPropertiesDialog channelPropertiesDialog = this.createChannelPropertiesDialog(channel, modelRspec);
        Scene scene = new Scene((Parent)channelPropertiesDialog);
        Stage dialogStage = new Stage();
        StageUtils.setJFedStageIcons((Stage)dialogStage);
        dialogStage.setScene(scene);
        dialogStage.setTitle("Channel properties");
        dialogStage.setMinHeight(300.0);
        dialogStage.setMaxHeight(300.0);
        dialogStage.setMinWidth(500.0);
        FXUtils.centerToOwner(parent, (Window)dialogStage);
        dialogStage.showAndWait();
        return channelPropertiesDialog.isSuccess();
    }
}

