/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.impl;

import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolboxItem;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressPoolToolboxItem
extends ToolboxItem {
    private static final Logger LOG = LoggerFactory.getLogger(AddressPoolToolboxItem.class);
    public static final int WEIGHT = -200;

    public AddressPoolToolboxItem() {
        super("addresspool", "Address Pool", new Image(ImageUtil.class.getResource("/images/node_types/64/addresspool.png").toExternalForm()), new Image(ImageUtil.class.getResource("/images/node_types/32/addresspool.png").toExternalForm()), -200);
    }

    @Override
    public void onAddedToCanvas(EditableExperimentCanvas canvas, Point2D location) {
        FXAddressPool addressPool = canvas.getEditor().addAddressPool(location);
        List<Server> serversWithAddressPool = canvas.getAddressPoolEnabledServers();
        if (serversWithAddressPool != null && !serversWithAddressPool.isEmpty()) {
            addressPool.setComponentManagerId(serversWithAddressPool.get(0).getDefaultComponentManagerAsGeniUrn());
        } else {
            boolean success = canvas.onConfigureAddressPoolPressed(addressPool);
            if (success) {
                LOG.debug("Adding address pool {} to canvas", (Object)addressPool.getClientId());
                canvas.setStatus("Added channel " + addressPool.getClientId() + " to the canvas");
            } else {
                LOG.warn("User did not properly configure address pool. Removing it again!");
                canvas.getModel().deleteAddressPool((AddressPool)addressPool);
                canvas.setStatus("Address pool was not properly configured!");
            }
        }
    }
}

