/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.impl;

import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolboxItem;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelToolboxItem
extends ToolboxItem {
    private static final Logger LOG = LoggerFactory.getLogger((String)ChannelToolboxItem.class.getName());
    public static final int WEIGHT = -100;

    public ChannelToolboxItem() {
        super("channel", "Wireless Channel", new Image(ImageUtil.class.getResource("/images/wireless-channel.png").toExternalForm()), new Image(ImageUtil.class.getResource("/images/wireless-channel.png").toExternalForm(), 32.0, 32.0, true, true), -100);
    }

    @Override
    public void onAddedToCanvas(EditableExperimentCanvas canvas, Point2D location) {
        FXRspecChannel channel = canvas.getEditor().addChannel(location);
        boolean success = canvas.onConfigureChannelPressed(channel);
        if (success) {
            LOG.debug("Adding channel {} to canvas", (Object)channel.getComponentName());
            canvas.setStatus("Added channel " + channel.getComponentName() + " to the canvas");
        } else {
            LOG.warn("User did not properly configure channel. Removing it again!");
            canvas.getModel().deleteChannel((Channel)channel);
            canvas.setStatus("Channel was not properly configured!");
        }
    }
}

