/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.impl;

import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolboxItem;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageSize;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import javafx.geometry.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeResourceClassToolboxItem
extends ToolboxItem {
    private static final Logger LOG = LoggerFactory.getLogger(NodeResourceClassToolboxItem.class);
    private final ResourceClass resourceClass;

    public NodeResourceClassToolboxItem(ResourceClass resourceClass) {
        super("node-" + (String)resourceClass.getId(), resourceClass.getHrn(), ImageUtil.getNodeDescriptionImage(resourceClass, ImageSize.MEDIUM), ImageUtil.getNodeDescriptionImage(resourceClass, ImageSize.SMALL), resourceClass.getWeightOrZero());
        this.resourceClass = resourceClass;
    }

    @Override
    public void onAddedToCanvas(EditableExperimentCanvas canvas, Point2D location) {
        FXRspecNode rspecNode = canvas.getEditor().addNode(this.resourceClass, location);
        if (rspecNode != null) {
            LOG.debug("Added node {} to canvas", (Object)rspecNode.getClientId());
            canvas.setStatus("Added node " + rspecNode.getClientId() + " to the canvas");
        } else {
            canvas.setStatus("Node was not properly configured!");
        }
    }
}

