/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.link_properties;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.util.InetAddressUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXLinkSetting;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.controlsfx.dialog.CommandLinksDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkPropertiesDialog
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(LinkPropertiesDialog.class);
    private final FXRspecLink link;
    private final FXModelRspec model;
    private final ModelRspecEditor modelRspecEditor;
    private final String ipv4Subnetwork;
    private final String ipv6Subnetwork;
    private final ObservableList<FXLinkSetting> impairmentList;
    @FXML
    private Button saveButton;
    @FXML
    private Button cancelButton;
    @FXML
    private TextField nameTextField;
    @FXML
    private RadioButton autoConfigRadioButton;
    @FXML
    private RadioButton ipv4RadioButton;
    @FXML
    private RadioButton ipv6RadioButton;
    @FXML
    private ToggleGroup ipToggleGroup;
    @FXML
    private TableView<RspecInterfaceWithIpAddress> addressesTableView;
    @FXML
    private TableColumn<RspecInterfaceWithIpAddress, String> idTableColumn;
    @FXML
    private TableColumn<RspecInterfaceWithIpAddress, String> ipTableColumn;
    @FXML
    private TableColumn<RspecInterfaceWithIpAddress, String> netmaskTableColumn;
    @FXML
    private ToggleGroup impairmentToggleGroup;
    @FXML
    private RadioButton simpleLinkImpairmentRadioButton;
    @FXML
    private TextField capacityTextField;
    @FXML
    private TextField latencyTextField;
    @FXML
    private TextField packetLossTextField;
    private final LongProperty capacity = new SimpleLongProperty();
    private final IntegerProperty latency = new SimpleIntegerProperty();
    private final DoubleProperty packetLoss = new SimpleDoubleProperty();
    @FXML
    private CheckBox capacityCheckBox;
    @FXML
    private CheckBox latencyCheckBox;
    @FXML
    private CheckBox packetLossCheckBox;
    @FXML
    private RadioButton advancedLinkImpairmentRadioButton;
    @FXML
    private TableView<FXLinkSetting> advancedImpairmentTableView;
    @FXML
    private TableColumn<FXLinkSetting, String> fromTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, String> toTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, Number> capacityTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, Number> latencyTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, Number> packetLossTableColumn;
    private final ObservableList<RspecInterfaceWithIpAddress> addressesList;
    @FXML
    private Tab linkTypeTab;
    @FXML
    private ComboBox<String> linkTypeComboBox;
    @FXML
    private Label linkTypeSupportedLabel;
    @FXML
    private CheckBox sharedLanCheckBox;
    @FXML
    private TextField sharedLanTextField;
    @FXML
    private CheckBox createSharedLanCheckBox;
    @FXML
    private TextField createSharedLanTextField;
    @FXML
    private Label createSharedLanInfo;
    @FXML
    private CheckBox vlanTaggingCheckBox;
    @FXML
    private CheckBox noMacLearningCheckBox;
    @FXML
    private CheckBox linkMultiplexingCheckBox;
    @FXML
    private CheckBox bestEffortCheckBox;
    @FXML
    private CheckBox disallowInterswitchCheckBox;
    private final TestbedInfoSource testbedInfoSource;

    LinkPropertiesDialog(ModelRspecEditor modelRspecEditor, FXRspecLink link, TestbedInfoSource testbedInfoSource, JFedGuiConfig guiConfig) {
        boolean bl;
        this.modelRspecEditor = modelRspecEditor;
        this.testbedInfoSource = testbedInfoSource;
        this.model = modelRspecEditor.getModelRspec();
        this.link = link;
        String inet4subnet = ModelRspecEditor.getInet4SubnetworkFromLink(link);
        if (inet4subnet == null) {
            inet4subnet = modelRspecEditor.getNextAvailableInet4Subnetwork();
        }
        this.ipv4Subnetwork = inet4subnet;
        String inet6subnet = ModelRspecEditor.getInet6SubnetworkFromLink(link);
        if (inet6subnet == null) {
            inet6subnet = InetAddressUtil.generateInet6Subnetwork();
        }
        this.ipv6Subnetwork = inet6subnet;
        this.impairmentList = link.getLinkSettings();
        FXMLUtil.injectFXML((Object)((Object)this));
        this.nameTextField.setText(link.getClientId());
        this.idTableColumn.setCellValueFactory(p -> ((RspecInterfaceWithIpAddress)p.getValue()).getRspecInterface().clientIdProperty());
        this.ipTableColumn.setCellValueFactory(p -> ((RspecInterfaceWithIpAddress)p.getValue()).ipAddressProperty());
        this.netmaskTableColumn.setCellValueFactory(p -> ((RspecInterfaceWithIpAddress)p.getValue()).netmaskProperty());
        this.addressesList = FXCollections.observableArrayList();
        this.addressesTableView.setItems(this.addressesList);
        HashSet<Resource> connectedResources = new HashSet<Resource>();
        for (FXRspecInterface iface : link.getInterfaces()) {
            Object resourceClass;
            Resource resource;
            FXRspecNode node;
            this.addressesList.add((Object)new RspecInterfaceWithIpAddress(iface));
            if (!iface.getIpAddresses().isEmpty()) {
                RspecInterface.IpAddress ipAddress = (RspecInterface.IpAddress)iface.getIpAddresses().get(0);
                if ("ipv4".equalsIgnoreCase(ipAddress.getType())) {
                    this.ipv4RadioButton.setSelected(true);
                } else if ("ipv6".equalsIgnoreCase(ipAddress.getType())) {
                    this.ipv6RadioButton.setSelected(true);
                }
            }
            if ((node = iface.getNode()) == null || (resource = guiConfig.findBestResource(resourceClass = node instanceof FXRspecNode ? (node.getResourceClassId() == null ? null : guiConfig.getResourceClass(node.getResourceClassId())) : null, (RspecNode)node, null)) == null) continue;
            connectedResources.add(resource);
        }
        this.ipToggleGroup.selectedToggleProperty().addListener(observable -> {
            block4: {
                block3: {
                    for (RspecInterfaceWithIpAddress iface : this.addressesList) {
                        iface.clear();
                    }
                    if (this.ipToggleGroup.getSelectedToggle() != this.ipv4RadioButton) break block3;
                    int i = 1;
                    for (RspecInterfaceWithIpAddress iface : this.addressesList) {
                        iface.setIpAddress(this.ipv4Subnetwork + "." + i);
                        ++i;
                        iface.setNetmask("255.255.255.0");
                    }
                    break block4;
                }
                if (this.ipToggleGroup.getSelectedToggle() != this.ipv6RadioButton) break block4;
                int i = 1;
                for (RspecInterfaceWithIpAddress iface : this.addressesList) {
                    iface.setIpAddress(this.ipv6Subnetwork + "::" + i);
                    ++i;
                    iface.setNetmask("64");
                }
            }
        });
        this.ipTableColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.netmaskTableColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.idTableColumn.prefWidthProperty().bind((ObservableValue)this.addressesTableView.widthProperty().multiply(0.3));
        this.ipTableColumn.prefWidthProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.ipv6RadioButton.selectedProperty()).then((ObservableNumberValue)this.addressesTableView.widthProperty().multiply(0.5)).otherwise((ObservableNumberValue)this.addressesTableView.widthProperty().multiply(0.35)));
        this.netmaskTableColumn.prefWidthProperty().bind((ObservableValue)this.addressesTableView.widthProperty().subtract((ObservableNumberValue)this.idTableColumn.widthProperty()).subtract((ObservableNumberValue)this.ipTableColumn.widthProperty()).subtract(2));
        this.ipTableColumn.editableProperty().bind((ObservableValue)this.autoConfigRadioButton.selectedProperty().not());
        this.netmaskTableColumn.editableProperty().bind((ObservableValue)this.ipTableColumn.editableProperty());
        FXLinkSetting ls = (FXLinkSetting)link.getLinkSettings().get(0);
        this.capacity.setValue((Number)ls.getCapacity_Kbps());
        this.latency.setValue((Number)ls.getLatency_ms());
        this.packetLoss.setValue((Number)ls.getPacketLoss());
        if (this.hasAdvancedImpairmentSettings()) {
            this.impairmentToggleGroup.selectToggle((Toggle)this.advancedLinkImpairmentRadioButton);
        }
        this.capacityTextField.textProperty().bindBidirectional((Property)this.capacity, (StringConverter)new NumberStringConverter());
        this.capacityTextField.focusedProperty().addListener(observable -> {
            if (!this.capacityTextField.isFocused() && this.capacity.get() < 0L) {
                JFDialogs.create().owner(this.capacityTextField.getScene().getWindow()).message("Capacity must be a non-negative value").masthead("Invalid Capacity Loss value").showError();
                this.capacity.setValue((Number)0);
            }
        });
        this.capacityCheckBox.selectedProperty().bind((ObservableValue)Bindings.notEqual((int)0, (ObservableNumberValue)this.capacity));
        this.capacityCheckBox.selectedProperty().addListener(observable -> LOG.debug("new checkbox value:" + this.capacityCheckBox.isSelected()));
        this.latencyTextField.textProperty().bindBidirectional((Property)this.latency, (StringConverter)new NumberStringConverter());
        this.latencyTextField.focusedProperty().addListener(observable -> {
            if (!this.latencyTextField.isFocused() && this.latency.get() < 0) {
                JFDialogs.create().owner(this.latencyTextField.getScene().getWindow()).message("Latency must be a non-negative value").masthead("Invalid Latency value").showError();
                this.latency.setValue((Number)0);
            }
        });
        this.latencyCheckBox.selectedProperty().bind((ObservableValue)Bindings.notEqual((int)0, (ObservableNumberValue)this.latency));
        this.packetLossTextField.textProperty().bindBidirectional((Property)this.packetLoss, (StringConverter)new NumberStringConverter());
        this.packetLossTextField.focusedProperty().addListener(observable -> {
            if (!this.packetLossTextField.isFocused() && (this.packetLoss.get() < 0.0 || this.packetLoss.get() > 1.0)) {
                JFDialogs.create().owner((Node)this.packetLossTextField).message("Packet loss must be between 0 and 1").masthead("Invalid Packet Loss value").showError();
                this.packetLoss.setValue((Number)0);
            }
        });
        this.packetLossCheckBox.selectedProperty().bind((ObservableValue)Bindings.notEqual((int)0, (ObservableNumberValue)this.packetLoss));
        this.fromTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).getFromIface().clientIdProperty());
        this.toTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).getToIface().clientIdProperty());
        this.capacityTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.capacityTableColumn.setOnEditCommit(e -> {
            if (((Number)e.getNewValue()).intValue() < 0) {
                JFDialogs.create().owner((Node)this.capacityTextField).message("Capacity must be a non-negative value").masthead("Invalid Capacity value").showError();
                return;
            }
            ((FXLinkSetting)e.getRowValue()).capacity_KbpsProperty().setValue((Number)e.getNewValue());
        });
        this.capacityTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).capacity_KbpsProperty());
        this.latencyTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.latencyTableColumn.setOnEditCommit(e -> {
            if (((Number)e.getNewValue()).intValue() < 0) {
                JFDialogs.create().owner((Node)this.latencyTextField).message("Latency must be a non-negative value").masthead("Invalid Latency value").showError();
                return;
            }
            ((FXLinkSetting)e.getRowValue()).latency_msProperty().setValue((Number)e.getNewValue());
        });
        this.latencyTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).latency_msProperty());
        this.packetLossTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.packetLossTableColumn.setOnEditCommit(e -> {
            if (((Number)e.getNewValue()).doubleValue() < 0.0 || ((Number)e.getNewValue()).doubleValue() > 1.0) {
                JFDialogs.create().owner(this.advancedImpairmentTableView).message("Packet loss must be between 0 and 1").masthead("Invalid Packet Loss value").showError();
                return;
            }
            ((FXLinkSetting)e.getRowValue()).setPacketLoss(Double.valueOf(((Number)e.getNewValue()).doubleValue()));
        });
        this.packetLossTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).packetLossProperty());
        this.capacityTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.packetLossTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.latencyTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.advancedImpairmentTableView.setItems(this.impairmentList);
        this.latencyTextField.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.simpleLinkImpairmentRadioButton.selectedProperty()));
        this.capacityTextField.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.simpleLinkImpairmentRadioButton.selectedProperty()));
        this.packetLossTextField.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.simpleLinkImpairmentRadioButton.selectedProperty()));
        this.advancedImpairmentTableView.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.advancedLinkImpairmentRadioButton.selectedProperty()));
        this.capacity.addListener(observable -> {
            for (FXLinkSetting ls13 : this.link.getLinkSettings()) {
                ls13.setCapacity_Kbps(Long.valueOf(this.capacity.get()));
            }
        });
        this.packetLoss.addListener(observable -> {
            for (FXLinkSetting ls12 : this.link.getLinkSettings()) {
                ls12.setPacketLoss(Double.valueOf(this.packetLoss.get()));
            }
        });
        this.latency.addListener(observable -> {
            for (FXLinkSetting ls1 : this.link.getLinkSettings()) {
                ls1.setLatency_ms(Integer.valueOf(this.latency.get()));
            }
        });
        this.impairmentToggleGroup.selectedToggleProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue == this.simpleLinkImpairmentRadioButton && this.hasAdvancedImpairmentSettings()) {
                Optional dialogResponse = JFDialogs.create().owner(this.advancedImpairmentTableView).message("Switching to simple impairment-mode will cause your advanced settings to reverse. Are you sure?").title("Switching to simple impairment mode").showConfirm();
                if (dialogResponse.isPresent() && dialogResponse.get() == ButtonType.YES) {
                    this.resetAdvancedImpairmentSettings();
                } else {
                    this.impairmentToggleGroup.selectToggle((Toggle)this.advancedLinkImpairmentRadioButton);
                }
            }
        });
        List<String> allKnownLinkTypes = Arrays.asList("lan", "gre-tunnel", "egre-tunnel", "vlan");
        String defaultLinkType = "lan";
        for (Resource resource : connectedResources) {
            if (resource.getDefaultLinkType() == null || Objects.equals(resource.getDefaultLinkType(), defaultLinkType)) continue;
            defaultLinkType = resource.getDefaultLinkType();
            break;
        }
        this.linkTypeComboBox.getItems().addAll(allKnownLinkTypes);
        if (link.getLinkTypes().isEmpty()) {
            this.linkTypeComboBox.getSelectionModel().select((Object)defaultLinkType);
        } else {
            this.linkTypeComboBox.getSelectionModel().select((Object)((String)link.getLinkTypes().get(0)));
        }
        HashSet<String> supportedLinkTypes = new HashSet<String>(allKnownLinkTypes);
        if (!connectedResources.isEmpty()) {
            for (Resource connectedResource : connectedResources) {
                supportedLinkTypes.retainAll(connectedResource.getAllowedLinkTypesOrDefault());
            }
            if (supportedLinkTypes.isEmpty()) {
                this.linkTypeSupportedLabel.setText("NOTE: No link types that support all connected nodes are known");
            } else {
                this.linkTypeSupportedLabel.setText("NOTE: Known supported link types for this link are: " + supportedLinkTypes.stream().collect(Collectors.joining(", ")));
            }
        } else {
            this.linkTypeSupportedLabel.setText("NOTE: No info about supported link types is known");
        }
        this.sharedLanTextField.disableProperty().bind((ObservableValue)this.sharedLanCheckBox.selectedProperty().not());
        if (link.getSharedLan() != null) {
            this.sharedLanCheckBox.setSelected(true);
            this.sharedLanTextField.setText(link.getSharedLan());
        } else {
            this.sharedLanCheckBox.setSelected(false);
            this.sharedLanTextField.setText("");
        }
        this.createSharedLanTextField.disableProperty().bind((ObservableValue)this.createSharedLanCheckBox.selectedProperty().not());
        this.createSharedLanInfo.visibleProperty().bind((ObservableValue)this.createSharedLanCheckBox.selectedProperty());
        this.createSharedLanInfo.managedProperty().bind((ObservableValue)this.createSharedLanInfo.visibleProperty());
        if (!link.getAutoShareLanNames().isEmpty()) {
            this.createSharedLanCheckBox.setSelected(true);
            this.createSharedLanTextField.setText((String)link.getAutoShareLanNames().get(0));
        } else {
            this.createSharedLanCheckBox.setSelected(false);
            this.createSharedLanTextField.setText("");
        }
        this.vlanTaggingCheckBox.setSelected(link.isVlanTaggingEnabled());
        this.noMacLearningCheckBox.setSelected(link.isNoMacLearning());
        this.bestEffortCheckBox.setSelected(link.isBestEffortEnabled());
        this.disallowInterswitchCheckBox.setSelected(link.isInterswitchDisallowed());
        this.linkMultiplexingCheckBox.setSelected(link.isLinkMultiplexingEnabled());
        boolean bl2 = true;
        for (GeniUrn compMan : link.getComponentManagerUrns()) {
            Server auth = this.testbedInfoSource.getByUrn(compMan, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
            if (auth == null) {
                bl = false;
                continue;
            }
            if (auth.getServerType() != null && (auth.getServerType().equalsIgnoreCase("emulab") || auth.getServerType().equalsIgnoreCase("instageni"))) continue;
            bl = false;
        }
        this.linkTypeTab.setDisable(!bl);
    }

    private void resetAdvancedImpairmentSettings() {
        for (FXLinkSetting ls : this.link.getLinkSettings()) {
            ls.setCapacity_Kbps(Long.valueOf(this.capacity.get()));
            ls.setLatency_ms(Integer.valueOf(this.latency.get()));
            ls.setPacketLoss(Double.valueOf(this.packetLoss.get()));
        }
    }

    private boolean hasAdvancedImpairmentSettings() {
        for (FXLinkSetting ls : this.link.getLinkSettings()) {
            if (ls.getLatency_ms() != this.latency.get()) {
                return true;
            }
            if (ls.getCapacity_Kbps() != this.capacity.get()) {
                return true;
            }
            if (ls.getPacketLoss() == this.packetLoss.get()) continue;
            return true;
        }
        return false;
    }

    public static boolean validateIncomingLink(FXRspecLink link) {
        if (link.getInterfaces().size() == 0) {
            JFDialogs.create().title("Link configuration contains errors").message(String.format("Link %s cannot be edited because it's current state is inconsistent. Please check your configuration and try again.\n\n%s", link.getClientId(), "A link must contain at least one interface!")).showError();
            return false;
        }
        ArrayList<FXRspecInterface> ipv4Interfaces = new ArrayList<FXRspecInterface>();
        ArrayList<FXRspecInterface> ipv6Interfaces = new ArrayList<FXRspecInterface>();
        for (FXRspecInterface iface : link.getInterfaces()) {
            if (iface.getIpAddresses().size() >= 2) {
                JFDialogs.create().title("Link configuration contains errors").message(String.format("Link %s cannot be edited because it's current state is inconsistent. Please check your configuration and try again.\n\n%s", link.getClientId(), "Only interfaces with at most one IP-address defined are supported")).showError();
                return false;
            }
            if (iface.getIpAddresses().isEmpty()) continue;
            RspecInterface.IpAddress ipAddress = (RspecInterface.IpAddress)iface.getIpAddresses().get(0);
            if ("ipv4".equalsIgnoreCase(ipAddress.getType())) {
                ipv4Interfaces.add(iface);
                continue;
            }
            if (!"ipv6".equalsIgnoreCase(ipAddress.getType())) continue;
            ipv6Interfaces.add(iface);
        }
        if (!ipv4Interfaces.isEmpty() && !ipv6Interfaces.isEmpty()) {
            CommandLinksDialog.CommandLinksButtonType keepIpv4Action = new CommandLinksDialog.CommandLinksButtonType("Keep IPv4 addresses", String.format("Remove the %d IPv6-address(es) from the link, and keep the %d IPv4-address(es).", ipv6Interfaces.size(), ipv4Interfaces.size()), false);
            CommandLinksDialog.CommandLinksButtonType keepIpv6Action = new CommandLinksDialog.CommandLinksButtonType("Keep IPv6 addresses", String.format("Remove the %d IPv4-address(es) from the link, and keep the %d IPv6-address(es).", ipv4Interfaces.size(), ipv6Interfaces.size()), false);
            CommandLinksDialog.CommandLinksButtonType resolveLaterAction = new CommandLinksDialog.CommandLinksButtonType("Resolve manually", "Don't open the preferences window. I will resolve the problem myself.", true);
            CommandLinksDialog dialog = new CommandLinksDialog(new CommandLinksDialog.CommandLinksButtonType[]{keepIpv4Action, keepIpv6Action, resolveLaterAction});
            dialog.setTitle("Link configuration contains errors");
            dialog.setContentText(String.format("Link %s cannot be edited because it's current state is inconsistent. A link can only contain IPv4 OR IPv6 addresses", link.getClientId()));
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                if (result.get() == keepIpv4Action.getButtonType()) {
                    for (FXRspecInterface iface : ipv6Interfaces) {
                        iface.getIpAddresses().clear();
                    }
                    return true;
                }
                if (result.get() == keepIpv6Action.getButtonType()) {
                    for (FXRspecInterface iface : ipv4Interfaces) {
                        iface.getIpAddresses().clear();
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private String validateOutgoingLink() {
        block6: {
            block5: {
                if (!this.isValidLinkName(this.nameTextField.getText())) {
                    return "A link name may only contain alphanumerical characters, and is maximum " + this.getMaximumLinkNameLength() + " characters long.";
                }
                if (!this.ipv4RadioButton.isSelected()) break block5;
                for (RspecInterfaceWithIpAddress iface : this.addressesList) {
                    if (!InetAddressUtil.isValidInet4Address(iface.getIpAddress())) {
                        return String.format("'%s' is not a valid IPv4 address", iface.getIpAddress());
                    }
                    if (InetAddressUtil.isValidInet4Address(iface.getNetmask())) continue;
                    return String.format("'%s' is not a valid IPv4 netmask", iface.getNetmask());
                }
                break block6;
            }
            if (!this.ipv6RadioButton.isSelected()) break block6;
            for (RspecInterfaceWithIpAddress iface : this.addressesList) {
                if (!InetAddressUtil.isValidInet6Address(iface.getIpAddress())) {
                    return String.format("'%s' is not a valid IPv6 address", iface.getIpAddress());
                }
                if (InetAddressUtil.isValidInet6Netmask(iface.getNetmask())) continue;
                return String.format("'%s' is not a valid IPv6 netmask", iface.getNetmask());
            }
        }
        return null;
    }

    @FXML
    public void onSaveAction(ActionEvent actionEvent) {
        String validationError = this.validateOutgoingLink();
        if (validationError != null) {
            JFDialogs.create().owner((Node)this).message(validationError).title("Current link configuration is invalid").showError();
            return;
        }
        this.link.setClientId(this.nameTextField.getText());
        for (RspecInterfaceWithIpAddress ifaceWithIp : this.addressesList) {
            FXRspecInterface iface = this.link.getInterfaceForNode((RspecNode)ifaceWithIp.getRspecInterface().getNode());
            iface.getIpAddresses().clear();
            if (this.autoConfigRadioButton.isSelected()) continue;
            iface.getIpAddresses().add((Object)new RspecInterface.IpAddress(ifaceWithIp.getIpAddress(), ifaceWithIp.getNetmask(), this.ipv4RadioButton.isSelected() ? "ipv4" : "ipv6"));
        }
        String linkType = (String)this.linkTypeComboBox.getSelectionModel().getSelectedItem();
        if (linkType != null) {
            this.link.getLinkTypes().setAll((Object[])new String[]{linkType});
        } else {
            this.link.getLinkTypes().setAll((Object[])new String[]{"lan"});
        }
        if (this.sharedLanCheckBox.isSelected() && !this.sharedLanTextField.getText().trim().isEmpty()) {
            this.link.setSharedLan(this.sharedLanTextField.getText().trim());
        } else {
            this.link.setSharedLan(null);
        }
        if (this.createSharedLanCheckBox.isSelected() && !this.createSharedLanTextField.getText().trim().isEmpty()) {
            this.link.getAutoShareLanNames().setAll((Object[])new String[]{this.createSharedLanTextField.getText().trim()});
        } else {
            this.link.getAutoShareLanNames().clear();
        }
        this.link.setVlanTagging(this.vlanTaggingCheckBox.isSelected() ? Boolean.valueOf(true) : null);
        this.link.setNoMacLearning(this.noMacLearningCheckBox.isSelected() ? Boolean.valueOf(true) : null);
        this.link.setBestEffort(this.bestEffortCheckBox.isSelected() ? Boolean.valueOf(true) : null);
        this.link.setLinkMultiplexing(this.linkMultiplexingCheckBox.isSelected() ? Boolean.valueOf(true) : null);
        this.link.setInterswitchDisallow(this.disallowInterswitchCheckBox.isSelected() ? Boolean.valueOf(true) : null);
        Stage stage = (Stage)this.saveButton.getScene().getWindow();
        stage.close();
    }

    private int getMaximumLinkNameLength() {
        return 25;
    }

    private boolean isValidLinkName(String text) {
        if (text.length() > this.getMaximumLinkNameLength()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            boolean validChar;
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
            if (validChar) continue;
            return false;
        }
        return true;
    }

    @FXML
    public void onCancelAction(ActionEvent actionEvent) {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }

    private static final class RspecInterfaceWithIpAddress {
        private final FXRspecInterface rspecInterface;
        private final StringProperty ipAddress = new SimpleStringProperty();
        private final StringProperty netmask = new SimpleStringProperty();

        public RspecInterfaceWithIpAddress(FXRspecInterface rspecInterface) {
            this.rspecInterface = rspecInterface;
            if (!rspecInterface.getIpAddresses().isEmpty()) {
                RspecInterface.IpAddress ip = (RspecInterface.IpAddress)rspecInterface.getIpAddresses().get(0);
                this.ipAddress.setValue(ip.getAddress());
                this.netmask.setValue(ip.getNetmask());
            }
        }

        public FXRspecInterface getRspecInterface() {
            return this.rspecInterface;
        }

        public String getIpAddress() {
            return (String)this.ipAddress.get();
        }

        public StringProperty ipAddressProperty() {
            return this.ipAddress;
        }

        public String getNetmask() {
            return (String)this.netmask.get();
        }

        public StringProperty netmaskProperty() {
            return this.netmask;
        }

        public void setNetmask(String netmask) {
            this.netmask.set((Object)netmask);
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress.set((Object)ipAddress);
        }

        public void clear() {
            this.ipAddress.setValue("");
            this.netmask.setValue("");
        }
    }
}

