/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.TriggeredMessageHandler;
import be.iminds.ilabt.jfed.experimenter_gui.config.AdvertisementFetchManager;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.TestbedSiteInfo;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.BootScriptsTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.ComponentManagerPropertiesPane;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.ExoGeniConfigTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.InterfacePropertiesTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.PropertiesTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.RoutableIPTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.SelectDiskImageDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.XenTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map.MapDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.HealthStatusPane;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ResourceCell;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptivePropertiesDialog
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptivePropertiesDialog.class);
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final AdvertisementFetchManager advertisementFetchManager;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final ResourceClass resourceClass;
    @Nonnull
    private final FXRspecNode rspecNode;
    @Nonnull
    private final ModelRspecEditor modelRspecEditor;
    @Nonnull
    private final BrowserUtil browserUtil;
    @Nonnull
    private final List<AdaptivePropertiesTab> availableTabs;
    @FXML
    private HealthStatusPane healthStatusPane;
    @FXML
    private VBox propertiesBox;
    @FXML
    private Pane diskImageBox;
    @FXML
    private Button addDiskImageButton;
    @FXML
    private TextField nameTextField;
    @FXML
    private Button saveButton;
    @FXML
    private Button cancelButton;
    @FXML
    private ComboBox<Server> resourceComboBox;
    @FXML
    private HBox siteBox;
    @FXML
    private ComboBox<TestbedSiteInfo> siteComboBox;
    @FXML
    private CheckBox testbedFilterCheckbox;
    @FXML
    private Button testbedsMapButton;
    @FXML
    private Label testbedHealthInfoLabel;
    @FXML
    private TextField diskImageTextField;
    @FXML
    private ComboBox<String> flavorComboBox;
    @FXML
    private Pane flavorLine;
    @FXML
    private TabPane tabPane;
    @Nonnull
    private final Map<Server, Resource> serverToResourceMap;
    @Nonnull
    private final ObservableList<Server> servers;
    @Nonnull
    private final Map<Resource, ComponentManagerPropertiesPane> cmiPropertiesPanes = new HashMap<Resource, ComponentManagerPropertiesPane>();
    @Nonnull
    private final ObjectProperty<ComponentManagerPropertiesPane> currentCmip = new SimpleObjectProperty(null);
    @Nonnull
    private final BooleanProperty isSpecificNodeChosen = new SimpleBooleanProperty();
    @Nonnull
    private final ReadOnlyObjectProperty<Server> currentServer;
    @Nonnull
    private final ObservableObjectValue<Resource> currentResource;
    @Nonnull
    private final MapDialogFactory mapDialogFactory;
    @Nonnull
    private final TriggeredMessageHandler triggeredMessageHandler;
    @Nonnull
    private final Provider<SelectDiskImageDialog> selectDiskImageDialogProvider;
    @Nonnull
    private final ListProperty<String> currentFlavors = new SimpleListProperty();
    @Nonnull
    private final ExecutorService serverGlimpseFetchExecutor = Executors.newFixedThreadPool(1, ThreadFactoryUtil.getFactory((String)"ServerGlimpseFetch"));
    @Nonnull
    private final FedmonWebApiClient fedmonWebApiClient;

    AdaptivePropertiesDialog(@Nonnull ModelRspecEditor modelRspecEditor, @Nonnull FXRspecNode rspecNode, @Nonnull JFedGuiConfig config, @Nonnull AdvertisementFetchManager advertisementFetchManager, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authorityFinder, @Nonnull ResourceClass resourceClass, @Nonnull MapDialogFactory mapDialogFactory, @Nonnull FedmonWebApiClient fedmonWebApiClient, @Nonnull TriggeredMessageHandler triggeredMessageHandler, @Nonnull Provider<SelectDiskImageDialog> selectDiskImageDialogProvider, @Nonnull BrowserUtil browserUtil) {
        ResourceClass nodeResourceClass;
        this.config = config;
        this.advertisementFetchManager = advertisementFetchManager;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.resourceClass = resourceClass;
        this.mapDialogFactory = mapDialogFactory;
        this.fedmonWebApiClient = fedmonWebApiClient;
        this.triggeredMessageHandler = triggeredMessageHandler;
        this.selectDiskImageDialogProvider = selectDiskImageDialogProvider;
        this.browserUtil = browserUtil;
        assert (resourceClass != null);
        assert (modelRspecEditor != null);
        assert (rspecNode != null);
        this.modelRspecEditor = modelRspecEditor;
        this.rspecNode = rspecNode;
        FXMLUtil.injectFXML((Object)((Object)this));
        assert (this.nameTextField != null);
        assert (this.resourceComboBox != null);
        assert (this.siteComboBox != null);
        this.nameTextField.setTooltip(new Tooltip("Only alphanumerical, max. 10 characters"));
        this.nameTextField.setText(rspecNode.getClientId());
        this.healthStatusPane.setBrowserUtil(browserUtil);
        this.healthStatusPane.setConfig(config);
        this.healthStatusPane.setType(config.getResourceType(resourceClass));
        if (rspecNode.getResourceClassId() != null && (nodeResourceClass = config.getResourceClass(rspecNode.getResourceClassId())) != null) assert (Objects.equals(nodeResourceClass.getId(), resourceClass.getId()));
        rspecNode.setResourceClassId((String)resourceClass.getId());
        assert (resourceClass.getResources() != null);
        assert (this.resourceComboBox != null);
        assert (this.siteComboBox != null);
        this.servers = FXCollections.observableArrayList();
        this.resourceComboBox.setItems(this.servers);
        this.serverToResourceMap = resourceClass.getResources().stream().filter(AdaptivePropertiesDialog::saneResource).collect(Collectors.toMap(Resource::getServer, Function.identity()));
        assert (modelRspecEditor.toolBoxFilterProperty().get() != null);
        if (((ToolBoxFilter)modelRspecEditor.toolBoxFilterProperty().get()).isEmpty()) {
            this.testbedFilterCheckbox.setVisible(false);
            this.testbedFilterCheckbox.setText("No filter");
        } else {
            this.testbedFilterCheckbox.setText("Apply Filter: " + ((ToolBoxFilter)modelRspecEditor.toolBoxFilterProperty().get()).toString());
            this.testbedFilterCheckbox.setSelected(true);
            this.testbedFilterCheckbox.setVisible(true);
        }
        this.testbedFilterCheckbox.selectedProperty().addListener((observableValue, aBoolean, newIsSelected) -> {
            List newItems = newIsSelected != false ? this.serverToResourceMap.keySet().stream().sorted(Comparator.comparing(Server::getName).thenComparing(PrimaryIdObject::getId)).filter(((ToolBoxFilter)modelRspecEditor.toolBoxFilterProperty().get()).getServerFilter()).collect(Collectors.toList()) : this.serverToResourceMap.keySet().stream().sorted(Comparator.comparing(Server::getName).thenComparing(PrimaryIdObject::getId)).collect(Collectors.toList());
            Server origSelectedServer = (Server)this.resourceComboBox.getSelectionModel().selectedItemProperty().get();
            if (origSelectedServer != null && !newItems.contains(origSelectedServer)) {
                ArrayList tmp = new ArrayList();
                tmp.add(origSelectedServer);
                tmp.addAll(newItems);
                newItems = tmp;
            }
            ListCell origButtonCell = this.resourceComboBox.getButtonCell();
            TreeSet<Server> target = new TreeSet<Server>(Comparator.comparing(PrimaryIdObject::getId));
            target.addAll(newItems);
            TreeSet<Server> toRemove = new TreeSet<Server>(Comparator.comparing(PrimaryIdObject::getId));
            TreeSet<Server> toAdd = new TreeSet<Server>(Comparator.comparing(PrimaryIdObject::getId));
            toAdd.addAll(newItems);
            for (Server s : this.servers) {
                toAdd.remove(s);
                if (target.contains(s)) continue;
                toRemove.add(s);
            }
            Platform.runLater(() -> {
                this.servers.addAll((Collection)toAdd);
                this.servers.removeAll((Collection)toRemove);
                assert (this.resourceComboBox.getButtonCell() == origButtonCell);
                this.resourceComboBox.setButtonCell(origButtonCell);
                if (origSelectedServer != null) {
                    this.resourceComboBox.getSelectionModel().select((Object)origSelectedServer);
                } else {
                    this.resourceComboBox.getSelectionModel().selectFirst();
                }
            });
        });
        StringConverter<Server> serverStringConverter_withOverride = new StringConverter<Server>(){

            public String toString(Server server) {
                if (server == null) {
                    return null;
                }
                Resource matchingResource = AdaptivePropertiesDialog.this.serverToResourceMap.get(server);
                if (matchingResource != null && matchingResource.hasOverwriteServerName()) {
                    return matchingResource.getOverwriteServerName();
                }
                return StringConverters.SERVER_STRING_CONVERTER.toString((Object)server);
            }

            public Server fromString(String s) {
                throw new UnsupportedOperationException();
            }
        };
        this.serverToResourceMap.keySet().stream().sorted(Comparator.comparing(Server::getName).thenComparing(PrimaryIdObject::getId)).filter(((ToolBoxFilter)modelRspecEditor.toolBoxFilterProperty().get()).getServerFilter()).forEach(arg_0 -> this.servers.add(arg_0));
        this.resourceComboBox.setConverter((StringConverter)serverStringConverter_withOverride);
        this.resourceComboBox.setCellFactory(arg_0 -> AdaptivePropertiesDialog.lambda$new$2(resourceClass, config, (StringConverter)serverStringConverter_withOverride, arg_0));
        this.resourceComboBox.setButtonCell((ListCell)new ResourceCell(resourceClass, config, (StringConverter)serverStringConverter_withOverride){
            {
                this.nameLabel.setTextFill((Paint)Color.BLACK);
                this.container.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                this.debug = true;
            }
        });
        this.siteComboBox.setConverter(StringConverters.TESTBEDSITEINFO_STRING_CONVERTER);
        this.currentCmip.addListener((observable, oldValue, newValue) -> {
            this.isSpecificNodeChosen.unbind();
            if (newValue != null) {
                this.isSpecificNodeChosen.bind((ObservableValue)newValue.isSpecificNodeChosen());
            } else {
                this.isSpecificNodeChosen.setValue(Boolean.valueOf(false));
            }
        });
        this.currentServer = this.resourceComboBox.getSelectionModel().selectedItemProperty();
        this.currentServer.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                try {
                    Platform.runLater(() -> triggeredMessageHandler.onEvent(TriggeredMessage.GuiTrigger.SELECT_SERVER, Collections.singletonList(newValue)));
                }
                catch (Exception e) {
                    LOG.warn("Exception processing TriggeredMessage (will be ignored)", (Throwable)e);
                }
            }
        });
        this.currentResource = new ObjectBinding<Resource>(){
            {
                this.bind(new Observable[]{AdaptivePropertiesDialog.this.currentServer});
            }

            protected Resource computeValue() {
                if (AdaptivePropertiesDialog.this.currentServer.get() == null) {
                    return null;
                }
                return AdaptivePropertiesDialog.this.serverToResourceMap.get(AdaptivePropertiesDialog.this.currentServer.get());
            }
        };
        this.availableTabs = new ArrayList<AdaptivePropertiesTab>();
        BootScriptsTab bootScriptsTab = new BootScriptsTab(this);
        bootScriptsTab.load(rspecNode);
        this.availableTabs.add(bootScriptsTab);
        ExoGeniConfigTab exoGeniConfigTab = new ExoGeniConfigTab(this, browserUtil);
        exoGeniConfigTab.load(rspecNode);
        this.availableTabs.add(exoGeniConfigTab);
        RoutableIPTab routableIPTab = new RoutableIPTab(this);
        routableIPTab.load(rspecNode);
        this.availableTabs.add(routableIPTab);
        XenTab xenTab = new XenTab(this);
        xenTab.load(rspecNode);
        this.availableTabs.add(xenTab);
        for (FXRspecInterface iface : rspecNode.getInterfaces()) {
            this.tabPane.getTabs().add((Object)new InterfacePropertiesTab(modelRspecEditor, rspecNode, iface, (ReadOnlyStringProperty)this.nameTextField.textProperty()));
        }
        this.currentResource.addListener((observableValue, oldResource, newResource) -> {
            TestbedSiteInfo oldChosenSite = (TestbedSiteInfo)this.siteComboBox.getSelectionModel().getSelectedItem();
            TestbedSiteInfo newChosenSite = null;
            if (newResource != null && newResource.getServer().hasFlag(Server.Flag.featureSiteEnableChoice)) {
                ObservableList possibleSites = config.getTestbedSiteInfo(newResource.getServer());
                newChosenSite = rspecNode.getComponentManagerId() != null && rspecNode.getComponentManagerId().equalsIgnoringSubAuth((Object)newResource.getServer().getDefaultComponentManagerAsGeniUrn()) ? (TestbedSiteInfo)possibleSites.stream().filter(tsi -> tsi.getUrn().equals((Object)rspecNode.getComponentManagerId())).findAny().orElse(null) : (TestbedSiteInfo)possibleSites.stream().findFirst().orElse(null);
            }
            boolean availableNodesOnly = true;
            if (oldResource != null) {
                if (oldResource.getAllowDiskImage().booleanValue() && oldResource.getDiskImage() != null && Objects.equals(oldResource.getDiskImage(), this.diskImageTextField.getText())) {
                    this.diskImageTextField.setText("");
                }
                availableNodesOnly = this.cmiPropertiesPanes.get(oldResource).isAvailableNodesOnly();
                this.currentFlavors.unbind();
                this.currentFlavors.set((Object)FXCollections.emptyObservableList());
                LOG.debug("Flavor list unbound.");
            }
            if (newResource != null) {
                assert (newResource.getServer() != null);
                if (!this.cmiPropertiesPanes.containsKey(newResource)) {
                    Runnable fetchServerGlimpse = () -> {
                        block10: {
                            try {
                                LOG.debug("Fetching ServerGlimpse in background");
                                try {
                                    assert (newResource.getServer() != null);
                                    assert (newResource.getServer().getId() != null);
                                    Optional serverGlimpse = fedmonWebApiClient.getServerGlimpseByServerId((Integer)newResource.getServer().getId());
                                    if (serverGlimpse.isPresent()) {
                                        LOG.debug("Got ServerGlimpse in background");
                                        if (serverGlimpse.get() != null) {
                                            Platform.runLater(() -> config.setServerGlimpse((Integer)newResource.getServer().getId(), (ServerGlimpse)serverGlimpse.get()));
                                        } else {
                                            assert (serverGlimpse.get() != null);
                                            LOG.error("ServerGlimpse never be null for server " + String.valueOf(newResource.getServer().getId()));
                                        }
                                        break block10;
                                    }
                                    LOG.debug("Did NOT get ServerGlimpse in background");
                                }
                                catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                                    LOG.error("Error fetching ServerGlimpse for server " + String.valueOf(newResource.getServer().getId()), (Throwable)e);
                                }
                            }
                            catch (Throwable t) {
                                LOG.error("Unexpected Exception fetching ServerGlimpse", t);
                                throw t;
                            }
                        }
                    };
                    this.serverGlimpseFetchExecutor.submit(fetchServerGlimpse);
                    this.advertisementFetchManager.callFedmonIfNeeded(newResource.getServer());
                    this.cmiPropertiesPanes.put((Resource)this.currentResource.get(), new ComponentManagerPropertiesPane((Resource)newResource, this.rspecNode, (ObservableValue<TestbedSiteInfo>)this.siteComboBox.valueProperty(), availableNodesOnly, this.config, this.advertisementFetchManager, mapDialogFactory, browserUtil));
                }
                ComponentManagerPropertiesPane cmiPropertiesPane = this.cmiPropertiesPanes.get(newResource);
                assert (cmiPropertiesPane != null);
                this.propertiesBox.getChildren().add((Object)cmiPropertiesPane);
                this.currentCmip.set((Object)cmiPropertiesPane);
                if (newResource.getAllowDiskImage().booleanValue() && newResource.getDiskImage() != null && this.diskImageTextField.getText().isEmpty()) {
                    this.diskImageTextField.setText(newResource.getDiskImage());
                }
                if (!newResource.getAllowDiskImage().booleanValue()) {
                    this.diskImageBox.setVisible(false);
                } else {
                    this.diskImageBox.setVisible(true);
                }
                this.healthStatusPane.setServer(newResource.getServer());
                if (newResource.getServer().hasFlag(Server.Flag.featureSiteEnableChoice) && newResource.isSiteSelectionAllowed()) {
                    LOG.debug("site selection: YES: flag_featureSiteEnableChoice_present={} newResource.isSiteSelectionAllowed()={}", (Object)newResource.getServer().hasFlag(Server.Flag.featureSiteEnableChoice), (Object)newResource.isSiteSelectionAllowed());
                    ObservableList testbedSiteInfos = config.getTestbedSiteInfo(newResource.getServer());
                    this.siteComboBox.setItems(testbedSiteInfos);
                    if (newChosenSite == null) {
                        this.siteComboBox.getSelectionModel().clearSelection();
                    } else {
                        this.siteComboBox.getSelectionModel().select((Object)newChosenSite);
                    }
                } else {
                    LOG.debug("site selection: NO: flag_featureSiteEnableChoice_present={} newResource.isSiteSelectionAllowed()={}", (Object)newResource.getServer().hasFlag(Server.Flag.featureSiteEnableChoice), (Object)newResource.isSiteSelectionAllowed());
                    this.siteBox.setVisible(false);
                    this.siteComboBox.setItems(FXCollections.emptyObservableList());
                }
                this.currentFlavors.bind((ObservableValue)config.getFlavors(newResource));
                LOG.debug("New flavor list bound for resource {} server {}. now {} flavors", new Object[]{newResource.getId(), newResource.getServerId(), this.currentFlavors.size()});
                if (newResource.getSliverType() != null && newResource.getServer() != null) {
                    List advertisedSliverTypeNames = config.getAdvertisedSliverTypeNames(newResource.getServer());
                    if (!advertisedSliverTypeNames.contains(newResource.getSliverType())) {
                        LOG.warn("The newly selected Resource specifies sliver type \"{}\", but that is not one of the known types at server {}: {}", new Object[]{newResource.getSliverType(), newResource.getServerId(), advertisedSliverTypeNames});
                    } else {
                        LOG.debug("The newly selected Resource specifies sliver type \"{}\", which is one of the known types at server {}: {}", new Object[]{newResource.getSliverType(), newResource.getServerId(), advertisedSliverTypeNames});
                    }
                } else {
                    LOG.debug("The Resource specifies sliver type {} and server {}", (Object)newResource.getSliverType(), (Object)newResource.getServerId());
                }
            } else {
                LOG.debug("site selection: no newResource");
                this.currentCmip.set(null);
                this.siteBox.setVisible(false);
                this.siteComboBox.setItems(FXCollections.emptyObservableList());
                this.currentFlavors.unbind();
                this.currentFlavors.set((Object)FXCollections.emptyObservableList());
                LOG.debug("Flavor list unbound.");
            }
            if (oldResource != null) {
                this.propertiesBox.getChildren().remove((Object)this.cmiPropertiesPanes.get(oldResource));
            }
            if (newResource != null) {
                Server server = newResource.getServer();
                boolean showDiskImageDialog = server.hasFlag(Server.Flag.featureListDiskImages);
                this.addDiskImageButton.setVisible(showDiskImageDialog);
            }
            this.determineTabsVisibility(rspecNode);
        });
        Resource resource = config.findBestResource(resourceClass, (RspecNode)rspecNode);
        if (resource == null) {
            this.resourceComboBox.getSelectionModel().clearSelection();
        } else {
            this.resourceComboBox.getSelectionModel().select((Object)resource.getServer());
        }
        if (!rspecNode.getSliverTypes().isEmpty()) {
            List flavors;
            List diskImages = ((SliverType)rspecNode.getSliverTypes().get(0)).getDiskImages();
            if (!diskImages.isEmpty()) {
                this.diskImageTextField.setText(((DiskImage)diskImages.get(0)).getName() != null ? ((DiskImage)diskImages.get(0)).getName() : ((DiskImage)diskImages.get(0)).getUrl());
            }
            if (!(flavors = ((SliverType)rspecNode.getSliverTypes().get(0)).getFlavors()).isEmpty()) {
                this.flavorComboBox.setValue((Object)((String)flavors.get(0)));
            } else {
                this.flavorComboBox.setValue(null);
            }
        }
        this.diskImageBox.managedProperty().bind((ObservableValue)this.diskImageBox.visibleProperty());
        this.addDiskImageButton.managedProperty().bind((ObservableValue)this.addDiskImageButton.visibleProperty());
        String arch = System.getProperty("os.arch");
        if (Objects.equals(arch, "x86")) {
            this.testbedsMapButton.setVisible(false);
        }
        Platform.runLater(() -> this.determineTabsVisibility(rspecNode));
        this.flavorComboBox.setItems(this.currentFlavors);
        this.flavorLine.visibleProperty().bind((ObservableValue)this.currentFlavors.emptyProperty().not().or((ObservableBooleanValue)this.flavorComboBox.valueProperty().isNotNull()));
    }

    private boolean hasFlavors() {
        return !this.currentFlavors.isEmpty();
    }

    @FXML
    private void showTestbedsMap() {
        Resource selectedResource = this.mapDialogFactory.showTestbedMapDialog(this.getScene().getWindow(), this.config, this.resourceClass);
        if (selectedResource != null) {
            this.resourceComboBox.getSelectionModel().select((Object)selectedResource.getServer());
        }
    }

    private void determineTabsVisibility(@Nonnull FXRspecNode rspecNode) {
        int insertPosition = 1;
        assert (this.availableTabs != null);
        for (AdaptivePropertiesTab apt : this.availableTabs) {
            assert (apt != null);
            if (apt.shouldBeVisible(rspecNode)) {
                LOG.debug("Tab {} should be made visible.", (Object)((Object)((Object)apt)).getClass().getSimpleName());
                if (this.tabPane.getTabs().contains((Object)apt)) {
                    ++insertPosition;
                    continue;
                }
                this.tabPane.getTabs().add(insertPosition, (Object)apt);
                continue;
            }
            LOG.debug("Tab {} should be made invisible.", (Object)((Object)((Object)apt)).getClass().getSimpleName());
            if (!this.tabPane.getTabs().contains((Object)apt)) continue;
            this.tabPane.getTabs().remove((Object)apt);
        }
    }

    @FXML
    public void onSaveAction(ActionEvent actionEvent) {
        SliverType resourceSliverType;
        String validation;
        ComponentManagerPropertiesPane componentManagerPropertiesPane;
        this.nameTextField.setText(this.nameTextField.getText().trim());
        if (!ModelRspecEditor.isValidNodeName(this.nameTextField.getText())) {
            JFDialogs.create().owner((Node)this).message("A node name may only contain alphanumerical characters, and is maximum 10 characters long.").masthead("The entered node name is invalid.").showError();
            return;
        }
        if (this.currentResource.get() == null) {
            JFDialogs.create().owner((Node)this).message("You must select an authority for this node.").masthead("No authority selected").title("No authority selected").showError();
            return;
        }
        if (!this.diskImageTextField.getText().isEmpty()) {
            this.diskImageTextField.setText(this.diskImageTextField.getText().trim().replace(" ", ""));
            String diskImageValue = this.diskImageTextField.getText();
            if (diskImageValue.startsWith("urn")) {
                GeniUrn diskImageUrn = GeniUrn.parse((String)diskImageValue);
                if (diskImageUrn == null || !Objects.equals("image", diskImageUrn.getEncodedResourceType())) {
                    JFDialogs.create().owner((Node)this).message("The provided disk image URN is invalid. Please correct the entered value.").masthead("Invalid disk image URN").showError();
                    LOG.warn("User entered invalid disk image URN '{}'", (Object)diskImageValue);
                    return;
                }
            } else {
                try {
                    new URL(diskImageValue);
                }
                catch (MalformedURLException e) {
                    JFDialogs.create().owner((Node)this).message("The provided disk image URL is invalid. Please correct the entered value.").masthead("Invalid disk image URL").showError();
                    LOG.warn("User entered invalid disk image URL '{}'", (Object)diskImageValue);
                    return;
                }
            }
        }
        if (!(componentManagerPropertiesPane = this.cmiPropertiesPanes.get(this.currentResource.get())).validate()) {
            return;
        }
        for (Tab visibleTab : this.tabPane.getTabs().stream().filter(AdaptivePropertiesTab.class::isInstance).map(AdaptivePropertiesTab.class::cast).collect(Collectors.toList())) {
            validation = visibleTab.validateConfiguration();
            if (validation == null) continue;
            JFDialogs.create().owner((Node)this).message(validation).masthead("Node configuration could not be saved").showError();
            return;
        }
        for (Tab visibleTab : this.tabPane.getTabs().stream().filter(PropertiesTab.class::isInstance).map(PropertiesTab.class::cast).collect(Collectors.toList())) {
            validation = visibleTab.validateConfiguration();
            if (validation == null) continue;
            JFDialogs.create().owner((Node)this).message(validation).masthead("Node configuration could not be saved").showError();
            return;
        }
        FXRspecNode currentNode = this.rspecNode;
        if (!Objects.equals(this.nameTextField.getText(), currentNode.getClientId())) {
            try {
                this.modelRspecEditor.updateNodeClientId(currentNode, this.nameTextField.getText());
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                JFDialogs.create().owner((Node)this).message("A node with name \"" + this.nameTextField.getText() + "\" already exists. Duplicate node names are not allowed.").masthead("Duplicate node name.").showError();
                return;
            }
        }
        Server server = (Server)this.currentServer.get();
        assert (server != null);
        Resource resource = (Resource)this.currentResource.get();
        assert (resource != null);
        GeniUrn newComponentManagerId = server.getDefaultComponentManagerAsGeniUrn();
        if (server.hasFlag(Server.Flag.featureSiteEnableChoice)) {
            if (this.siteComboBox.getSelectionModel().getSelectedItem() != null) {
                newComponentManagerId = ((TestbedSiteInfo)this.siteComboBox.getSelectionModel().getSelectedItem()).getUrn();
                LOG.debug("save site selected: " + String.valueOf(newComponentManagerId));
            } else {
                LOG.debug("save site selected: no site selected  sites_size=" + this.siteComboBox.getItems().size() + " selected=" + String.valueOf(this.siteComboBox.getSelectionModel().getSelectedItem()));
            }
        }
        boolean componentManagerToplevelChanged = newComponentManagerId == currentNode.getComponentManagerId() || newComponentManagerId != null && newComponentManagerId.equalsIgnoringSubAuth((Object)currentNode.getComponentManagerId());
        boolean componentManagerOrSiteChanged = !Objects.equals(newComponentManagerId, currentNode.getComponentManagerId());
        currentNode.setComponentManagerId(newComponentManagerId);
        if (!(resource.getSliverType() == null || currentNode.getSliverTypeName() != null && Objects.equals(resource.getSliverType(), currentNode.getSliverTypeName()) || (resourceSliverType = new SliverTypeBuilder(resource.getSliverType()).build()) == null)) {
            currentNode.setSliverTypeName(resourceSliverType.getName());
        }
        currentNode.setComponentId(componentManagerPropertiesPane.getSelectedComponentId() != null ? componentManagerPropertiesPane.getSelectedComponentId() : null);
        if (componentManagerPropertiesPane.getSelectedHardwareType() != null) {
            currentNode.getHardwareTypes().setAll((Object[])new HardwareType[]{componentManagerPropertiesPane.getSelectedHardwareType()});
        }
        if (componentManagerToplevelChanged) {
            boolean supportsStitching = server.hasFlag(Server.Flag.featureStitching);
            ArrayList<FXRspecLink> toRemove = new ArrayList<FXRspecLink>();
            if (!resource.getAllowLinksOrDefault() && !resource.getAllowStitchedLinksOrDefault() && this.rspecNode.getInterfaces().size() > 0) {
                JFDialogs.create().owner((Node)this).message(String.format("'%s' does not support dedicated links. Existing links to '%s' are being removed.", server.getName(), this.rspecNode.getClientId())).masthead("Illegal links detected").title("Illegal links detected").showWarning();
                toRemove.addAll(Lists.transform((List)this.rspecNode.getInterfaces(), rspecInterface -> rspecInterface.isLinkBound() ? rspecInterface.getLink() : null));
            } else {
                for (FXRspecInterface iface : currentNode.getInterfaces()) {
                    if (!iface.isLinkBound()) continue;
                    if (iface.getLink().isStitched(this.testbedInfoSource)) {
                        if (!this.isValidStitchedLink(iface.getLink())) {
                            Alert alert = new Alert(Alert.AlertType.WARNING, String.format("By changing the authority of this node, the link '%s' has become a stitched link.\nHowever, one or more authorities do not support stitched links. It is therefore removed.", iface.getLink().getClientId()), new ButtonType[]{ButtonType.OK});
                            alert.setHeaderText("Invalid stitched link");
                            alert.setTitle("Invalid stitched link");
                            alert.show();
                            toRemove.add(iface.getLink());
                            continue;
                        }
                        if (JFDialogs.create().owner((Node)this).message("Link '" + iface.getLink().getClientId() + "' is now a stitched link.\n\nStitched links between testbeds are currently VERY experimental and not supported. Do you want to remove this link?").masthead("Experimental functionality detected.").title("Experimental functionality detected.").buttonTypes(new ButtonType[]{ButtonType.YES, ButtonType.NO}).showWarning().filter(r -> r == ButtonType.YES).isPresent()) {
                            toRemove.add(iface.getLink());
                            continue;
                        }
                        this.modelRspecEditor.convertLinkToStitchedLink(iface.getLink());
                        continue;
                    }
                    JFDialogs.create().owner((Node)this).message("Link '" + iface.getLink().getClientId() + "' is now a normal link. Some settings are reverted to default.").masthead("Link type change detected").title("Link type change detected").showInformation();
                    this.modelRspecEditor.convertLinkToNormalLink(iface.getLink());
                }
            }
            toRemove.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FXModelRspec)this.modelRspecEditor.getModelRspec()).deleteLink(arg_0));
        }
        if (!currentNode.getSliverTypes().isEmpty()) {
            SliverType sliverType = (SliverType)currentNode.getSliverTypes().get(0);
            if (sliverType != null) {
                assert (this.diskImageTextField != null);
                if (this.diskImageTextField.getText() != null) {
                    String diskImageString = this.diskImageTextField.getText().trim();
                    if (!diskImageString.isEmpty()) {
                        if (sliverType.getDiskImages().size() != 1 || !((DiskImage)sliverType.getDiskImages().get(0)).getName().equals(diskImageString)) {
                            currentNode.setSliverTypeDiskImage(diskImageString);
                        }
                    } else {
                        currentNode.setSliverTypeDiskImage(null);
                    }
                } else {
                    currentNode.setSliverTypeDiskImage(null);
                }
                if (this.hasFlavors() && this.flavorComboBox.getValue() != null && !((String)this.flavorComboBox.getValue()).isEmpty()) {
                    currentNode.setSliverTypeFlavor((String)this.flavorComboBox.getValue());
                } else {
                    currentNode.setSliverTypeFlavor(null);
                }
            }
        } else {
            LOG.error("Could not find sliver-type on currentNode: cannot save disk image");
        }
        Boolean exclusive = this.config.getNodeExclusivity(currentNode.getComponentManagerId(), currentNode.getSliverTypeName());
        if (exclusive != null) {
            currentNode.setExclusive(exclusive);
        }
        FXRspecNode resultNode = currentNode;
        this.tabPane.getTabs().stream().filter(tab -> tab instanceof AdaptivePropertiesTab).map(tab -> (AdaptivePropertiesTab)((Object)tab)).forEach(tab -> {
            assert (tab.shouldBeVisible(resultNode)) : ((Object)tab).getClass().getName() + "indicates it shouldn't be visible at this time!";
            tab.save(resultNode);
        });
        this.tabPane.getTabs().stream().filter(tab -> tab instanceof PropertiesTab).map(tab -> (PropertiesTab)((Object)tab)).forEach(PropertiesTab::save);
        ResourceClass resourceClass = this.config.findBestResourceClass((RspecNode)currentNode);
        if (resourceClass != null) {
            currentNode.setResourceClassId((String)resourceClass.getId());
        }
        Stage stage = (Stage)this.saveButton.getScene().getWindow();
        stage.close();
    }

    String getCurrentSliverTypeName() {
        Resource resource = (Resource)this.currentResource.get();
        if (resource == null) {
            return null;
        }
        if (this.rspecNode.getSliverTypeName() != null && resource.getSliverType() != null && Objects.equals(resource.getSliverType(), this.rspecNode.getSliverTypeName())) {
            return this.rspecNode.getSliverTypeName();
        }
        String fallbackSliverType = resource.getSliverType();
        if (fallbackSliverType != null) {
            return fallbackSliverType;
        }
        return null;
    }

    private boolean isValidStitchedLink(@Nonnull FXRspecLink link) {
        for (FXRspecInterface iface : link.getInterfaces()) {
            Server nodeAuth;
            if (!iface.isNodeBound() || (nodeAuth = this.authorityFinder.findByUrn(iface.getNode().getComponentManagerId(), AuthorityFinder.Purpose.STITCHING)).hasFlag(Server.Flag.featureStitching)) continue;
            return false;
        }
        return true;
    }

    @FXML
    public void onCancelAction(ActionEvent actionEvent) {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void onRequestDiskImageAction() {
        Resource curRes = (Resource)this.currentResource.get();
        if (curRes != null) {
            SelectDiskImageDialog dialog = (SelectDiskImageDialog)((Object)this.selectDiskImageDialogProvider.get());
            dialog.setResource(curRes);
            dialog.showAndWait().ifPresent(arg_0 -> ((TextField)this.diskImageTextField).setText(arg_0));
        }
    }

    @Nullable
    public Resource getSelectedResource() {
        assert (this.currentResource != null);
        return (Resource)this.currentResource.get();
    }

    @Nullable
    public Server getSelectedServer() {
        assert (this.currentServer != null);
        return (Server)this.currentServer.get();
    }

    @Nonnull
    public FXRspecNode getRspecNode() {
        return this.rspecNode;
    }

    @Nonnull
    public ObservableObjectValue<Resource> selectedResourceProperty() {
        return this.currentResource;
    }

    public ReadOnlyBooleanProperty isSpecificNodeChosenProperty() {
        return this.isSpecificNodeChosen;
    }

    @Nonnull
    public JFedGuiConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public AdvertisementFetchManager getAdvertisementFetchManager() {
        return this.advertisementFetchManager;
    }

    @Nonnull
    public ResourceClass getResourceClass() {
        return this.resourceClass;
    }

    @Nonnull
    public String getResourceClassId() {
        return this.resourceClass == null ? null : (String)this.resourceClass.getId();
    }

    public static boolean saneResource(@Nonnull Resource resource) {
        if (resource == null) {
            LOG.warn("Resource == null in resourceClass.getResources()");
            return false;
        }
        if (resource.getServer() == null) {
            LOG.warn("Resource.getServer() == null in resourceClass.getResources() for resource=" + String.valueOf(resource.getId()));
            return false;
        }
        if (resource.getServer().getId() == null) {
            LOG.warn("Resource.getServer().getId() == null in resourceClass.getResources() for resource=" + String.valueOf(resource.getId()));
            return false;
        }
        if (resource.getServer().getName() == null) {
            LOG.warn("Resource.getServer().getName() == null in resourceClass.getResources() for resource=" + String.valueOf(resource.getId()) + " server=" + String.valueOf(resource.getServer().getId()));
            return false;
        }
        if (resource.getServer().getTestbed() != null && resource.getServer().getTestbed().getCategoryNames().contains("offline")) {
            LOG.warn("Resource.getServer() is part of offline testbed \"" + (String)resource.getServer().getTestbed().getId() + "\"  for resource=" + String.valueOf(resource.getId()) + " server=" + String.valueOf(resource.getServer().getId()));
            return false;
        }
        return true;
    }

    private static /* synthetic */ ListCell lambda$new$2(ResourceClass resourceClass, JFedGuiConfig config, StringConverter serverStringConverter_withOverride, ListView param) {
        return new ResourceCell(resourceClass, config, (StringConverter<Server>)serverStringConverter_withOverride);
    }
}

