/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.TriggeredMessageHandler;
import be.iminds.ilabt.jfed.experimenter_gui.config.AdvertisementFetchManager;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.SelectDiskImageDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map.MapDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.FXUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import java.util.List;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdaptivePropertiesDialogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptivePropertiesDialogFactory.class);
    private final JFedGuiConfig config;
    private final TestbedInfoSource testbedInfoSource;
    private final AdvertisementFetchManager advertisementFetchManager;
    private final AuthorityFinder authorityFinder;
    private final MapDialogFactory mapDialogFactory;
    private final FedmonWebApiClient fedmonWebApiClient;
    private final TriggeredMessageHandler triggeredMessageHandler;
    private final Provider<SelectDiskImageDialog> selectDiskImageDialogProvider;
    private final BrowserUtil browserUtil;

    @Inject
    public AdaptivePropertiesDialogFactory(JFedGuiConfig config, TestbedInfoSource testbedInfoSource, AdvertisementFetchManager advertisementFetchManager, AuthorityFinder authorityFinder, MapDialogFactory mapDialogFactory, FedmonWebApiClient fedmonWebApiClient, TriggeredMessageHandler triggeredMessageHandler, Provider<SelectDiskImageDialog> selectDiskImageDialogProvider, BrowserUtil browserUtil) {
        this.config = config;
        this.testbedInfoSource = testbedInfoSource;
        this.advertisementFetchManager = advertisementFetchManager;
        this.authorityFinder = authorityFinder;
        this.mapDialogFactory = mapDialogFactory;
        this.fedmonWebApiClient = fedmonWebApiClient;
        this.triggeredMessageHandler = triggeredMessageHandler;
        this.selectDiskImageDialogProvider = selectDiskImageDialogProvider;
        this.browserUtil = browserUtil;
    }

    public AdaptivePropertiesDialog createAdaptivePropertiesDialog(@Nonnull ModelRspecEditor modelRspecEditor, @Nonnull FXRspecNode node) {
        assert (node != null);
        ResourceClass resourceClass = node.getResourceClassId() == null ? null : this.config.getResourceClass(node.getResourceClassId());
        List matchingResourceClasses = this.config.findAllPossibleResourceClasses((RspecNode)node);
        if (resourceClass != null && !matchingResourceClasses.contains(resourceClass)) {
            ResourceClass newResourceClass = this.config.findBestResourceClass((RspecNode)node);
            LOG.debug("ResourceClass know for node {} is \"{}\". But that class does not match the node -> changing it to: {}", new Object[]{node.getClientId(), resourceClass.getId(), newResourceClass == null ? null : newResourceClass.getId()});
            if (newResourceClass != null) {
                resourceClass = newResourceClass;
            } else {
                LOG.warn("config.findBestResourceClass(node) returned null");
            }
        }
        if (resourceClass == null) {
            resourceClass = this.config.findBestResourceClass((RspecNode)node);
            if (resourceClass == null) {
                resourceClass = this.config.getDefaultResourceClass();
            }
            assert (resourceClass != null);
            LOG.debug("No resourceClass know for node " + node.getClientId() + ". Falling back to: " + (resourceClass == null ? "null" : (String)resourceClass.getId()));
        }
        assert (resourceClass != null);
        return new AdaptivePropertiesDialog(modelRspecEditor, node, this.config, this.advertisementFetchManager, this.testbedInfoSource, this.authorityFinder, resourceClass, this.mapDialogFactory, this.fedmonWebApiClient, this.triggeredMessageHandler, this.selectDiskImageDialogProvider, this.browserUtil);
    }

    public void showAdaptivePropertiesDialog(@Nullable Window parent, @Nonnull ModelRspecEditor modelRspecEditor, @Nonnull FXRspecNode node) {
        this.config.refreshServerGlimpsesIfNeeded();
        AdaptivePropertiesDialog adaptivePropertiesDialog = this.createAdaptivePropertiesDialog(modelRspecEditor, node);
        Scene scene = new Scene((Parent)adaptivePropertiesDialog);
        Stage dialogStage = new Stage();
        StageUtils.setJFedStageIcons((Stage)dialogStage);
        dialogStage.setScene(scene);
        Object debug = "";
        int addDebug = 0;
        assert (addDebug++ == 0);
        if (addDebug > 0) {
            debug = " (" + adaptivePropertiesDialog.getResourceClassId() + ")";
        }
        dialogStage.setTitle("Properties of " + node.getClientId() + (String)debug);
        dialogStage.setMinHeight(725.0);
        dialogStage.setMaxHeight(800.0);
        dialogStage.setMinWidth(500.0);
        if (parent != null) {
            FXUtils.centerToOwner(parent, (Window)dialogStage);
        }
        dialogStage.showAndWait();
    }
}

