/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesTab;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.InstallService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXExecuteService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXInstallService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.ImageButton;
import be.iminds.ilabt.jfed.ui.javafx.util.BetterTextFieldTableCell;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootScriptsTab
extends AdaptivePropertiesTab<FXRspecNode> {
    private static final Logger LOG = LoggerFactory.getLogger(BootScriptsTab.class);
    private final AdaptivePropertiesDialog adaptivePropertiesDialog;
    @FXML
    private TableView<FXInstallService> downloadTableView;
    @FXML
    private TableColumn<FXInstallService, String> urlTableColumn;
    @FXML
    private TableColumn<FXInstallService, String> pathTableColumn;
    @FXML
    private TableColumn<FXInstallService, Boolean> downloadActionsTableColumn;
    @FXML
    private TableView<FXExecuteService> commandsTableView;
    @FXML
    private TableColumn<FXExecuteService, String> commandTableColumn;
    @FXML
    private TableColumn<FXExecuteService, Boolean> commandActionsTableColumn;

    public BootScriptsTab(AdaptivePropertiesDialog adaptivePropertiesDialog) {
        super("Boot scripts");
        this.adaptivePropertiesDialog = adaptivePropertiesDialog;
        this.setContent((Node)FXMLUtil.createFromFXML((Object)((Object)this)));
        DoubleBinding widthLeftBinding = this.downloadTableView.widthProperty().subtract((ObservableNumberValue)this.downloadActionsTableColumn.widthProperty()).subtract(2);
        this.urlTableColumn.prefWidthProperty().bind((ObservableValue)widthLeftBinding.multiply(0.66));
        this.pathTableColumn.prefWidthProperty().bind((ObservableValue)widthLeftBinding.multiply(0.34));
        this.commandTableColumn.prefWidthProperty().bind((ObservableValue)this.commandsTableView.widthProperty().subtract((ObservableNumberValue)this.commandActionsTableColumn.widthProperty()).subtract(2));
        this.urlTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("url"));
        this.urlTableColumn.setCellFactory(BetterTextFieldTableCell.forTableColumn());
        this.pathTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("installPath"));
        this.pathTableColumn.setCellFactory(BetterTextFieldTableCell.forTableColumn());
        this.downloadActionsTableColumn.setCellValueFactory(p -> new SimpleObjectProperty((Object)(p.getValue() != null ? 1 : 0)));
        this.downloadActionsTableColumn.setCellFactory(ActionsTableCell.forTableColumn());
        this.commandTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("command"));
        this.commandTableColumn.setCellFactory(BetterTextFieldTableCell.forTableColumn());
        this.commandActionsTableColumn.setCellValueFactory(p -> new SimpleObjectProperty((Object)(p.getValue() != null ? 1 : 0)));
        this.commandActionsTableColumn.setCellFactory(ActionsTableCell.forTableColumn());
    }

    private static void installShowTooltipOnClick(Node node, Tooltip tooltip) {
        node.setOnMouseClicked(event -> tooltip.show(node.getScene().getWindow(), event.getScreenX(), event.getScreenY()));
    }

    @Override
    public void load(FXRspecNode rspecNode) {
        this.downloadTableView.getItems().addAll((Collection)rspecNode.getInstallServices());
        this.commandsTableView.getItems().addAll((Collection)rspecNode.getExecuteServices());
    }

    @Override
    public void save(FXRspecNode rspecNode) {
        rspecNode.setInstallServices((List)this.downloadTableView.getItems());
        rspecNode.setExecuteServices((List)this.commandsTableView.getItems());
    }

    @Override
    public void onTabShown() {
    }

    @Override
    public boolean shouldBeVisible(FXRspecNode rspecNode) {
        if (this.adaptivePropertiesDialog.getSelectedResource() == null) {
            return false;
        }
        Server authority = this.adaptivePropertiesDialog.getSelectedResource().getServer();
        if (authority == null) {
            return false;
        }
        return authority.isServerType("instageni") || authority.isServerType("emulab") || authority.isServerType("orca") || authority.hasFlag(Server.Flag.featureExecuteAndInstallService);
    }

    @Override
    public String validateConfiguration() {
        for (InstallService installService : this.downloadTableView.getItems()) {
            if (installService.getUrl().isEmpty()) {
                return "Please define an URL for each download";
            }
            if (installService.getInstallPath().isEmpty()) {
                return "Please define a path where each download should be extracted";
            }
            try {
                new URL(installService.getUrl());
            }
            catch (MalformedURLException ex) {
                return "'" + installService.getUrl() + "' is not a valid URL";
            }
        }
        for (ExecuteService executeService : this.commandsTableView.getItems()) {
            if (!executeService.getCommand().isEmpty()) continue;
            return "Please define a command, or remove the empty row.";
        }
        return null;
    }

    @FXML
    private void onAddDownloadAction() {
        FXInstallService newInstallService = new FXInstallService("/", "");
        this.downloadTableView.getItems().add((Object)newInstallService);
    }

    @FXML
    private void onAddCommandAction() {
        FXExecuteService newExecuteService = new FXExecuteService("sh", "");
        this.commandsTableView.getItems().add((Object)newExecuteService);
    }

    private static class ActionsTableCell<S, T>
    extends TableCell<S, T> {
        private final HBox buttonsBox = new HBox();
        private final ImageButton removeButton = new ImageButton((Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES_CIRCLE, (Color)Color.RED));

        private ActionsTableCell() {
            this.removeButton.setOnAction(actionEvent -> this.removeRow());
            this.buttonsBox.getChildren().add((Object)this.removeButton);
            this.setGraphic((Node)this.buttonsBox);
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            this.removeButton.setVisible(!empty);
        }

        private void removeRow() {
            this.getTableView().getItems().remove(this.getTableRow().getItem());
        }

        public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn() {
            return ssTableColumn -> new ActionsTableCell();
        }
    }
}

