/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.config.AdvertisementFetchManager;
import be.iminds.ilabt.jfed.experimenter_gui.config.ImageMap;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.TestbedSiteInfo;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.HardwareTypeListCell;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map.MapDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ComponentInfoCell;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.lowlevel.lib.JFedConnectivityException;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentManagerPropertiesPane
extends StackPane {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentManagerPropertiesPane.class);
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final AdvertisementFetchManager advertisementFetchManager;
    @Nonnull
    private final MapDialogFactory mapDialogFactory;
    @Nonnull
    private final Resource resource;
    @Nonnull
    private final ObservableValue<TestbedSiteInfo> chosenSite;
    @Nonnull
    private final BrowserUtil browserUtil;
    @FXML
    private ComboBox<JFedGuiConfig.ComponentInfo> componentIdComboBox;
    @FXML
    private ComboBox<JFedGuiConfig.HardwareTypeInfo> hardwareTypesComboBox;
    @FXML
    private ToggleGroup selectComponentIdToggleGroup;
    @FXML
    private Label chooseNodeLabel;
    @FXML
    private Button refreshAdvertisementButton;
    @FXML
    private RadioButton componentIdNodeRadioButton;
    @FXML
    private RadioButton anyNodeRadioButton;
    @FXML
    private RadioButton hardwareTypeNodeRadioButton;
    @FXML
    private ProgressBar advertisementFetchProgressBar;
    @FXML
    private VBox advertisementFetchOverlay;
    @FXML
    private Button nodesVizButton;
    @FXML
    private Label hardwareTypeInfoLabel;
    @FXML
    private Hyperlink hardwareTypeInfoButton;
    @FXML
    private RowConstraints hardwareInfoRowConstraints;
    @FXML
    private Label hardwareTypeAvailableCountLabel;
    @FXML
    private Label hardwareTypeInfoDetailsLabel;
    @FXML
    private CheckBox onlyAvailableNodes;
    private final ObjectProperty<AdvertisementFetchManager.Resources.RefreshAdvertisementTask> activeRefreshTask = new SimpleObjectProperty();
    private final ObjectProperty<AdvertisementFetchManager.Resources> activeResources = new SimpleObjectProperty();

    public ComponentManagerPropertiesPane(@Nonnull Resource resource, @Nonnull FXRspecNode node, @Nonnull ObservableValue<TestbedSiteInfo> chosenSite, boolean initialAvailableNodesOnly, @Nonnull JFedGuiConfig config, @Nonnull AdvertisementFetchManager advertisementFetchManager, @Nonnull MapDialogFactory mapDialogFactory, @Nonnull BrowserUtil browserUtil) {
        JFedGuiConfig.NodesVisualization nodesVisualization;
        boolean hasHwType;
        assert (resource != null);
        assert (node != null);
        assert (chosenSite != null);
        this.resource = resource;
        this.chosenSite = chosenSite;
        this.config = config;
        this.browserUtil = browserUtil;
        this.advertisementFetchManager = advertisementFetchManager;
        this.mapDialogFactory = mapDialogFactory;
        FXMLUtil.injectFXML((Object)((Object)this));
        this.onlyAvailableNodes.setSelected(initialAvailableNodesOnly);
        Server server = resource.getServer();
        assert (server != null) : "Resource " + String.valueOf(resource.getId()) + " has no server";
        this.componentIdComboBox.setCellFactory(param -> new ComponentInfoCell(resource, config));
        this.componentIdComboBox.setButtonCell((ListCell)new ComponentInfoCell(resource, config){
            {
                this.nameLabel.setTextFill((Paint)Color.BLACK);
                this.container.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            }
        });
        this.componentIdComboBox.setPlaceholder((Node)new Label("--placeholder--"));
        JFedGuiConfig.Scope initialScope = initialAvailableNodesOnly ? JFedGuiConfig.Scope.AVAILABLE_ONLY : JFedGuiConfig.Scope.ALL;
        this.componentIdComboBox.setItems(this.filterComponentIdItems((ObservableList<JFedGuiConfig.ComponentInfo>)config.getComponentInfo(server, initialScope, resource)));
        this.hardwareTypesComboBox.setCellFactory(listview -> new HardwareTypeListCell(config, server, browserUtil));
        assert (Platform.isFxApplicationThread());
        this.hardwareTypesComboBox.setItems(config.getHardwareTypes(server, initialScope, resource));
        this.advertisementFetchOverlay.visibleProperty().unbind();
        this.advertisementFetchOverlay.visibleProperty().bind((ObservableValue)this.activeRefreshTask.isNotNull());
        this.activeRefreshTask.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.advertisementFetchProgressBar.progressProperty().unbind();
            }
            if (newValue != null) {
                this.advertisementFetchProgressBar.progressProperty().bind((ObservableValue)newValue.progressProperty());
            }
        });
        this.activeResources.addListener((observable, oldValue, newValue) -> {
            this.activeRefreshTask.unbind();
            this.activeRefreshTask.bind((ObservableValue)newValue.currentRefreshAdvertisementTaskProperty());
        });
        this.activeResources.set((Object)this.determineResourcesToActivate());
        this.componentIdComboBox.disableProperty().bind((ObservableValue)this.componentIdNodeRadioButton.selectedProperty().not());
        this.onlyAvailableNodes.disableProperty().bind((ObservableValue)this.anyNodeRadioButton.selectedProperty());
        this.hardwareTypesComboBox.disableProperty().bind((ObservableValue)this.hardwareTypeNodeRadioButton.selectedProperty().not());
        this.hardwareTypeInfoLabel.setVisible(false);
        this.onlyAvailableNodes.selectedProperty().addListener(observable -> {
            JFedGuiConfig.Scope scope = this.onlyAvailableNodes.isSelected() ? JFedGuiConfig.Scope.AVAILABLE_ONLY : JFedGuiConfig.Scope.ALL;
            LOG.debug("Will show " + String.valueOf(scope) + " nodes in comboboxes");
            this.activeResources.setValue((Object)this.determineResourcesToActivate());
            if (!config.hasUpToDateComponentInfo(server, scope)) {
                this.refreshAdvertisement();
            }
            assert (Platform.isFxApplicationThread());
            this.componentIdComboBox.setItems(this.filterComponentIdItems((ObservableList<JFedGuiConfig.ComponentInfo>)config.getComponentInfo(server, scope, resource)));
            this.hardwareTypesComboBox.setItems(config.getHardwareTypes(server, scope, resource));
        });
        chosenSite.addListener((observable, oldValue, newValue) -> {
            JFedGuiConfig.Scope scope = this.onlyAvailableNodes.isSelected() ? JFedGuiConfig.Scope.AVAILABLE_ONLY : JFedGuiConfig.Scope.ALL;
            this.componentIdComboBox.setItems(this.filterComponentIdItems((ObservableList<JFedGuiConfig.ComponentInfo>)config.getComponentInfo(server, scope, resource)));
        });
        boolean hasNodeId = node.getComponentId() != null;
        boolean bl = hasHwType = !node.getHardwareTypes().isEmpty();
        if (hasNodeId) {
            Optional<JFedGuiConfig.ComponentInfo> componentId = this.componentIdComboBox.getItems().stream().filter(compInfo -> Objects.equals(node.getComponentId(), compInfo.getUrn())).findFirst();
            if (componentId.isPresent()) {
                this.componentIdComboBox.getSelectionModel().select((Object)componentId.get());
                this.componentIdComboBox.setValue((Object)componentId.get());
                this.componentIdNodeRadioButton.setSelected(true);
            } else {
                JFedGuiConfig.ComponentInfo addedInfo = config.addUserComponentInfo((Integer)server.getId(), node.getComponentId());
                this.componentIdComboBox.getSelectionModel().select((Object)addedInfo);
                this.componentIdComboBox.setValue((Object)addedInfo);
                this.componentIdNodeRadioButton.setSelected(true);
            }
        } else if (hasHwType) {
            if (node.getHardwareTypes().size() > 1) {
                LOG.warn("A node can only have one hardware type in request, but we found {}. Taking first one, and ignoring the rest!", (Object)node.getHardwareTypes().size());
            }
            HardwareType userSpecifiedHardwareType = (HardwareType)node.getHardwareTypes().get(0);
            JFedGuiConfig.HardwareTypeInfo addedHardwareTypeInfo = config.addUserHardwareTypeInfo((Integer)server.getId(), userSpecifiedHardwareType.getName(), null);
            this.hardwareTypesComboBox.getSelectionModel().select((Object)addedHardwareTypeInfo);
            this.hardwareTypeNodeRadioButton.setSelected(true);
            this.componentIdComboBox.getSelectionModel().clearSelection();
            this.componentIdComboBox.setValue(null);
        } else {
            this.componentIdComboBox.getSelectionModel().clearSelection();
            this.componentIdComboBox.setValue(null);
        }
        this.componentIdNodeRadioButton.selectedProperty().addListener(observable -> {
            if (this.componentIdNodeRadioButton.isSelected() && !((AdvertisementFetchManager.Resources)this.activeResources.get()).isComponentIdsAvailable()) {
                this.refreshAdvertisement();
            }
        });
        this.hardwareTypeNodeRadioButton.selectedProperty().addListener(observable -> {
            if (this.hardwareTypeNodeRadioButton.isSelected() && !((AdvertisementFetchManager.Resources)this.activeResources.get()).isComponentIdsAvailable()) {
                this.refreshAdvertisement();
            }
        });
        if (this.resource.getRequireFixedNodeAssignment().booleanValue()) {
            this.anyNodeRadioButton.setDisable(true);
            this.componentIdNodeRadioButton.setSelected(true);
        }
        if (!this.resource.getAllowFixedNodeAssignment().booleanValue()) {
            assert (!this.resource.getRequireFixedNodeAssignment().booleanValue());
            this.componentIdNodeRadioButton.setVisible(false);
            this.componentIdComboBox.setVisible(false);
            this.nodesVizButton.setVisible(false);
            this.componentIdNodeRadioButton.setSelected(false);
        }
        if (!this.resource.getAllowFixedNodeAssignment().booleanValue() && !this.resource.getAllowHardwareType().booleanValue()) {
            assert (!this.resource.getRequireFixedNodeAssignment().booleanValue());
            assert (!this.resource.getRequireHardwareType().booleanValue());
            this.anyNodeRadioButton.setVisible(false);
            this.chooseNodeLabel.setVisible(false);
            this.onlyAvailableNodes.setVisible(false);
        }
        if (!(this.resource.getAllowFixedNodeAssignment().booleanValue() || this.resource.getAllowHardwareType().booleanValue() || this.resource.getAllowDiskImage().booleanValue())) {
            this.refreshAdvertisementButton.setVisible(false);
        }
        this.hardwareTypesComboBox.setVisible(this.resource.getAllowHardwareType().booleanValue());
        this.hardwareTypeNodeRadioButton.setVisible(this.resource.getAllowHardwareType().booleanValue());
        if (this.resource.getRequireHardwareType().booleanValue()) {
            this.anyNodeRadioButton.setDisable(true);
            if (!this.componentIdNodeRadioButton.isSelected()) {
                this.hardwareTypeNodeRadioButton.setSelected(true);
                if (!hasHwType && this.hardwareTypesComboBox.getValue() == null && !this.hardwareTypesComboBox.getItems().isEmpty()) {
                    this.hardwareTypesComboBox.getSelectionModel().selectFirst();
                }
            }
        }
        this.hardwareTypesComboBox.getSelectionModel().selectedItemProperty().addListener((ob, oldVal, newVal) -> {
            if (newVal == null) {
                this.hardwareTypeAvailableCountLabel.setVisible(false);
                this.hardwareTypeInfoLabel.setVisible(false);
                this.hardwareInfoRowConstraints.setPrefHeight(0.0);
            } else {
                if (newVal.getHardwareTypeName() == null || config.getHardwareTypeInfo(server).get() == null || ((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo)config.getHardwareTypeInfo(server).get()).getEntries() == null || ((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo)config.getHardwareTypeInfo(server).get()).getEntries().isEmpty()) {
                    this.hardwareTypeInfoLabel.setVisible(false);
                    this.hardwareInfoRowConstraints.setPrefHeight(0.0);
                } else {
                    Optional<ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry> hwTypeInfo = ((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo)config.getHardwareTypeInfo(server).get()).getEntries().stream().filter(e -> Objects.equals(e.getName(), newVal.getHardwareTypeName())).findAny();
                    this.hardwareTypeInfoLabel.setVisible(hwTypeInfo.isPresent());
                    if (hwTypeInfo.isPresent()) {
                        this.hardwareTypeInfoLabel.setText(hwTypeInfo.get().getHrn());
                        if (hwTypeInfo.get().getTextDescription() != null) {
                            this.hardwareTypeInfoDetailsLabel.setText(hwTypeInfo.get().getTextDescription());
                            this.hardwareTypeInfoDetailsLabel.setVisible(true);
                        } else {
                            this.hardwareTypeInfoDetailsLabel.setText("");
                            this.hardwareTypeInfoDetailsLabel.setVisible(false);
                        }
                        if (hwTypeInfo.get().getHtmlDescription() != null) {
                            this.hardwareTypeInfoButton.setVisible(true);
                            this.hardwareTypeInfoButton.setOnAction(event -> this.browserUtil.openUrlInBrowser(((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry)hwTypeInfo.get()).getHtmlDescription()));
                        } else {
                            this.hardwareTypeInfoButton.setVisible(false);
                        }
                        this.hardwareInfoRowConstraints.setPrefHeight(-1.0);
                    } else {
                        this.hardwareInfoRowConstraints.setPrefHeight(0.0);
                    }
                }
                this.hardwareTypeInfoLabel.getParent().requestLayout();
                AdvertisementCounts counts = (AdvertisementCounts)config.getServerNodeCounts(server).get();
                if (newVal.getHardwareTypeName() == null || counts == null) {
                    this.hardwareTypeAvailableCountLabel.setVisible(false);
                } else {
                    String hwType = newVal.getHardwareTypeName();
                    Integer allCount = counts.getHwCount(hwType, AdvertisementCounts.CountScope.ALL);
                    Integer availCount = counts.getHwCount(hwType, AdvertisementCounts.CountScope.AVAILABLE);
                    this.hardwareTypeAvailableCountLabel.setText(String.format("%d/%d", availCount, allCount));
                    this.hardwareTypeAvailableCountLabel.setVisible(true);
                }
            }
        });
        if (this.resource.getAllowFixedNodeAssignment().booleanValue() && (nodesVisualization = config.getNodesVisualization(this.resource.getServer())) != null) {
            this.nodesVizButton.disableProperty().bind((ObservableValue)this.componentIdComboBox.disableProperty());
            if (nodesVisualization == JFedGuiConfig.NodesVisualization.MAP) {
                this.nodesVizButton.setOnAction(this::showNodesMap);
                String arch = System.getProperty("os.arch");
                if (Objects.equals(arch, "x86")) {
                    this.nodesVizButton.setVisible(false);
                }
            } else if (nodesVisualization == JFedGuiConfig.NodesVisualization.IMAGE) {
                this.nodesVizButton.setOnAction(this::showNodesImageMap);
            }
        }
    }

    private ObservableList<JFedGuiConfig.ComponentInfo> filterComponentIdItems(ObservableList<JFedGuiConfig.ComponentInfo> orig) {
        if (this.chosenSite.getValue() == null) {
            return orig;
        }
        if (!this.resource.getServer().hasFlag(Server.Flag.featureSiteFilterNodesBySite)) {
            LOG.debug("Will not filter for site {} because server {} does not have featureSiteFilterNodesBySite", this.chosenSite.getValue(), (Object)this.resource.getServer().getName());
            return orig;
        }
        String subAuthName = ((TestbedSiteInfo)this.chosenSite.getValue()).getUrn().getSubAuthName(0);
        if (subAuthName == null) {
            LOG.debug("Will not filter for site {} because site URN no sub auth", this.chosenSite.getValue());
            return orig;
        }
        LOG.debug("Will filter for site {} server {}", this.chosenSite.getValue(), (Object)this.resource.getServer().getName());
        FilteredList res = new FilteredList(orig, ci -> ci.getSiteId() == null || ci.getSiteId().equals(subAuthName));
        LOG.debug("Filtering node list for site {} origLen={} filteredLen={} withSiteId={}", new Object[]{subAuthName, orig.size(), res.size(), orig.stream().filter(ci -> ci.getSiteId() != null).count()});
        return res;
    }

    private AdvertisementFetchManager.Resources determineResourcesToActivate() {
        Server server = this.resource.getServer();
        assert (server != null);
        boolean showAvailableOnly = this.onlyAvailableNodes.isSelected();
        if (!server.hasFlag(Server.Flag.workaroundRequestAvailableAdvertisement)) {
            showAvailableOnly = false;
        }
        if (showAvailableOnly) {
            return this.advertisementFetchManager.getAvailableResources(server);
        }
        return this.advertisementFetchManager.getAllResources(server);
    }

    private void showNodesImageMap(ActionEvent actionEvent) {
        ImageMap imageMap = this.config.getImageMap(this.resource.getServer());
        assert (imageMap != null);
        JFedGuiConfig.ComponentInfo selectedNode = this.mapDialogFactory.showNodeImageMapDialog(this.getScene().getWindow(), (ImageMap<GeniUrn>)imageMap, (Collection<JFedGuiConfig.ComponentInfo>)this.config.getComponentInfo(this.resource.getServer(), JFedGuiConfig.Scope.getScopeForAvailable((boolean)this.onlyAvailableNodes.isSelected()), this.resource));
        if (selectedNode != null) {
            this.componentIdComboBox.setValue((Object)selectedNode);
            this.componentIdComboBox.getSelectionModel().select((Object)selectedNode);
        }
    }

    private void showNodesMap(ActionEvent actionEvent) {
        JFedGuiConfig.ComponentInfo selectedNode = this.mapDialogFactory.showNodeMapDialog(this.getScene().getWindow(), (List<JFedGuiConfig.ComponentInfo>)this.config.getComponentInfo(this.resource.getServer(), JFedGuiConfig.Scope.getScopeForAvailable((boolean)this.onlyAvailableNodes.isSelected()), this.resource));
        if (selectedNode != null) {
            this.componentIdComboBox.setValue((Object)selectedNode);
            this.componentIdComboBox.getSelectionModel().select((Object)selectedNode);
        }
    }

    private static boolean isConnectivityException(Throwable t) {
        while (t != null) {
            if (t.getCause() instanceof JFedConnectivityException) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    private void refreshAdvertisement() {
        AdvertisementFetchManager.Resources.RefreshAdvertisementTask updateAdvTask = ((AdvertisementFetchManager.Resources)this.activeResources.get()).refreshAdvertisement();
        updateAdvTask.setOnFailed(workerStateEvent -> {
            if (this.getParent() != null) {
                if (ComponentManagerPropertiesPane.isConnectivityException(updateAdvTask.getException())) {
                    JFDialogs.create().owner((Node)this).message(String.format("A connectivity exception occurred while fetching the advertisement RSpec from %s.\n\nVerify your internet connection, and consider enabling a proxy in the jFed Preferences.", this.resource.getServer().getName())).masthead("Fetching node advertisement failed").title("Fetching node advertisement failed").showException(updateAdvTask.getException());
                } else {
                    JFDialogs.create().owner((Node)this).message(String.format("An error occurred while fetching the advertisement RSpec from %s.", this.resource.getServer().getName())).masthead("Fetching advertisement RSpec failed").title("Fetching advertisement RSpec failed").showException(updateAdvTask.getException());
                }
            }
        });
    }

    public boolean validate() {
        if (this.componentIdNodeRadioButton.isSelected() && this.componentIdComboBox.getSelectionModel().isEmpty()) {
            JFDialogs.create().owner((Node)this).message("Please select a node from the list").masthead("No node selected").showError();
            return false;
        }
        return true;
    }

    public GeniUrn getSelectedComponentId() {
        if (!this.componentIdNodeRadioButton.isSelected()) {
            return null;
        }
        JFedGuiConfig.ComponentInfo res = (JFedGuiConfig.ComponentInfo)this.componentIdComboBox.getSelectionModel().getSelectedItem();
        return res == null ? null : res.getUrn();
    }

    public ReadOnlyBooleanProperty isSpecificNodeChosen() {
        return this.componentIdNodeRadioButton.selectedProperty();
    }

    public HardwareType getSelectedHardwareType() {
        String hardwareTypeName;
        if (this.resource.getRequireHardwareType().booleanValue() && !this.resource.getAllowHardwareType().booleanValue() && this.resource.getHardwareType() != null) {
            return new HardwareType(this.resource.getHardwareType());
        }
        if (!this.hardwareTypeNodeRadioButton.isSelected()) {
            return null;
        }
        JFedGuiConfig.HardwareTypeInfo hardwareTypeInfo = (JFedGuiConfig.HardwareTypeInfo)this.hardwareTypesComboBox.getSelectionModel().getSelectedItem();
        String string = hardwareTypeName = hardwareTypeInfo == null ? null : hardwareTypeInfo.getHardwareTypeName();
        if (hardwareTypeName == null) {
            return null;
        }
        return new HardwareType(hardwareTypeName);
    }

    @FXML
    private void onRefreshAdvertisementAction() {
        this.refreshAdvertisement();
    }

    @FXML
    private void showTestbedMap() {
    }

    public boolean isAvailableNodesOnly() {
        return this.onlyAvailableNodes.isSelected();
    }
}

