/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.FXUtils;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.DelayRspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXLinkSetting;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayNodePropertiesDialog
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(DelayNodePropertiesDialog.class);
    private final DelayRspecNode node;
    private final ModelRspecEditor modelRspecEditor;
    private final ListProperty<FXLinkSetting> impairmentList;
    private final LongProperty capacity = new SimpleLongProperty();
    private final IntegerProperty latency = new SimpleIntegerProperty();
    private final DoubleProperty packetLoss = new SimpleDoubleProperty();
    @FXML
    private Button saveButton;
    @FXML
    private Button cancelButton;
    @FXML
    private TextField nameTextField;
    @FXML
    private ToggleGroup impairmentToggleGroup;
    @FXML
    private RadioButton simpleLinkImpairmentRadioButton;
    @FXML
    private TextField capacityTextField;
    @FXML
    private TextField latencyTextField;
    @FXML
    private TextField packetLossTextField;
    @FXML
    private CheckBox capacityCheckBox;
    @FXML
    private CheckBox latencyCheckBox;
    @FXML
    private CheckBox packetLossCheckBox;
    @FXML
    private RadioButton advancedLinkImpairmentRadioButton;
    @FXML
    private TableView<FXLinkSetting> advancedImpairmentTableView;
    @FXML
    private TableColumn<FXLinkSetting, String> fromTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, String> toTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, Number> capacityTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, Number> latencyTableColumn;
    @FXML
    private TableColumn<FXLinkSetting, Number> packetLossTableColumn;

    private DelayNodePropertiesDialog(ModelRspecEditor modelRspecEditor, DelayRspecNode node) {
        this.modelRspecEditor = modelRspecEditor;
        this.node = node;
        this.impairmentList = node.getLinkSettings();
        FXMLUtil.injectFXML((Object)((Object)this));
        this.nameTextField.setText(node.getClientId());
        FXLinkSetting ls = (FXLinkSetting)node.getLinkSettings().get(0);
        this.capacity.setValue((Number)ls.getCapacity_Kbps());
        this.latency.setValue((Number)ls.getLatency_ms());
        this.packetLoss.setValue((Number)ls.getPacketLoss());
        if (this.hasAdvancedImpairmentSettings()) {
            this.impairmentToggleGroup.selectToggle((Toggle)this.advancedLinkImpairmentRadioButton);
        }
        this.capacityTextField.textProperty().bindBidirectional((Property)this.capacity, (StringConverter)new NumberStringConverter());
        this.capacityTextField.focusedProperty().addListener(observable -> {
            if (!this.capacityTextField.isFocused() && this.capacity.get() < 0L) {
                JFDialogs.create().owner(this.advancedImpairmentTableView.getScene().getWindow()).message("Capacity must be a non-negative value").masthead("Invalid Capacity Loss value").showError();
                this.capacity.setValue((Number)0);
            }
        });
        this.capacityCheckBox.selectedProperty().bind((ObservableValue)Bindings.notEqual((int)0, (ObservableNumberValue)this.capacity));
        this.capacityCheckBox.selectedProperty().addListener(observable -> LOG.debug("new checkbox value:" + this.capacityCheckBox.isSelected()));
        this.latencyTextField.textProperty().bindBidirectional((Property)this.latency, (StringConverter)new NumberStringConverter());
        this.latencyTextField.focusedProperty().addListener(observable -> {
            if (!this.latencyTextField.isFocused() && this.latency.get() < 0) {
                JFDialogs.create().owner(this.advancedImpairmentTableView.getScene().getWindow()).message("Latency must be a non-negative value").masthead("Invalid Latency value").showError();
                this.latency.setValue((Number)0);
            }
        });
        this.latencyCheckBox.selectedProperty().bind((ObservableValue)Bindings.notEqual((int)0, (ObservableNumberValue)this.latency));
        this.packetLossTextField.textProperty().bindBidirectional((Property)this.packetLoss, (StringConverter)new NumberStringConverter());
        this.packetLossTextField.focusedProperty().addListener(observable -> {
            if (!this.packetLossTextField.isFocused() && (this.packetLoss.get() < 0.0 || this.packetLoss.get() > 1.0)) {
                JFDialogs.create().owner(this.advancedImpairmentTableView.getScene().getWindow()).message("Packet loss must be between 0 and 1").masthead("Invalid Packet Loss value").showError();
                this.packetLoss.setValue((Number)0);
            }
        });
        this.packetLossCheckBox.selectedProperty().bind((ObservableValue)Bindings.notEqual((int)0, (ObservableNumberValue)this.packetLoss));
        this.fromTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).getFromIface().clientIdProperty());
        this.toTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).getToIface().clientIdProperty());
        this.capacityTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.capacityTableColumn.setOnEditCommit(e -> {
            if (((Number)e.getNewValue()).intValue() < 0) {
                JFDialogs.create().owner(this.advancedImpairmentTableView.getScene().getWindow()).message("Capacity must be a non-negative value").masthead("Invalid Capacity value").showError();
                return;
            }
            ((FXLinkSetting)e.getRowValue()).capacity_KbpsProperty().setValue((Number)e.getNewValue());
        });
        this.capacityTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).capacity_KbpsProperty());
        this.latencyTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.latencyTableColumn.setOnEditCommit(e -> {
            if (((Number)e.getNewValue()).intValue() < 0) {
                JFDialogs.create().owner(this.advancedImpairmentTableView.getScene().getWindow()).message("Latency must be a non-negative value").masthead("Invalid Latency value").showError();
                return;
            }
            ((FXLinkSetting)e.getRowValue()).latency_msProperty().setValue((Number)e.getNewValue());
        });
        this.latencyTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).latency_msProperty());
        this.packetLossTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.packetLossTableColumn.setOnEditCommit(e -> {
            if (((Number)e.getNewValue()).doubleValue() < 0.0 || ((Number)e.getNewValue()).doubleValue() > 1.0) {
                JFDialogs.create().owner(this.advancedImpairmentTableView.getScene().getWindow()).message("Packet loss must be between 0 and 1").masthead("Invalid Packet Loss value").showError();
                return;
            }
            ((FXLinkSetting)e.getRowValue()).setPacketLoss(Double.valueOf(((Number)e.getNewValue()).doubleValue()));
        });
        this.packetLossTableColumn.setCellValueFactory(p -> ((FXLinkSetting)p.getValue()).packetLossProperty());
        this.capacityTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.packetLossTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.latencyTableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
        this.advancedImpairmentTableView.setItems(this.impairmentList);
        this.latencyTextField.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.simpleLinkImpairmentRadioButton.selectedProperty()));
        this.capacityTextField.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.simpleLinkImpairmentRadioButton.selectedProperty()));
        this.packetLossTextField.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.simpleLinkImpairmentRadioButton.selectedProperty()));
        this.advancedImpairmentTableView.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.advancedLinkImpairmentRadioButton.selectedProperty()));
        this.capacity.addListener(observable -> {
            for (FXLinkSetting ls13 : this.node.getLinkSettings()) {
                ls13.setCapacity_Kbps(Long.valueOf(this.capacity.get()));
            }
        });
        this.packetLoss.addListener(observable -> {
            for (FXLinkSetting ls12 : this.node.getLinkSettings()) {
                ls12.setPacketLoss(Double.valueOf(this.packetLoss.get()));
            }
        });
        this.latency.addListener(observable -> {
            for (FXLinkSetting ls1 : this.node.getLinkSettings()) {
                ls1.setLatency_ms(Integer.valueOf(this.latency.get()));
            }
        });
        this.impairmentToggleGroup.selectedToggleProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue == this.simpleLinkImpairmentRadioButton && this.hasAdvancedImpairmentSettings()) {
                if (JFDialogs.create().owner((Node)this).message("Switching to simple impairment-mode will cause your advanced settings to reverse. Are you sure?").title("Switching to simple impairment mode").showConfirm().filter(r -> r == ButtonType.YES).isPresent()) {
                    this.resetAdvancedImpairmentSettings();
                } else {
                    this.impairmentToggleGroup.selectToggle((Toggle)this.advancedLinkImpairmentRadioButton);
                }
            }
        });
    }

    public static void showNodePropertiesDialog(Window parentWindow, ModelRspecEditor modelRspecEditor, DelayRspecNode link) {
        Scene scene = new Scene((Parent)new DelayNodePropertiesDialog(modelRspecEditor, link));
        Stage dialogStage = new Stage();
        StageUtils.setJFedStageIcons((Stage)dialogStage);
        dialogStage.setScene(scene);
        dialogStage.setTitle("Properties of " + link.getClientId());
        dialogStage.setResizable(true);
        FXUtils.centerToOwner(parentWindow, (Window)dialogStage);
        dialogStage.showAndWait();
    }

    private void resetAdvancedImpairmentSettings() {
        for (FXLinkSetting ls : this.node.getLinkSettings()) {
            ls.setCapacity_Kbps(Long.valueOf(this.capacity.get()));
            ls.setLatency_ms(Integer.valueOf(this.latency.get()));
            ls.setPacketLoss(Double.valueOf(this.packetLoss.get()));
        }
    }

    private boolean hasAdvancedImpairmentSettings() {
        for (FXLinkSetting ls : this.node.getLinkSettings()) {
            if (ls.getLatency_ms() != this.latency.get()) {
                return true;
            }
            if (ls.getCapacity_Kbps() != this.capacity.get()) {
                return true;
            }
            if (ls.getPacketLoss() == this.packetLoss.get()) continue;
            return true;
        }
        return false;
    }

    @FXML
    public void onSaveAction(ActionEvent actionEvent) {
        if (!this.isValidLinkName(this.nameTextField.getText())) {
            JFDialogs.create().owner((Node)this).message("A link name may only contain alphanumerical characters, and is maximum " + this.getMaximumLinkNameLength() + " characters long.").masthead("The entered link name is invalid.").showError();
            return;
        }
        this.node.setClientId(this.nameTextField.getText());
        Stage stage = (Stage)this.saveButton.getScene().getWindow();
        stage.close();
    }

    private int getMaximumLinkNameLength() {
        return 25;
    }

    private boolean isValidLinkName(String text) {
        if (text.length() > this.getMaximumLinkNameLength()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            boolean validChar;
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
            if (validChar) continue;
            return false;
        }
        return true;
    }

    @FXML
    public void onCancelAction(ActionEvent actionEvent) {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }
}

