/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesTab;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExoGeniConfigTab
extends AdaptivePropertiesTab<FXRspecNode> {
    private static final Logger LOG = LoggerFactory.getLogger(ExoGeniConfigTab.class);
    private final AdaptivePropertiesDialog adaptivePropertiesDialog;
    @FXML
    private ComboBox<String> resourceTypeComboBox;
    @FXML
    private HBox exoGeniHelp;
    @FXML
    private HBox genericHelp;
    private final BrowserUtil browserUtil;
    private static final String[] EXOGENI_VM_TYPES = new String[]{"default-vm", "xo.small", "xo.medium", "xo.large", "xo.xlarge"};

    public ExoGeniConfigTab(AdaptivePropertiesDialog adaptivePropertiesDialog, BrowserUtil browserUtil) {
        super("Resource Type");
        this.adaptivePropertiesDialog = adaptivePropertiesDialog;
        this.browserUtil = browserUtil;
        this.setContent((Node)FXMLUtil.createFromFXML((Object)((Object)this)));
        adaptivePropertiesDialog.selectedResourceProperty().addListener((prop, oldVal, newVal) -> {
            FXRspecNode rspecNode = adaptivePropertiesDialog.getRspecNode();
            if (newVal != null && newVal.getAllowedSliverTypes() != null && rspecNode.getSliverTypeName() != null && newVal.getSliverType() != null && !newVal.getAllowedSliverTypes().contains(rspecNode.getSliverTypeName())) {
                rspecNode.setSliverTypeName(newVal.getSliverType());
            }
            this.load(rspecNode);
        });
    }

    @Override
    public void load(FXRspecNode rspecNode) {
        boolean isEG = this.isExoGeni(rspecNode);
        this.exoGeniHelp.setVisible(isEG);
        this.genericHelp.setVisible(!isEG);
        this.setText(isEG ? "ExoGeni Resource Type" : "Resource Type");
        Resource resource = this.adaptivePropertiesDialog.getSelectedResource();
        if (resource == null) {
            LOG.warn("adaptivePropertiesDialog.getSelectedResource() is null");
            this.resourceTypeComboBox.getItems().clear();
            this.resourceTypeComboBox.getSelectionModel().clearSelection();
            return;
        }
        HashSet<String> allowedTypes = new HashSet<String>();
        if (resource.getAllowedSliverTypes() != null) {
            allowedTypes.addAll(resource.getAllowedSliverTypes());
        }
        if (isEG) {
            allowedTypes.addAll(Arrays.asList(EXOGENI_VM_TYPES));
        }
        LOG.debug("Setting allowedTypes (isEG={}): {}", (Object)isEG, allowedTypes);
        this.resourceTypeComboBox.getItems().setAll(allowedTypes);
        String sliverTypeName = rspecNode.getSliverTypeName();
        if (sliverTypeName == null && allowedTypes.contains("default-vm")) {
            sliverTypeName = "default-vm";
        }
        if (sliverTypeName == null && !allowedTypes.isEmpty()) {
            sliverTypeName = (String)allowedTypes.iterator().next();
        }
        if (sliverTypeName != null) {
            if (!allowedTypes.contains(sliverTypeName)) {
                this.resourceTypeComboBox.getItems().add((Object)sliverTypeName);
                LOG.warn("sliver_type {} unknown, will still show in list (known={})", (Object)sliverTypeName, allowedTypes);
            }
            this.resourceTypeComboBox.getSelectionModel().select((Object)sliverTypeName);
        }
    }

    @Override
    public void save(FXRspecNode rspecNode) {
        String selectedTypeName = (String)this.resourceTypeComboBox.getSelectionModel().getSelectedItem();
        if (selectedTypeName != null) {
            rspecNode.setSliverTypeName(selectedTypeName);
        }
        LOG.debug("After setting sliver type name, slivertype it is: " + String.valueOf(rspecNode.getSliverType()));
    }

    @Override
    public void onTabShown() {
    }

    public boolean isExoGeni(FXRspecNode rspecNode) {
        Resource resource = this.adaptivePropertiesDialog.getSelectedResource();
        if (resource == null) {
            return false;
        }
        Server server = resource.getServer();
        if (server == null) {
            return false;
        }
        return server.isServerType("exogeni") || server.isServerType("orca");
    }

    @Override
    public boolean shouldBeVisible(FXRspecNode rspecNode) {
        if (this.isExoGeni(rspecNode)) {
            return true;
        }
        Resource resource = this.adaptivePropertiesDialog.getSelectedResource();
        if (resource == null) {
            return false;
        }
        assert (resource.getAllowedSliverTypes() != null);
        if (resource.getAllowedSliverTypes() == null) {
            return false;
        }
        LOG.debug("resource {} has allowedSliverTypes = {}", resource.getId(), (Object)resource.getAllowedSliverTypes());
        return resource.getAllowedSliverTypes().stream().filter(st -> !st.equalsIgnoreCase("default-vm")).count() > 1L;
    }

    @Override
    public String validateConfiguration() {
        return null;
    }

    public void onExoResourceHelpLinkClicked() {
        try {
            this.browserUtil.openUrlInBrowser(new URI("https://wiki.exogeni.net/doku.php?id=public:experimenters:resource_types:start"));
        }
        catch (URISyntaxException e) {
            LOG.error("Should not occur", (Throwable)e);
        }
    }
}

