/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javax.annotation.Nonnull;

public class HardwareTypeListCell
extends ListCell<JFedGuiConfig.HardwareTypeInfo> {
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final Server server;
    @Nonnull
    private final BrowserUtil browserUtil;
    protected final VBox container = new VBox(2.0);
    private final Label nameLabel;
    private final Label countLabel;
    private final Label infoLabel;
    private final Hyperlink infoLink;

    public HardwareTypeListCell(@Nonnull JFedGuiConfig config, @Nonnull Server server, @Nonnull BrowserUtil browserUtil) {
        this.config = config;
        this.server = server;
        this.browserUtil = browserUtil;
        this.nameLabel = new Label();
        this.countLabel = new Label();
        this.infoLabel = new Label();
        this.infoLink = new Hyperlink();
        this.infoLabel.managedProperty().bind((ObservableValue)this.infoLabel.visibleProperty());
        this.infoLink.managedProperty().bind((ObservableValue)this.infoLink.visibleProperty());
        this.countLabel.managedProperty().bind((ObservableValue)this.countLabel.visibleProperty());
        Region filler = new Region();
        HBox.setHgrow((Node)filler, (Priority)Priority.ALWAYS);
        HBox container2 = new HBox(2.0);
        container2.getChildren().addAll((Object[])new Node[]{this.nameLabel, filler, this.countLabel});
        this.container.getChildren().addAll((Object[])new Node[]{container2, this.infoLabel});
        this.infoLabel.setWrapText(true);
        this.infoLabel.setMaxWidth(400.0);
        this.infoLabel.setPrefWidth(330.0);
        this.infoLabel.setStyle("-fx-word-wrap: break-word; -fx-font-scale: 75%; -fx-text-fill: darkgrey");
        this.setGraphic((Node)this.container);
    }

    protected void updateItem(JFedGuiConfig.HardwareTypeInfo item, boolean empty) {
        AdvertisementCounts counts;
        Optional<ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry> hwTypeInfo;
        super.updateItem((Object)item, empty);
        if (item == null) {
            this.setText(null);
            this.setGraphic(null);
            return;
        }
        this.setText(null);
        this.setGraphic((Node)this.container);
        this.nameLabel.setText(item.getHardwareTypeName());
        this.countLabel.setText("?/?");
        boolean hasAnyInfo = item.getHardwareTypeName() != null && this.config.getHardwareTypeInfo(this.server).get() != null && !((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo)this.config.getHardwareTypeInfo(this.server).get()).getEntries().isEmpty();
        boolean showInfo = false;
        boolean showLink = false;
        if (hasAnyInfo && (hwTypeInfo = ((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo)this.config.getHardwareTypeInfo(this.server).get()).getEntries().stream().filter(e -> Objects.equals(e.getName(), item.getHardwareTypeName())).findAny()).isPresent()) {
            if (hwTypeInfo.get().getHrn() != null) {
                showInfo = true;
                this.infoLabel.setText(hwTypeInfo.get().getHrn());
            } else if (hwTypeInfo.get().getTextDescription() != null) {
                showInfo = true;
                this.infoLabel.setText(hwTypeInfo.get().getTextDescription());
            }
            if (hwTypeInfo.get().getHtmlDescription() != null) {
                showLink = true;
                this.infoLink.setOnAction(event -> this.browserUtil.openUrlInBrowser(((ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry)hwTypeInfo.get()).getHtmlDescription()));
            }
        }
        if ((counts = (AdvertisementCounts)this.config.getServerNodeCounts(this.server).get()) == null) {
            this.countLabel.setVisible(false);
        } else {
            String hwType = item.getHardwareTypeName();
            Integer allCount = counts.getHwCount(hwType, AdvertisementCounts.CountScope.ALL);
            Integer availCount = counts.getHwCount(hwType, AdvertisementCounts.CountScope.AVAILABLE);
            if (allCount != null || availCount != null) {
                this.countLabel.setText(String.format("%d/%d", availCount, allCount));
                this.countLabel.setVisible(true);
            } else {
                this.countLabel.setVisible(false);
            }
        }
        this.infoLink.setVisible(showLink);
        this.infoLabel.setVisible(showInfo);
    }
}

