/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.PropertiesTab;
import be.iminds.ilabt.jfed.experimenter_gui.util.InetAddressUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.UIUtils;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfacePropertiesTab
extends PropertiesTab {
    private static final Logger LOG = LoggerFactory.getLogger(InterfacePropertiesTab.class);
    private final ModelRspecEditor modelRspecEditor;
    private final FXRspecNode rspecNode;
    private final FXRspecLink rspecLink;
    private final FXRspecInterface rspecInterface;
    private final RspecInterface.IpAddress ipAddress;
    private final ReadOnlyStringProperty newNodeNameProperty;
    @FXML
    private TextField idInputField;
    @FXML
    private ToggleGroup ipToggleGroup;
    @FXML
    private RadioButton autoConfigRadioButton;
    @FXML
    private RadioButton ipv4RadioButton;
    @FXML
    private RadioButton ipv6RadioButton;
    @FXML
    private TitledPane ipv4Pane;
    @FXML
    private TitledPane ipv6Pane;
    @FXML
    private TextField ipv4Address;
    @FXML
    private TextField ipv4NetMask;
    @FXML
    private TextField ipv6Address;
    @FXML
    private TextField ipv6NetMask;

    public InterfacePropertiesTab(ModelRspecEditor modelRspecEditor, FXRspecNode rspecNode, FXRspecInterface rspecInterface, ReadOnlyStringProperty newNodeNameProperty) {
        this.modelRspecEditor = modelRspecEditor;
        this.rspecNode = rspecNode;
        this.rspecInterface = rspecInterface;
        this.newNodeNameProperty = newNodeNameProperty;
        this.rspecLink = rspecInterface.isLinkBound() ? rspecInterface.getLink() : null;
        this.ipAddress = !rspecInterface.getIpAddresses().isEmpty() ? (RspecInterface.IpAddress)rspecInterface.getIpAddresses().get(0) : null;
        this.setContent((Node)FXMLUtil.createFromFXML((Object)((Object)this)));
        this.ipv4Pane.disableProperty().bind((ObservableValue)this.ipv4RadioButton.selectedProperty().not());
        this.ipv6Pane.disableProperty().bind((ObservableValue)this.ipv6RadioButton.selectedProperty().not());
        this.ipv4RadioButton.selectedProperty().addListener(observable -> {
            if (!this.ipv4RadioButton.isSelected()) {
                this.ipv4Address.clear();
                this.ipv4NetMask.clear();
            }
        });
        this.ipv6RadioButton.selectedProperty().addListener(observable -> {
            if (!this.ipv6RadioButton.isSelected()) {
                this.ipv6Address.clear();
                this.ipv6NetMask.clear();
            }
        });
        this.ipToggleGroup.selectedToggleProperty().addListener(observable -> {
            if (this.ipToggleGroup.getSelectedToggle() == this.ipv4RadioButton) {
                this.ipv6Address.clear();
                this.ipv6NetMask.clear();
                if (this.ipAddress != null && ("ipv4".equalsIgnoreCase(this.ipAddress.getType()) || this.ipAddress.getType() == null)) {
                    this.ipv4Address.setText(this.ipAddress.getAddress());
                    this.ipv4NetMask.setText(this.ipAddress.getNetmask());
                } else {
                    this.ipv4NetMask.setText("255.255.255.0");
                }
            } else {
                this.ipv4Address.clear();
                this.ipv4NetMask.clear();
                if (this.ipAddress != null && "ipv6".equalsIgnoreCase(this.ipAddress.getType())) {
                    this.ipv6Address.setText(this.ipAddress.getAddress());
                    this.ipv6NetMask.setText(this.ipAddress.getNetmask());
                } else {
                    this.ipv6NetMask.setText("64");
                }
            }
        });
        this.idInputField.setText(rspecInterface.getClientId());
        UIUtils.setTextLimit(this.idInputField, 14);
        this.textProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{"Interface "}).concat((Object)this.idInputField.textProperty()));
        if (this.ipAddress != null) {
            if ("ipv6".equalsIgnoreCase(this.ipAddress.getType())) {
                this.ipv6RadioButton.setSelected(true);
            } else {
                this.ipv4RadioButton.setSelected(true);
            }
        }
        newNodeNameProperty.addListener((observable, oldValue, newValue) -> this.idInputField.setText(this.idInputField.getText().replace((CharSequence)oldValue, (CharSequence)newValue)));
    }

    @Override
    public void save() {
        this.rspecInterface.setClientId(this.idInputField.getText());
        this.rspecInterface.getIpAddresses().clear();
        if (this.ipv4RadioButton.isSelected()) {
            this.rspecInterface.getIpAddresses().add((Object)new RspecInterface.IpAddress(this.ipv4Address.getText(), this.ipv4NetMask.getText(), "ipv4"));
        } else if (this.ipv6RadioButton.isSelected()) {
            this.rspecInterface.getIpAddresses().add((Object)new RspecInterface.IpAddress(this.ipv6Address.getText(), this.ipv6NetMask.getText(), "ipv6"));
        }
    }

    @Override
    public String validateConfiguration() {
        if (this.idInputField.getText() == null || !InterfacePropertiesTab.isValidInterfaceName(this.idInputField.getText())) {
            return String.format("'%s' is not a valid interface name.", this.idInputField.getText());
        }
        if (this.ipv4RadioButton.isSelected() && !InetAddressUtil.isValidInet4Address(this.ipv4Address.getText())) {
            return "The entered IPv4-address for interface " + this.rspecInterface.getClientId() + " is not valid.";
        }
        if (this.ipv4RadioButton.isSelected() && !InetAddressUtil.isValidInet4Address(this.ipv4NetMask.getText())) {
            return "The entered IPv4-netmask for interface " + this.rspecInterface.getClientId() + " is not valid.";
        }
        if (this.ipv6RadioButton.isSelected() && !InetAddressUtil.isValidInet6Address(this.ipv6Address.getText())) {
            return "The entered IPv6-address for interface " + this.rspecInterface.getClientId() + " is not valid.";
        }
        if (this.ipv6RadioButton.isSelected() && !InetAddressUtil.isValidInet6Netmask(this.ipv6NetMask.getText())) {
            return "The entered IPv6-prefix length for interface " + this.rspecInterface.getClientId() + " is not valid.";
        }
        return null;
    }

    private static boolean isValidInterfaceName(@Nonnull String text) {
        if (text.trim().isEmpty()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            boolean validChar;
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ':' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

