/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesTab;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutableIPTab
extends AdaptivePropertiesTab<FXRspecNode> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutableIPTab.class);
    private static final String BOOT_SCRIPTS_FXML = "RoutableIPTab.fxml";
    private final AdaptivePropertiesDialog adaptivePropertiesDialog;
    @FXML
    private CheckBox routableIPCheckbox;

    public RoutableIPTab(AdaptivePropertiesDialog adaptivePropertiesDialog) {
        super("Routable Control IP");
        this.adaptivePropertiesDialog = adaptivePropertiesDialog;
        this.setContent((Node)FXMLUtil.createFromFXML((Object)((Object)this)));
    }

    @Override
    public void load(FXRspecNode rspecNode) {
        this.routableIPCheckbox.setSelected(rspecNode.getRoutableControlIp());
    }

    @Override
    public void save(FXRspecNode rspecNode) {
        rspecNode.setRoutableControlIp(this.routableIPCheckbox.isSelected());
    }

    @Override
    public void onTabShown() {
    }

    @Override
    public boolean shouldBeVisible(FXRspecNode rspecNode) {
        String currentSliverTypeName = this.adaptivePropertiesDialog.getCurrentSliverTypeName();
        return "emulab-xen".equals(currentSliverTypeName) || "emulab-openvz".equals(currentSliverTypeName);
    }

    @Override
    public String validateConfiguration() {
        return null;
    }
}

