/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.config.AdvertisementFetchManager;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.SelectDiskImageDialog;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.DeleteDiskImageTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.TasksFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListDiskImagesTask;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.VBox;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDiskImageController {
    private static final Logger LOG = LoggerFactory.getLogger(SelectDiskImageDialog.class);
    private final BooleanProperty isLoadingUserImages = new SimpleBooleanProperty(false);
    private final JFedGuiConfig config;
    private final TestbedInfoSource testbedInfoSource;
    private final AdvertisementFetchManager advertisementFetchManager;
    private final HighLevelTaskFactory hltf;
    private final TaskThread tt;
    private final TasksFactory tasksFactory;
    private final TaskService taskService;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @FXML
    private VBox root;
    @FXML
    private RadioButton publicDiskImagesRadioButton;
    @FXML
    private ComboBox<DiskImage> publicDiskImagesComboBox;
    @FXML
    private VBox publicFetchOverlay;
    @FXML
    private ProgressBar publicAdvertisementFetchProgressBar;
    private Server currentPublicDiskImagesServer = null;
    @FXML
    private RadioButton privateDiskImagesRadioButton;
    @FXML
    private ComboBox<AggregateManagerWrapper.ImageInfo> privateDiskImagesComboBox;
    @FXML
    private VBox privateFetchOverlay;
    @FXML
    private ProgressBar privateAdvertisementFetchProgressBar;
    @FXML
    private Button deletePrivateDiskImageButton;
    @FXML
    private CheckBox advancedCheckBox;
    @FXML
    private VBox advancedVBox;
    @FXML
    private ComboBox<Server> sourceTestbedComboBox;
    private Server currentPrivateDiskImagesServer = null;
    private Resource nodeResource = null;
    private InvalidationListener publicRefreshTaskInvalidationListener;

    @Inject
    public SelectDiskImageController(JFedGuiConfig config, TestbedInfoSource testbedInfoSource, AdvertisementFetchManager advertisementFetchManager, HighLevelTaskFactory hltf, TaskThread tt, TasksFactory tasksFactory, TaskService taskService, AggregateManagerWrapperFactory aggregateManagerWrapperFactory) {
        this.config = config;
        this.testbedInfoSource = testbedInfoSource;
        this.advertisementFetchManager = advertisementFetchManager;
        this.hltf = hltf;
        this.tt = tt;
        this.tasksFactory = tasksFactory;
        this.taskService = taskService;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
    }

    @FXML
    public void initialize() {
        this.advancedVBox.visibleProperty().bind((ObservableValue)this.advancedCheckBox.selectedProperty());
        this.deletePrivateDiskImageButton.visibleProperty().bind((ObservableValue)this.advancedCheckBox.selectedProperty());
        this.publicRefreshTaskInvalidationListener = observable -> {
            if (this.currentPublicDiskImagesServer != null) {
                assert (this.publicAdvertisementFetchProgressBar != null);
                AdvertisementFetchManager.AllResources resources = this.advertisementFetchManager.getAllResources(this.currentPublicDiskImagesServer);
                if (resources.getCurrentRefreshAdvertisementTask() == null) {
                    this.publicAdvertisementFetchProgressBar.progressProperty().unbind();
                    this.updatePublicDiskImagesList();
                } else {
                    this.publicAdvertisementFetchProgressBar.progressProperty().bind((ObservableValue)resources.getCurrentRefreshAdvertisementTask().progressProperty());
                }
            } else {
                LOG.debug("currentPublicDiskImagesServer == null -> doing nothing");
            }
        };
        ObservableList allServers = FXCollections.observableArrayList((Collection)this.testbedInfoSource.getServers());
        FilteredList serversWithDiskImages = new FilteredList(allServers, s -> s.hasFlag(Server.Flag.featurePoaExtDiskImageOps));
        SortedList sortedServers = new SortedList((ObservableList)serversWithDiskImages, (o1, o2) -> Objects.compare(o1.getName(), o2.getName(), String::compareTo));
        this.sourceTestbedComboBox.setItems((ObservableList)sortedServers);
        this.sourceTestbedComboBox.setConverter(StringConverters.SERVER_STRING_CONVERTER);
        assert (this.publicRefreshTaskInvalidationListener != null);
        this.sourceTestbedComboBox.getSelectionModel().selectedItemProperty().addListener(observable -> {
            if (!this.areUserDiskImagesAvailable()) {
                this.publicDiskImagesRadioButton.setSelected(true);
            }
            this.privateDiskImagesRadioButton.setDisable(!this.areUserDiskImagesAvailable());
            if (this.publicDiskImagesRadioButton.isSelected()) {
                this.updatePublicDiskImagesComponentManagerInfo();
            } else {
                this.updatePrivateDiskImagesComponentManagerInfo(false);
            }
        });
        this.publicDiskImagesComboBox.disableProperty().bind((ObservableValue)this.publicDiskImagesRadioButton.selectedProperty().not());
        this.publicDiskImagesComboBox.setConverter(StringConverters.DISK_IMAGE_STRING_CONVERTER);
        this.privateDiskImagesComboBox.disableProperty().bind((ObservableValue)this.privateDiskImagesRadioButton.selectedProperty().not());
        this.privateDiskImagesComboBox.setConverter(StringConverters.IMAGEINFO_STRING_CONVERTER);
        this.privateFetchOverlay.visibleProperty().bind((ObservableValue)this.isLoadingUserImages);
        this.deletePrivateDiskImageButton.disableProperty().bind((ObservableValue)this.privateDiskImagesComboBox.getSelectionModel().selectedItemProperty().isNull());
        this.deletePrivateDiskImageButton.setOnAction(this::deleteCurrentPrivateDiskImage);
        this.privateDiskImagesRadioButton.selectedProperty().addListener(observable -> this.updatePrivateDiskImagesComponentManagerInfo(false));
        this.advancedCheckBox.selectedProperty().addListener((observableValue, oldVal, newVal) -> this.updatePublicDiskImagesList());
    }

    public void setResource(@Nonnull Resource nodeResource) {
        this.nodeResource = nodeResource;
        if (nodeResource == null) {
            this.sourceTestbedComboBox.getSelectionModel().selectFirst();
        } else {
            this.sourceTestbedComboBox.getSelectionModel().select((Object)nodeResource.getServer());
        }
        this.updatePublicDiskImagesComponentManagerInfo();
        this.updatePublicDiskImagesList();
    }

    private void deleteCurrentPrivateDiskImage(ActionEvent actionEvent) {
        AggregateManagerWrapper.ImageInfo imageInfo = (AggregateManagerWrapper.ImageInfo)this.privateDiskImagesComboBox.getSelectionModel().getSelectedItem();
        Optional answer = JFDialogs.create().title("Delete disk image").message(String.format("Are you sure you want to permanently delete disk image '%s' from %s?", StringConverters.IMAGEINFO_STRING_CONVERTER.toString((Object)imageInfo), this.currentPrivateDiskImagesServer.getName())).showConfirm();
        if (answer.isPresent() && (Objects.equals(answer.get(), ButtonType.YES) || Objects.equals(answer.get(), ButtonType.OK))) {
            DeleteDiskImageTask deleteDiskImageTask = this.tasksFactory.createDeleteDiskImageTask(this.currentPrivateDiskImagesServer, imageInfo);
            deleteDiskImageTask.setOnSucceeded(event -> this.updatePrivateDiskImagesComponentManagerInfo(true));
            this.taskService.submitTask(deleteDiskImageTask);
        }
    }

    private void updatePublicDiskImagesComponentManagerInfo() {
        AdvertisementFetchManager.AvailableResources availableResources;
        AdvertisementFetchManager.AllResources allResources;
        Server server = (Server)this.sourceTestbedComboBox.getSelectionModel().getSelectedItem();
        if (server == null) {
            return;
        }
        if (this.publicDiskImagesRadioButton.isSelected() && this.currentPublicDiskImagesServer != server) {
            if (this.currentPublicDiskImagesServer != null) {
                this.config.getDiskImages(this.currentPublicDiskImagesServer).removeListener(this.publicRefreshTaskInvalidationListener);
            }
            this.currentPublicDiskImagesServer = server;
            assert (this.currentPublicDiskImagesServer != null);
            allResources = this.advertisementFetchManager.getAllResources(this.currentPublicDiskImagesServer);
            availableResources = this.advertisementFetchManager.getAvailableResources(this.currentPublicDiskImagesServer);
            assert (allResources != null);
            assert (availableResources != null);
            this.publicFetchOverlay.visibleProperty().unbind();
            this.publicFetchOverlay.visibleProperty().bind((ObservableValue)allResources.currentRefreshAdvertisementTaskProperty().isNotNull());
            assert (allResources.currentRefreshAdvertisementTaskProperty() != null);
            assert (this.publicRefreshTaskInvalidationListener != null);
            allResources.currentRefreshAdvertisementTaskProperty().addListener(this.publicRefreshTaskInvalidationListener);
            this.publicRefreshTaskInvalidationListener.invalidated(null);
        }
        if (this.currentPublicDiskImagesServer == null) {
            return;
        }
        assert (this.currentPublicDiskImagesServer != null);
        allResources = this.advertisementFetchManager.getAllResources(this.currentPublicDiskImagesServer);
        availableResources = this.advertisementFetchManager.getAvailableResources(this.currentPublicDiskImagesServer);
        if (!allResources.isComponentIdsAvailable() && !availableResources.isComponentIdsAvailable()) {
            allResources.refreshAdvertisement();
        } else if (this.config.getDiskImages(this.currentPublicDiskImagesServer).isEmpty()) {
            JFDialogs.create().owner(this.root.getScene().getWindow()).message(String.format("'%s' did not provide any available disk images", this.currentPublicDiskImagesServer.getName())).showWarning();
        }
    }

    private void updatePublicDiskImagesList() {
        this.publicDiskImagesComboBox.getSelectionModel().clearSelection();
        if (this.advancedCheckBox.isSelected()) {
            this.publicDiskImagesComboBox.setItems((ObservableList)this.config.getDiskImages((Server)this.sourceTestbedComboBox.getSelectionModel().getSelectedItem()));
        } else {
            this.publicDiskImagesComboBox.setItems((ObservableList)this.config.getDiskImages(this.nodeResource));
        }
        assert (this.publicDiskImagesComboBox.getItems().stream().allMatch(Objects::nonNull));
    }

    private void updatePrivateDiskImagesComponentManagerInfo(boolean forceRefresh) {
        Server server = (Server)this.sourceTestbedComboBox.getSelectionModel().getSelectedItem();
        if (forceRefresh || this.privateDiskImagesRadioButton.isSelected() && this.currentPrivateDiskImagesServer != server && !this.isLoadingUserImages.get()) {
            LOG.debug("Getting private disk images from {}", (Object)server.getName());
            this.isLoadingUserImages.set(true);
            ListDiskImagesTask listDiskImagesTask = this.hltf.listDiskImages(server);
            this.tt.addTask((Task)listDiskImagesTask, (task, te, state) -> Platform.runLater(() -> {
                this.privateDiskImagesComboBox.getItems().clear();
                if (listDiskImagesTask.getDiskImageInfos() != null) {
                    this.privateDiskImagesComboBox.getItems().setAll((Collection)listDiskImagesTask.getDiskImageInfos());
                }
                if (!this.privateDiskImagesComboBox.getItems().isEmpty()) {
                    this.privateDiskImagesComboBox.getSelectionModel().selectFirst();
                }
                LOG.debug("Updating private images list with {} items from authority {}", listDiskImagesTask.getDiskImageInfos() != null ? Integer.valueOf(listDiskImagesTask.getDiskImageInfos().size()) : "null", (Object)server.getName());
                this.currentPrivateDiskImagesServer = server;
                this.isLoadingUserImages.setValue(Boolean.valueOf(false));
            }));
        }
    }

    public String getDiskImageString() {
        if (this.publicDiskImagesRadioButton.isSelected() && !this.publicDiskImagesComboBox.getSelectionModel().isEmpty()) {
            DiskImage selectedDiskImage = (DiskImage)this.publicDiskImagesComboBox.getSelectionModel().getSelectedItem();
            if (this.nodeResource != null && this.nodeResource.getServer() == this.currentPublicDiskImagesServer) {
                return selectedDiskImage.getName();
            }
            return selectedDiskImage.getUrl();
        }
        if (this.privateDiskImagesRadioButton.isSelected() && !this.privateDiskImagesComboBox.getSelectionModel().isEmpty()) {
            AggregateManagerWrapper.ImageInfo imageInfo = (AggregateManagerWrapper.ImageInfo)this.privateDiskImagesComboBox.getSelectionModel().getSelectedItem();
            if (this.nodeResource != null && this.nodeResource.getServer() == this.currentPrivateDiskImagesServer) {
                return imageInfo.getUrn();
            }
            return imageInfo.getUrl();
        }
        return null;
    }

    private boolean areUserDiskImagesAvailable() {
        return this.aggregateManagerWrapperFactory.getAggregateManagerWrapper((Server)this.sourceTestbedComboBox.getSelectionModel().getSelectedItem()).areUserDiskImageFunctionsSupported();
    }
}

