/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.SelectDiskImageController;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDiskImageDialog
extends Dialog<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SelectDiskImageDialog.class);
    private final SelectDiskImageController controller;

    @Inject
    public SelectDiskImageDialog(GuiceFXMLUtil guiceFXMLUtil) {
        GuiceFXMLUtil.Result fxmlResult = guiceFXMLUtil.createFromFXML(SelectDiskImageController.class);
        this.controller = (SelectDiskImageController)fxmlResult.getController();
        this.setTitle("Select Disk Image");
        this.getDialogPane().setContent((Node)fxmlResult.getRoot());
        this.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.HDD_ALT, (Color)Color.BLACK));
        ButtonType selectDiskImageButtonType = new ButtonType("Select Disk Image", ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{selectDiskImageButtonType, ButtonType.CANCEL});
        this.setResultConverter(param -> {
            if (param == selectDiskImageButtonType) {
                return this.controller.getDiskImageString();
            }
            return null;
        });
    }

    public void setResource(@Nonnull Resource nodeResource) {
        this.controller.setResource(nodeResource);
    }
}

