/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties;

import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.AdaptivePropertiesTab;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.TextFieldWithStatus;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XenTab
extends AdaptivePropertiesTab<FXRspecNode> {
    private static final Logger LOG = LoggerFactory.getLogger(XenTab.class);
    private final AdaptivePropertiesDialog adaptivePropertiesDialog;
    @FXML
    private CheckBox coresCheckBox;
    @FXML
    private CheckBox ramCheckBox;
    @FXML
    private CheckBox diskCheckBox;
    @FXML
    private TextFieldWithStatus coresField;
    @FXML
    private TextFieldWithStatus ramField;
    @FXML
    private TextFieldWithStatus diskField;

    public XenTab(AdaptivePropertiesDialog adaptivePropertiesDialog) {
        super("Xen Options");
        this.adaptivePropertiesDialog = adaptivePropertiesDialog;
        this.setContent((Node)FXMLUtil.createFromFXML((Object)((Object)this)));
        this.coresField.disableProperty().bind((ObservableValue)this.coresCheckBox.selectedProperty().not());
        this.ramField.disableProperty().bind((ObservableValue)this.ramCheckBox.selectedProperty().not());
        this.diskField.disableProperty().bind((ObservableValue)this.diskCheckBox.selectedProperty().not());
        this.coresCheckBox.selectedProperty().addListener((observableValue, aBoolean, aBoolean2) -> {
            if (this.coresCheckBox.isSelected() && this.coresField.getText().trim().isEmpty()) {
                this.coresField.setText("1");
            }
        });
        this.ramCheckBox.selectedProperty().addListener((observableValue, aBoolean, aBoolean2) -> {
            if (this.ramCheckBox.isSelected() && this.ramField.getText().trim().isEmpty()) {
                this.ramField.setText("512");
            }
        });
        this.diskCheckBox.selectedProperty().addListener((observableValue, aBoolean, aBoolean2) -> {
            if (this.diskCheckBox.isSelected() && this.diskField.getText().trim().isEmpty()) {
                this.diskField.setText("8");
            }
        });
    }

    @Override
    public void load(FXRspecNode rspecNode) {
        SliverType sliverType = rspecNode.getSliverType();
        Integer cores = sliverType == null ? null : sliverType.getXenCores();
        Integer ram = sliverType == null ? null : sliverType.getXenRam();
        Integer disk = sliverType == null ? null : sliverType.getXenDisk();
        this.coresCheckBox.setSelected(cores != null);
        this.ramCheckBox.setSelected(ram != null);
        this.diskCheckBox.setSelected(disk != null);
        this.coresField.setText((String)(cores == null ? "" : "" + cores));
        this.ramField.setText((String)(ram == null ? "" : "" + ram));
        this.diskField.setText((String)(disk == null ? "" : "" + disk));
    }

    @Override
    public void save(FXRspecNode rspecNode) {
        try {
            Integer cores = this.coresCheckBox.isSelected() ? Integer.valueOf(Integer.parseInt(this.coresField.getText())) : null;
            Integer ram = this.ramCheckBox.isSelected() ? Integer.valueOf(Integer.parseInt(this.ramField.getText())) : null;
            Integer disk = this.diskCheckBox.isSelected() ? Integer.valueOf(Integer.parseInt(this.diskField.getText())) : null;
            SliverType sliverType = rspecNode.getSliverType();
            if (sliverType != null) {
                SliverType newSliverType = new SliverTypeBuilder(sliverType).xenCores(cores).xenDisk(disk).xenRam(ram).build();
                rspecNode.setSliverType(newSliverType);
            } else {
                LOG.warn("XenTab.save() could not set sliver type: original sliver type is null");
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("XenTab.save() User integer input is invalid: Will not change sliver type", (Throwable)e);
        }
    }

    @Override
    public void onTabShown() {
    }

    @Override
    public boolean shouldBeVisible(FXRspecNode rspecNode) {
        return Objects.equals("emulab-xen", this.adaptivePropertiesDialog.getCurrentSliverTypeName());
    }

    @Override
    public String validateConfiguration() {
        Object errors = "";
        try {
            Integer cores = this.coresCheckBox.isSelected() ? Integer.valueOf(Integer.parseInt(this.coresField.getText())) : null;
            this.coresField.setStatus(TextFieldWithStatus.Status.OK);
        }
        catch (NumberFormatException e) {
            this.coresField.setStatus(TextFieldWithStatus.Status.ERROR);
            errors = (String)errors + "Invalid integer in cores field";
        }
        try {
            Integer ram = this.ramCheckBox.isSelected() ? Integer.valueOf(Integer.parseInt(this.ramField.getText())) : null;
            this.ramField.setStatus(TextFieldWithStatus.Status.OK);
        }
        catch (NumberFormatException e) {
            this.ramField.setStatus(TextFieldWithStatus.Status.ERROR);
            if (!((String)errors).isEmpty()) {
                errors = (String)errors + "\n";
            }
            errors = (String)errors + "Invalid integer in RAM field";
        }
        try {
            Integer disk = this.diskCheckBox.isSelected() ? Integer.valueOf(Integer.parseInt(this.diskField.getText())) : null;
            this.diskField.setStatus(TextFieldWithStatus.Status.OK);
        }
        catch (NumberFormatException e) {
            this.diskField.setStatus(TextFieldWithStatus.Status.ERROR);
            if (!((String)errors).isEmpty()) {
                errors = (String)errors + "\n";
            }
            errors = (String)errors + "Invalid integer in disk field";
        }
        if (((String)errors).isEmpty()) {
            return null;
        }
        return errors;
    }

    public void onHelpLinkClicked() {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI("http://doc.ilabt.iminds.be/ilabt-documentation/urnsrspecs.html#xen-vm-options"));
            }
            catch (IOException | URISyntaxException e) {
                LOG.warn("Exception starting browser", (Throwable)e);
            }
        }
    }
}

