/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map;

import be.iminds.ilabt.jfed.experimenter_gui.config.ImageMap;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.SequentialTransition;
import javafx.animation.StrokeTransition;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;

public class ImageMapDialog {
    private static final double MAX_ZOOM = 1.5;
    private static final double MIN_ZOOM = 0.01;
    @FXML
    private BorderPane root;
    private ImageMap<GeniUrn> imageMap;
    private Collection<JFedGuiConfig.ComponentInfo> availableNodes;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private ScrollPane imageScrollPane;
    @FXML
    private ImageView imageView;
    @FXML
    private ComboBox<JFedGuiConfig.ComponentInfo> nodesComboBox;
    @FXML
    private Button selectNodeButton;
    @FXML
    private Label noLocationLabel;
    @FXML
    private Rectangle selectedNodeRectangle;
    private Transition selectedNodeStrokeTransition;
    private final DoubleProperty zoom = new SimpleDoubleProperty(1.0);
    private JFedGuiConfig.ComponentInfo result = null;
    private Image image;
    private static final Color TRANSPARENT_GRAY = Color.gray((double)0.3, (double)0.5);
    private final Map<GeniUrn, Rectangle> rectangles = new HashMap<GeniUrn, Rectangle>();

    @FXML
    private void initialize() {
        this.nodesComboBox.setConverter(StringConverters.COMPONENT_INFO_CONVERTER);
        this.noLocationLabel.managedProperty().bind((ObservableValue)this.noLocationLabel.visibleProperty());
        this.selectNodeButton.disableProperty().bind((ObservableValue)this.nodesComboBox.valueProperty().isNull());
        this.imageScrollPane.addEventFilter(ScrollEvent.ANY, scrollEvent -> {
            if (scrollEvent.isControlDown()) {
                double newZoom = this.zoom.get() + scrollEvent.getDeltaY() / 100.0;
                if (newZoom >= 0.01 && newZoom <= 1.5) {
                    this.zoom.set(newZoom);
                }
                scrollEvent.consume();
            }
        });
        this.zoom.addListener(observable -> {
            this.imageView.setFitWidth(this.imageView.getImage().getWidth() * this.zoom.get());
            this.rectangles.values().forEach(rect -> {
                rect.setScaleX(this.zoom.get());
                rect.setScaleY(this.zoom.get());
            });
        });
        this.root.sceneProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                ImageMapDialog.this.root.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.D, KeyCombination.ModifierValue.UP, KeyCombination.ModifierValue.DOWN, KeyCombination.ModifierValue.UP, KeyCombination.ModifierValue.UP, KeyCombination.ModifierValue.UP), () -> ImageMapDialog.this.showDebugInfo());
                observable.removeListener((InvalidationListener)this);
            }
        });
        this.selectedNodeStrokeTransition = new SequentialTransition(new Animation[]{new StrokeTransition(Duration.millis((double)300.0), (Shape)this.selectedNodeRectangle, Color.RED, Color.ORANGE), new StrokeTransition(Duration.millis((double)300.0), (Shape)this.selectedNodeRectangle, Color.ORANGE, Color.YELLOW), new StrokeTransition(Duration.millis((double)300.0), (Shape)this.selectedNodeRectangle, Color.YELLOW, Color.GREEN), new StrokeTransition(Duration.millis((double)300.0), (Shape)this.selectedNodeRectangle, Color.GREEN, Color.BLUE), new StrokeTransition(Duration.millis((double)300.0), (Shape)this.selectedNodeRectangle, Color.BLUE, Color.INDIGO), new StrokeTransition(Duration.millis((double)300.0), (Shape)this.selectedNodeRectangle, Color.INDIGO, Color.VIOLET), new StrokeTransition(Duration.millis((double)300.0), (Shape)this.selectedNodeRectangle, Color.VIOLET, Color.RED)});
        this.selectedNodeStrokeTransition.setCycleCount(-1);
        this.nodesComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.selectedNodeRectangle.xProperty().unbind();
            this.selectedNodeRectangle.yProperty().unbind();
            this.selectedNodeRectangle.widthProperty().unbind();
            this.selectedNodeRectangle.heightProperty().unbind();
            if (newValue != null) {
                Optional bounds = this.imageMap.getSelectableRegion((Object)newValue.getUrn());
                if (bounds.isPresent()) {
                    this.selectedNodeRectangle.xProperty().bind((ObservableValue)this.zoom.multiply(((ImageMap.Bounds)bounds.get()).getMinX()));
                    this.selectedNodeRectangle.yProperty().bind((ObservableValue)this.zoom.multiply(((ImageMap.Bounds)bounds.get()).getMinY()));
                    this.selectedNodeRectangle.widthProperty().bind((ObservableValue)this.zoom.multiply(((ImageMap.Bounds)bounds.get()).getMaxX() - ((ImageMap.Bounds)bounds.get()).getMinX()));
                    this.selectedNodeRectangle.heightProperty().bind((ObservableValue)this.zoom.multiply(((ImageMap.Bounds)bounds.get()).getMaxY() - ((ImageMap.Bounds)bounds.get()).getMinY()));
                    this.selectedNodeRectangle.setVisible(true);
                    this.selectedNodeStrokeTransition.playFromStart();
                }
                this.noLocationLabel.setVisible(!bounds.isPresent());
            } else {
                this.selectedNodeRectangle.setVisible(false);
                this.selectedNodeStrokeTransition.stop();
                this.noLocationLabel.setVisible(false);
            }
        });
    }

    private void showDebugInfo() {
        this.rectangles.values().forEach(rect -> {
            rect.setStrokeWidth(2.0);
            rect.setStroke((Paint)Color.BLUE);
            rect.setMouseTransparent(true);
        });
    }

    public void setNodesMap(ImageMap<GeniUrn> imageMap, Collection<JFedGuiConfig.ComponentInfo> availableNodes) {
        assert (this.imageMap == null);
        this.imageMap = imageMap;
        this.availableNodes = availableNodes;
        this.nodesComboBox.getItems().addAll(availableNodes);
        this.image = new Image(imageMap.getImageUrl().toExternalForm());
        this.imageView.setImage(this.image);
        for (Map.Entry entry : imageMap.getSelectableRegions().entrySet()) {
            ImageMap.Bounds b = (ImageMap.Bounds)entry.getKey();
            Rectangle rect = new Rectangle();
            rect.xProperty().bind((ObservableValue)this.zoom.multiply(b.getMinX()));
            rect.yProperty().bind((ObservableValue)this.zoom.multiply(b.getMinY()));
            rect.widthProperty().bind((ObservableValue)this.zoom.multiply(b.getMaxX() - b.getMinX()));
            rect.heightProperty().bind((ObservableValue)this.zoom.multiply(b.getMaxY() - b.getMinY()));
            Optional<JFedGuiConfig.ComponentInfo> availableNode = availableNodes.stream().filter(node -> Objects.equals(entry.getValue(), node.getUrn())).findFirst();
            if (availableNode.isPresent()) {
                rect.setFill((Paint)Color.TRANSPARENT);
                rect.setCursor(Cursor.HAND);
                rect.setOnMouseClicked(mouseEvent -> this.nodesComboBox.setValue((Object)((JFedGuiConfig.ComponentInfo)availableNode.get())));
            } else {
                rect.setFill((Paint)TRANSPARENT_GRAY);
            }
            this.rectangles.put((GeniUrn)entry.getValue(), rect);
            this.anchorPane.getChildren().add((Object)rect);
        }
    }

    @FXML
    private void selectNode() {
        this.result = (JFedGuiConfig.ComponentInfo)this.nodesComboBox.getValue();
        ((Stage)this.selectNodeButton.getScene().getWindow()).close();
    }

    public JFedGuiConfig.ComponentInfo getResult() {
        return this.result;
    }

    public void setupStageSize(Stage dialogStage) {
        dialogStage.setMinHeight(480.0);
        dialogStage.setMinWidth(640.0);
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        double height = this.root.getHeight() < primaryScreenBounds.getHeight() ? this.root.getHeight() : primaryScreenBounds.getHeight();
        double width = this.root.getWidth() < primaryScreenBounds.getWidth() ? this.root.getWidth() : primaryScreenBounds.getWidth();
        dialogStage.setX(primaryScreenBounds.getMinX() + (primaryScreenBounds.getWidth() - width) / 2.0);
        dialogStage.setY(primaryScreenBounds.getMinY() + (primaryScreenBounds.getHeight() - height) / 2.0);
        dialogStage.setWidth(width);
        dialogStage.setHeight(height);
        double widthZoomFactor = this.imageScrollPane.getViewportBounds().getWidth() / this.image.getWidth();
        double heightZoomFactor = this.imageScrollPane.getViewportBounds().getHeight() / this.image.getHeight();
        System.out.println(widthZoomFactor + ", " + heightZoomFactor);
        this.zoom.set(Math.min(Math.min(widthZoomFactor, heightZoomFactor), this.zoom.get()));
    }

    public void setAvailableNodes(Collection<JFedGuiConfig.ComponentInfo> availableNodes) {
        assert (this.imageMap != null);
        for (Map.Entry<GeniUrn, Rectangle> entry : this.rectangles.entrySet()) {
        }
    }
}

