/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map;

import be.iminds.ilabt.jfed.experimenter_gui.config.ImageMap;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map.ImageMapDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map.NodesMapDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map.TestbedsMapDialog;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.FXUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MapDialogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MapDialogFactory.class);
    private static final String TESTBEDS_MAP_DIALOG_FXML = "TestbedsMapDialog.fxml";
    private static final String NODES_MAP_DIALOG_FXML = "NodesMapDialog.fxml";
    private static final String IMAGE_MAP_DIALOG_FXML = "ImageMapDialog.fxml";
    private final Provider<FXMLLoader> fxmlLoaderProvider;

    @Inject
    public MapDialogFactory(Provider<FXMLLoader> fxmlLoaderProvider) {
        this.fxmlLoaderProvider = fxmlLoaderProvider;
    }

    public Resource showTestbedMapDialog(Window parent, @Nonnull JFedGuiConfig guiConfig, ResourceClass resourceClass) {
        try {
            FXMLLoader loader = (FXMLLoader)this.fxmlLoaderProvider.get();
            loader.setLocation(this.getClass().getResource(TESTBEDS_MAP_DIALOG_FXML));
            Scene scene = new Scene((Parent)loader.load());
            TestbedsMapDialog controller = (TestbedsMapDialog)loader.getController();
            controller.setGuiConfig(guiConfig);
            controller.setCmiManager(resourceClass);
            Stage dialogStage = new Stage();
            StageUtils.setJFedStageIcons((Stage)dialogStage);
            dialogStage.setScene(scene);
            dialogStage.setTitle("Map of available testbeds");
            dialogStage.setResizable(true);
            FXUtils.centerToOwner(parent, (Window)dialogStage);
            dialogStage.showAndWait();
            return controller.getResult();
        }
        catch (IOException e) {
            LOG.error("Error while creating testbeds map view", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public JFedGuiConfig.ComponentInfo showNodeMapDialog(Window parent, List<JFedGuiConfig.ComponentInfo> nodes) {
        try {
            FXMLLoader loader = (FXMLLoader)this.fxmlLoaderProvider.get();
            loader.setLocation(this.getClass().getResource(NODES_MAP_DIALOG_FXML));
            Scene scene = new Scene((Parent)loader.load());
            NodesMapDialog controller = (NodesMapDialog)loader.getController();
            controller.setNodes(nodes);
            Stage dialogStage = new Stage();
            StageUtils.setJFedStageIcons((Stage)dialogStage);
            dialogStage.setScene(scene);
            dialogStage.setTitle("Map of available nodes");
            dialogStage.setResizable(true);
            FXUtils.centerToOwner(parent, (Window)dialogStage);
            dialogStage.showAndWait();
            return controller.getResult();
        }
        catch (IOException e) {
            LOG.error("Error while creating testbeds map view", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public JFedGuiConfig.ComponentInfo showNodeImageMapDialog(Window parent, ImageMap<GeniUrn> imageMap, Collection<JFedGuiConfig.ComponentInfo> availableNodes) {
        try {
            FXMLLoader loader = (FXMLLoader)this.fxmlLoaderProvider.get();
            loader.setLocation(this.getClass().getResource(IMAGE_MAP_DIALOG_FXML));
            Scene scene = new Scene((Parent)loader.load());
            ImageMapDialog controller = (ImageMapDialog)loader.getController();
            controller.setNodesMap(imageMap, availableNodes);
            Stage dialogStage = new Stage();
            StageUtils.setJFedStageIcons((Stage)dialogStage);
            dialogStage.setScene(scene);
            dialogStage.setTitle("Image map of nodes");
            dialogStage.setResizable(true);
            dialogStage.sizeToScene();
            ObservableList screens = Screen.getScreensForRectangle((double)dialogStage.getX(), (double)dialogStage.getY(), (double)dialogStage.getWidth(), (double)dialogStage.getHeight());
            double maxHeight = screens.stream().mapToDouble(screen -> screen.getVisualBounds().getHeight()).min().orElse(dialogStage.getHeight());
            double maxWidth = screens.stream().mapToDouble(screen -> screen.getVisualBounds().getWidth()).min().orElse(dialogStage.getWidth());
            dialogStage.setHeight(Double.min(dialogStage.getHeight(), maxHeight));
            dialogStage.setWidth(Double.min(dialogStage.getWidth(), maxWidth));
            dialogStage.showAndWait();
            return controller.getResult();
        }
        catch (IOException e) {
            LOG.error("Error while creating testbeds map view", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

