/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import de.saring.leafletmap.ColorMarkerIcon;
import de.saring.leafletmap.ControlPosition;
import de.saring.leafletmap.LatLong;
import de.saring.leafletmap.LeafletMapView;
import de.saring.leafletmap.MapConfig;
import de.saring.leafletmap.MapLayer;
import de.saring.leafletmap.Marker;
import de.saring.leafletmap.MarkerClusterGroup;
import de.saring.leafletmap.MarkerIcon;
import de.saring.leafletmap.ScaleControlConfig;
import de.saring.leafletmap.ZoomControlConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodesMapDialog {
    private static final Logger LOG = LoggerFactory.getLogger(NodesMapDialog.class);
    @FXML
    private BorderPane root;
    private LeafletMapView mapView;
    @FXML
    private ComboBox<JFedGuiConfig.ComponentInfo> nodesComboBox;
    @FXML
    private Button selectNodeButton;
    private boolean mapViewIsInitialized = false;
    private ObservableList<JFedGuiConfig.ComponentInfo> nodes = null;
    private final Map<JFedGuiConfig.ComponentInfo, LatLong> nodeLocations = new HashMap<JFedGuiConfig.ComponentInfo, LatLong>();
    private FilteredList<JFedGuiConfig.ComponentInfo> nodesWithinBounds;
    private JFedGuiConfig.ComponentInfo result = null;

    @FXML
    private void initialize() {
        this.mapView = new LeafletMapView();
        this.root.setCenter((Node)this.mapView);
        this.initializeMap();
        this.nodesComboBox.setConverter(StringConverters.COMPONENT_INFO_CONVERTER);
        this.selectNodeButton.disableProperty().bind((ObservableValue)this.nodesComboBox.valueProperty().isNull());
        this.nodesComboBox.setOnAction(event -> {
            JFedGuiConfig.ComponentInfo node = (JFedGuiConfig.ComponentInfo)this.nodesComboBox.getValue();
            if (node != null && this.nodeLocations.get(node) != null) {
                this.mapView.panTo(this.nodeLocations.get(node));
                this.mapView.setZoom(18);
            }
        });
    }

    private void initializeMap() {
        MapConfig mapConfig = new MapConfig(Collections.singletonList(MapLayer.OPENSTREETMAP), new ZoomControlConfig(true, ControlPosition.BOTTOM_LEFT), new ScaleControlConfig(true, ControlPosition.BOTTOM_RIGHT, true));
        this.mapView.displayMap(mapConfig).whenCompleteAsync((state, throwable) -> {
            this.mapViewIsInitialized = true;
            this.tryInitializeMap();
        }, Platform::runLater);
    }

    private void tryInitializeMap() {
        if (this.nodes == null) {
            return;
        }
        if (!this.mapViewIsInitialized) {
            return;
        }
        LOG.debug("Initialising nodesMap for " + this.nodes.size() + " nodes on " + this.nodeLocations.size() + " locations.");
        ArrayList markerList = new ArrayList();
        this.nodes.stream().filter(JFedGuiConfig.ComponentInfo::hasLocation).forEach(node -> {
            try {
                String title = node.getUrn().getEncodedResourceName();
                LatLong position = new LatLong(Double.parseDouble(node.getLocation().getLatitude()), Double.parseDouble(node.getLocation().getLongitude()));
                this.nodeLocations.put((JFedGuiConfig.ComponentInfo)node, position);
                Marker mcm = new Marker(position, title, (MarkerIcon)ColorMarkerIcon.BLUE_MARKER, 0);
                mcm.setOnClickEventHandler(event -> this.selectNode((JFedGuiConfig.ComponentInfo)node));
                markerList.add(mcm);
                LOG.trace("Adding marker {} at location {}", (Object)title, (Object)node.getLocation());
            }
            catch (Exception ex) {
                LOG.error("Could not add node {} to map", (Object)node.getUrn());
            }
        });
        MarkerClusterGroup mcg = new MarkerClusterGroup(markerList);
        this.mapView.addMarkerClusterGroup(mcg);
    }

    private void clearNodeSelection() {
        this.nodesComboBox.setValue(null);
    }

    private void selectNode(JFedGuiConfig.ComponentInfo node) {
        assert (node.getLocation() != null);
        this.mapView.panTo(this.nodeLocations.get(node));
        this.nodesComboBox.setValue((Object)node);
    }

    public void setNodes(List<JFedGuiConfig.ComponentInfo> nodes) {
        if (this.nodes != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.nodes = FXCollections.observableList(nodes);
        this.nodesWithinBounds = new FilteredList(this.nodes);
        this.nodesComboBox.setItems(this.nodesWithinBounds);
        this.tryInitializeMap();
    }

    @FXML
    private void selectNode() {
        this.result = (JFedGuiConfig.ComponentInfo)this.nodesComboBox.getValue();
        ((Stage)this.selectNodeButton.getScene().getWindow()).close();
    }

    public JFedGuiConfig.ComponentInfo getResult() {
        return this.result;
    }
}

