/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import de.saring.leafletmap.ColorMarkerIcon;
import de.saring.leafletmap.ControlPosition;
import de.saring.leafletmap.LatLong;
import de.saring.leafletmap.LeafletMapView;
import de.saring.leafletmap.MapConfig;
import de.saring.leafletmap.MapLayer;
import de.saring.leafletmap.Marker;
import de.saring.leafletmap.MarkerClusterGroup;
import de.saring.leafletmap.MarkerIcon;
import de.saring.leafletmap.ScaleControlConfig;
import de.saring.leafletmap.ZoomControlConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedsMapDialog {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedsMapDialog.class);
    private LeafletMapView mapView;
    @FXML
    private BorderPane root;
    @FXML
    private Label testbedNameLabel;
    @FXML
    private Label testbedCountryLabel;
    @FXML
    private Button selectTestbedButton;
    private boolean mapViewIsInitialized = false;
    private ResourceClass resourceClass = null;
    private JFedGuiConfig guiConfig = null;
    private final ObjectProperty<Resource> selectedResource = new SimpleObjectProperty();
    private Resource result = null;

    @FXML
    private void initialize() {
        this.mapView = new LeafletMapView();
        this.initializeMap();
        this.root.setCenter((Node)this.mapView);
        this.selectTestbedButton.disableProperty().bind((ObservableValue)this.selectedResource.isNull());
    }

    private void initializeMap() {
        MapConfig mapConfig = new MapConfig(Collections.singletonList(MapLayer.OPENSTREETMAP), new ZoomControlConfig(true, ControlPosition.BOTTOM_LEFT), new ScaleControlConfig(true, ControlPosition.BOTTOM_RIGHT, true));
        this.mapView.displayMap(mapConfig).whenCompleteAsync((state, throwable) -> {
            if (state == Worker.State.SUCCEEDED) {
                this.mapViewIsInitialized = true;
                try {
                    this.tryInitializeMap();
                }
                catch (Throwable t) {
                    LOG.error("Failed to initialize map", t);
                    throw t;
                }
            } else {
                LOG.error("Map did not initialize successfully: {}", state, throwable);
            }
        }, Platform::runLater);
    }

    private void tryInitializeMap() {
        if (this.resourceClass == null) {
            return;
        }
        if (!this.mapViewIsInitialized) {
            return;
        }
        Predicate<Server> includeServerPredicate = s -> s.getTestbed() == null || s.getName() == null || !s.getTestbed().getCategoryNames().contains("offline") && !s.getTestbed().getCategoryNames().contains("test") && !s.getTestbed().getCategoryNames().contains("scs") && !s.getTestbed().getCategoryNames().contains("tmp") && !s.getName().contains("fedmon testing only");
        int serverCount = 0;
        ArrayList<Marker> markersList = new ArrayList<Marker>();
        TreeSet<Integer> serverIds = new TreeSet<Integer>();
        for (Resource curResource2 : this.resourceClass.getResources()) {
            Server server = curResource2.getServer();
            if (server.getLocation() == null || !includeServerPredicate.test(server)) continue;
            serverIds.add((Integer)server.getId());
            ++serverCount;
            LatLong authLatLong = new LatLong(server.getLocation().getLatitude().doubleValue(), server.getLocation().getLongitude().doubleValue());
            String safeServerName = server.getName().replaceAll("['\"]", "");
            Marker marker = new Marker(authLatLong, safeServerName, (MarkerIcon)ColorMarkerIcon.BLUE_MARKER, 0);
            marker.setOnClickEventHandler(event -> this.selectTestbed(curResource2));
            markersList.add(marker);
            LOG.debug("Adding marker {} at location {}", (Object)server.getName(), (Object)server.getLocation());
        }
        if (((String)this.resourceClass.getId()).startsWith("generic-node-")) {
            for (Server server : this.guiConfig.getAllServersInVisibleResources()) {
                if (serverIds.contains(server.getId()) || server.getLocation() == null || !includeServerPredicate.test(server)) continue;
                serverIds.add((Integer)server.getId());
                ++serverCount;
                LatLong authLatLong = new LatLong(server.getLocation().getLatitude().doubleValue(), server.getLocation().getLongitude().doubleValue());
                String safeServerName = server.getName().replaceAll("['\"]", "");
                Marker authMarker = new Marker(authLatLong, safeServerName, (MarkerIcon)ColorMarkerIcon.BLUE_MARKER, 0);
                this.guiConfig.findAllPossibleResources(server).stream().findFirst().ifPresent(curResource -> authMarker.setOnClickEventHandler(event -> this.selectTestbed((Resource)curResource)));
                LOG.debug("Adding extra marker for {} at location lat={} long={}", new Object[]{server.getName(), server.getLocation().getLatitude(), server.getLocation().getLongitude()});
                markersList.add(authMarker);
            }
        }
        MarkerClusterGroup mcg = new MarkerClusterGroup(markersList);
        this.mapView.addMarkerClusterGroup(mcg);
        LOG.info("Displaying {} servers on the map", (Object)serverCount);
        this.mapView.fitBoundsOfMarkerClusterGroup(mcg);
    }

    private void selectTestbed(Resource resource) {
        Server auth = resource.getServer();
        this.mapView.panTo(new LatLong(auth.getLocation().getLatitude().doubleValue(), auth.getLocation().getLongitude().doubleValue()));
        this.testbedNameLabel.setText(auth.getName());
        String address = auth.getLocation().getAddress() != null ? "  Address: " + auth.getLocation().getAddress() : "";
        this.testbedCountryLabel.setText("Country: " + auth.getLocation().getCountryCode() + address);
        this.selectedResource.setValue((Object)resource);
    }

    public void setGuiConfig(JFedGuiConfig guiConfig) {
        this.guiConfig = guiConfig;
    }

    public void setCmiManager(ResourceClass resourceClass) {
        this.resourceClass = resourceClass;
        try {
            this.tryInitializeMap();
        }
        catch (Throwable t) {
            LOG.error("Failed to initialize map", t);
            throw t;
        }
    }

    @FXML
    private void selectTestbed() {
        this.result = (Resource)this.selectedResource.get();
        ((Stage)this.selectTestbedButton.getScene().getWindow()).close();
    }

    public Resource getResult() {
        return this.result;
    }
}

